/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import javax.ws.rs.core.MediaType;

public final class OutboundEvent {
    private final String name;
    private final String comment;
    private final String id;
    private final Class type;
    private final MediaType mediaType;
    private final Object data;

    OutboundEvent(String name, String id, Class type2, MediaType mediaType, Object data, String comment) {
        this.name = name;
        this.comment = comment;
        this.id = id;
        this.type = type2;
        this.mediaType = mediaType;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Class getType() {
        return this.type;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getComment() {
        return this.comment;
    }

    public Object getData() {
        return this.data;
    }

    public static class Builder {
        private String name;
        private String comment;
        private String id;
        private Class type;
        private Object data;
        private MediaType mediaType = MediaType.TEXT_PLAIN_TYPE;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder data(Class type2, Object data) {
            if (type2 == null || data == null) {
                throw new IllegalArgumentException();
            }
            this.type = type2;
            this.data = data;
            return this;
        }

        public OutboundEvent build() throws IllegalStateException {
            if (this.comment == null && this.data == null && this.type == null) {
                throw new IllegalStateException();
            }
            return new OutboundEvent(this.name, this.id, this.type, this.mediaType, this.data, this.comment);
        }
    }
}

