/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.sse;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;
import org.glassfish.jersey.message.MessageBodyWorkers;

@ConstrainedTo(value=RuntimeType.CLIENT)
public class InboundEventReader
implements MessageBodyReader<InboundEvent> {
    private static final byte[] EOL_DATA = new byte[]{10};
    @Inject
    private Provider<MessageBodyWorkers> messageBodyWorkers;

    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return InboundEvent.class.equals(type2) && mediaType.equals(SseFeature.SERVER_SENT_EVENTS_TYPE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public InboundEvent readFrom(Class<InboundEvent> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream entityStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream tokenData = new ByteArrayOutputStream();
        InboundEvent.Builder eventBuilder = new InboundEvent.Builder(this.messageBodyWorkers.get(), annotations, mediaType, headers);
        int b = -1;
        State currentState = State.NEW_LINE;
        do {
            switch (currentState) {
                case NEW_LINE: {
                    b = entityStream.read();
                    if (b == 10) return eventBuilder.build();
                    if (b == -1) {
                        return eventBuilder.build();
                    }
                    if (b == 58) {
                        currentState = State.COMMENT;
                        break;
                    }
                    tokenData.write(b);
                    currentState = State.FIELD;
                    break;
                }
                case COMMENT: {
                    b = this.readLineUntil(entityStream, 10, null);
                    currentState = State.NEW_LINE;
                    break;
                }
                case FIELD: {
                    b = this.readLineUntil(entityStream, 58, tokenData);
                    String fieldName = tokenData.toString();
                    tokenData.reset();
                    if (b == 58) {
                        b = entityStream.read();
                        if (b == 32) {
                            b = entityStream.read();
                        }
                        if (b != 10 && b != -1) {
                            tokenData.write(b);
                            b = this.readLineUntil(entityStream, 10, tokenData);
                        }
                    }
                    this.processField(eventBuilder, fieldName, tokenData.toByteArray());
                    tokenData.reset();
                    currentState = State.NEW_LINE;
                }
            }
        } while (b != -1);
        return eventBuilder.build();
    }

    private int readLineUntil(InputStream in, int delimiter, OutputStream out) throws IOException {
        int b;
        while ((b = in.read()) != -1 && b != delimiter && b != 10) {
            if (out == null) continue;
            out.write(b);
        }
        return b;
    }

    private void processField(InboundEvent.Builder inboundEventBuilder, String name, byte[] value) {
        if ("event".equals(name)) {
            inboundEventBuilder.name(new String(value));
        } else if ("data".equals(name)) {
            inboundEventBuilder.data(value);
            inboundEventBuilder.data(EOL_DATA);
        } else if ("id".equals(name)) {
            String s = new String(value);
            try {
                Integer.parseInt(new String(value));
            }
            catch (NumberFormatException nfe) {
                s = "";
            }
            inboundEventBuilder.id(s);
        } else if ("retry".equals(name)) {
            // empty if block
        }
    }

    private static enum State {
        NEW_LINE,
        COMMENT,
        FIELD;

    }
}

