/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public class PropertiesHelper {
    public static <T> T getValue(Map<String, ?> properties, String key, T defaultValue) {
        return PropertiesHelper.getValue(properties, key, defaultValue, defaultValue.getClass());
    }

    public static <T> T getValue(Map<String, ?> properties, String key, T defaultValue, Class<T> type2) {
        T value = PropertiesHelper.getValue(properties, key, type2);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static <T> T getValue(Map<String, ?> properties, String key, Class<T> type2) {
        Object value = properties.get(key);
        if (value == null) {
            return null;
        }
        if (!type2.isInstance(value)) {
            Method valueOf;
            Constructor constructor = ReflectionHelper.getStringConstructor(type2);
            if (constructor != null) {
                try {
                    return type2.cast(constructor.newInstance(value));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((valueOf = ReflectionHelper.getValueOfStringMethod(type2)) != null) {
                try {
                    return type2.cast(valueOf.invoke(null, value));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return null;
        }
        return type2.cast(value);
    }

    public static boolean isProperty(Map<String, Object> properties, String name) {
        return properties.containsKey(name) && PropertiesHelper.isProperty(properties.get(name));
    }

    public static boolean isProperty(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)Boolean.class.cast(value);
        }
        return value != null && Boolean.parseBoolean(value.toString());
    }
}

