/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.inject;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.FactoryDescriptors;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.HK2Loader;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.Binder;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.jersey.internal.inject.AbstractBindingBuilder;
import org.glassfish.jersey.internal.inject.ScopedBindingBuilder;
import org.glassfish.jersey.internal.inject.ServiceBindingBuilder;

public abstract class AbstractBinder
implements Binder,
DynamicConfiguration {
    private transient DynamicConfiguration configuration;
    private transient AbstractBindingBuilder<?> currentBuilder;
    private transient HK2Loader defaultLoader;

    public <T> ServiceBindingBuilder<T> bind(Class<T> serviceType) {
        return this.resetBuilder(AbstractBindingBuilder.create(serviceType, false));
    }

    public <T> ServiceBindingBuilder<T> bindAsContract(Class<T> serviceType) {
        return this.resetBuilder(AbstractBindingBuilder.create(serviceType, true));
    }

    public <T> ServiceBindingBuilder<T> bindAsContract(TypeLiteral<T> serviceType) {
        return this.resetBuilder(AbstractBindingBuilder.create(serviceType, true));
    }

    public <T> ScopedBindingBuilder<T> bind(T service) {
        return this.resetBuilder(AbstractBindingBuilder.create(service));
    }

    public <T> ServiceBindingBuilder<T> bindFactory(Class<? extends Factory<T>> factoryType, Class<? extends Annotation> factoryScope) {
        return this.resetBuilder(AbstractBindingBuilder.createFactoryBinder(factoryType, factoryScope));
    }

    public <T> ServiceBindingBuilder<T> bindFactory(Class<? extends Factory<T>> factoryType) {
        return this.resetBuilder(AbstractBindingBuilder.createFactoryBinder(factoryType, null));
    }

    public <T> ServiceBindingBuilder<T> bindFactory(Factory<T> factory) {
        return this.resetBuilder(AbstractBindingBuilder.createFactoryBinder(factory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(DynamicConfiguration configuration) {
        Preconditions.checkState(this.configuration == null, "Recursive configuration call detected.");
        this.configuration = Preconditions.checkNotNull(configuration, "configuration");
        try {
            this.configure();
        }
        finally {
            this.complete();
        }
    }

    private <T> AbstractBindingBuilder<T> resetBuilder(AbstractBindingBuilder<T> newBuilder) {
        if (this.currentBuilder != null) {
            this.currentBuilder.complete(this.configuration(), this.getDefaultBinderLoader());
        }
        this.currentBuilder = newBuilder;
        return newBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void complete() {
        try {
            this.resetBuilder(null);
        }
        finally {
            this.configuration = null;
        }
    }

    protected abstract void configure();

    private DynamicConfiguration configuration() {
        Preconditions.checkState(this.configuration != null, "Dynamic configuration accessed from outside of an active binder configuration scope.");
        return this.configuration;
    }

    @Override
    public <T> ActiveDescriptor<T> bind(Descriptor descriptor) {
        this.setLoader(descriptor);
        return this.configuration().bind(descriptor);
    }

    @Override
    public FactoryDescriptors bind(FactoryDescriptors factoryDescriptors) {
        this.setLoader(factoryDescriptors.getFactoryAsAService());
        this.setLoader(factoryDescriptors.getFactoryAsAFactory());
        return this.configuration().bind(factoryDescriptors);
    }

    @Override
    public <T> ActiveDescriptor<T> addActiveDescriptor(ActiveDescriptor<T> activeDescriptor) throws IllegalArgumentException {
        return this.configuration().addActiveDescriptor(activeDescriptor);
    }

    @Override
    public <T> ActiveDescriptor<T> addActiveDescriptor(Class<T> rawClass) throws MultiException, IllegalArgumentException {
        return this.configuration().addActiveDescriptor(rawClass);
    }

    @Override
    public void addUnbindFilter(Filter unbindFilter) throws IllegalArgumentException {
        this.configuration().addUnbindFilter(unbindFilter);
    }

    @Override
    public void commit() throws MultiException {
        this.configuration().commit();
    }

    public final void install(Binder ... binders) {
        for (Binder binder : binders) {
            binder.bind(this);
        }
    }

    private void setLoader(Descriptor descriptor) {
        if (descriptor.getLoader() == null && descriptor instanceof DescriptorImpl) {
            ((DescriptorImpl)descriptor).setLoader(this.getDefaultBinderLoader());
        }
    }

    private HK2Loader getDefaultBinderLoader() {
        if (this.defaultLoader == null) {
            ClassLoader loader = this.getClass().getClassLoader();
            final ClassLoader binderClassLoader = loader == null ? ClassLoader.getSystemClassLoader() : loader;
            this.defaultLoader = new HK2Loader(){

                @Override
                public Class<?> loadClass(String className) throws MultiException {
                    try {
                        return binderClassLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        throw new MultiException(e);
                    }
                }
            };
        }
        return this.defaultLoader;
    }
}

