/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import java.io.IOException;
import java.net.URI;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.internal.ProcessingException;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class GrizzlyHttpServerFactory {
    public static HttpServer createHttpServer(URI uri) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (GrizzlyHttpContainer)null, false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, boolean start) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, (GrizzlyHttpContainer)null, false, null, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, ContainerFactory.createContainer(GrizzlyHttpContainer.class, configuration), false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean start) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, ContainerFactory.createContainer(GrizzlyHttpContainer.class, configuration), false, null, start);
    }

    public static HttpServer createHttpServer(URI uri, ApplicationHandler appHandler) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(appHandler), false, null, true);
    }

    public static HttpServer createHttpServer(URI uri, ApplicationHandler appHandler, boolean start) throws ProcessingException {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(appHandler), false, null, start);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean secure, SSLEngineConfigurator sslEngineConfigurator) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, ContainerFactory.createContainer(GrizzlyHttpContainer.class, configuration), secure, sslEngineConfigurator, true);
    }

    public static HttpServer createHttpServer(URI uri, ResourceConfig configuration, boolean secure, SSLEngineConfigurator sslEngineConfigurator, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, ContainerFactory.createContainer(GrizzlyHttpContainer.class, configuration), secure, sslEngineConfigurator, start);
    }

    public static HttpServer createHttpServer(URI uri, ApplicationHandler appHandler, boolean secure, SSLEngineConfigurator sslEngineConfigurator) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(appHandler), secure, sslEngineConfigurator, true);
    }

    public static HttpServer createHttpServer(URI uri, ApplicationHandler appHandler, boolean secure, SSLEngineConfigurator sslEngineConfigurator, boolean start) {
        return GrizzlyHttpServerFactory.createHttpServer(uri, new GrizzlyHttpContainer(appHandler), secure, sslEngineConfigurator, start);
    }

    private static HttpServer createHttpServer(URI uri, GrizzlyHttpContainer handler, boolean secure, SSLEngineConfigurator sslEngineConfigurator, boolean start) throws ProcessingException {
        String host = uri.getHost() == null ? "0.0.0.0" : uri.getHost();
        int port = uri.getPort() == -1 ? 80 : uri.getPort();
        HttpServer server = new HttpServer();
        NetworkListener listener = new NetworkListener("grizzly", host, port);
        listener.setSecure(secure);
        if (sslEngineConfigurator != null) {
            listener.setSSLEngineConfig(sslEngineConfigurator);
        }
        server.addListener(listener);
        ServerConfiguration config = server.getServerConfiguration();
        if (handler != null) {
            config.addHttpHandler(handler, uri.getPath());
        }
        config.setPassTraceRequest(true);
        if (start) {
            try {
                server.start();
            }
            catch (IOException ex) {
                throw new ProcessingException("IOException thrown when trying to start grizzly server", ex);
            }
        }
        return server;
    }

    private GrizzlyHttpServerFactory() {
    }
}

