/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb;

import javax.ejb.EJBException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.server.internal.process.MappableException;

public class EjbExceptionMapper
implements ExceptionMapper<EJBException> {
    private final Providers providers;

    public EjbExceptionMapper(@Context Providers providers) {
        this.providers = providers;
    }

    @Override
    public Response toResponse(EJBException exception) {
        Exception cause = exception.getCausedByException();
        if (cause != null) {
            ExceptionMapper<?> mapper = this.providers.getExceptionMapper(cause.getClass());
            if (mapper != null) {
                return mapper.toResponse(cause);
            }
            if (cause instanceof WebApplicationException) {
                return ((WebApplicationException)cause).getResponse();
            }
        }
        throw new MappableException(cause == null ? exception : cause);
    }
}

