/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Singleton;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.gf.ejb.EjbExceptionMapper;
import org.glassfish.jersey.gf.ejb.LocalizationMessages;
import org.glassfish.jersey.internal.inject.Injections;
import org.glassfish.jersey.internal.inject.ServiceBindingBuilder;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.spi.ComponentProvider;

public final class EjbComponentProvider
implements ComponentProvider {
    private static final Logger LOGGER = Logger.getLogger(EjbComponentProvider.class.getName());
    private boolean ejbInterceptorRegistered = false;
    private static final Set<String> EjbComponentAnnotations = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("javax.ejb.Stateful");
            this.add("javax.ejb.Stateless");
            this.add("javax.ejb.Singleton");
        }
    });
    private ServiceLocator locator = null;

    @Override
    public void initialize(ServiceLocator locator) {
        this.locator = locator;
    }

    private void registerEjbInterceptor() {
        try {
            InitialContext ic = EjbComponentProvider.getInitialContext();
            if (ic == null) {
                throw new IllegalStateException(LocalizationMessages.INITIAL_CONTEXT_NOT_FOUND());
            }
            Object interceptorBinder = ic.lookup("java:org.glassfish.ejb.container.interceptor_binding_spi");
            if (interceptorBinder == null) {
                throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_BIND_API_NOT_AVAILABLE());
            }
            Method interceptorBinderMethod = interceptorBinder.getClass().getMethod("registerInterceptor", Object.class);
            try {
                Class<?> interceptorClass = Class.forName(EjbComponentProvider.class.getPackage().getName() + ".EjbComponentInterceptor");
                Object interceptor = interceptorClass.getConstructor(ServiceLocator.class).newInstance(this.locator);
                interceptorBinderMethod.invoke(interceptorBinder, interceptor);
                this.ejbInterceptorRegistered = true;
                LOGGER.log(Level.INFO, LocalizationMessages.EJB_INTERCEPTOR_BOUND());
            }
            catch (Exception ex) {
                throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_CONFIG_ERROR(), ex);
            }
        }
        catch (NamingException ex) {
            throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_BIND_API_NOT_AVAILABLE(), ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_BIND_API_NON_CONFORMANT(), ex);
        }
        catch (SecurityException ex) {
            throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_CONFIG_SECURITY_ERROR(), ex);
        }
        catch (LinkageError ex) {
            throw new IllegalStateException(LocalizationMessages.EJB_INTERCEPTOR_CONFIG_LINKAGE_ERROR(), ex);
        }
    }

    @Override
    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        if (this.locator == null) {
            throw new IllegalStateException(LocalizationMessages.EJB_COMPONENT_PROVIDER_NOT_INITIALIZED_PROPERLY());
        }
        if (!this.isEjbComponent(component)) {
            return false;
        }
        if (!this.ejbInterceptorRegistered) {
            this.registerEjbInterceptor();
        }
        try {
            DynamicConfiguration dc = Injections.getConfiguration(this.locator);
            ServiceBindingBuilder<?> bindingBuilder = Injections.newFactoryBinder(new EjbFactory(component, new InitialContext()));
            bindingBuilder.to(component);
            for (Class<?> contract : providerContracts) {
                bindingBuilder.to(contract);
            }
            Injections.addBinding(bindingBuilder, dc);
            dc.commit();
            return true;
        }
        catch (NamingException ex) {
            Logger.getLogger(ApplicationHandler.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public void done() {
        if (this.ejbInterceptorRegistered) {
            DynamicConfiguration dc = Injections.getConfiguration(this.locator);
            Injections.addBinding(Injections.newBinder(EjbExceptionMapper.class).to(ExceptionMapper.class).in(Singleton.class), dc);
            dc.commit();
        }
    }

    private boolean isEjbComponent(Class<?> component) {
        for (Annotation a : component.getAnnotations()) {
            if (!EjbComponentAnnotations.contains(a.annotationType().getName())) continue;
            return true;
        }
        return false;
    }

    private static InitialContext getInitialContext() {
        try {
            return new InitialContext();
        }
        catch (NamingException ex) {
            return null;
        }
        catch (LinkageError ex) {
            return null;
        }
    }

    private static Object lookup(InitialContext ic, Class<?> c, String name) throws NamingException {
        try {
            return EjbComponentProvider.lookupSimpleForm(ic, name);
        }
        catch (NamingException ex) {
            LOGGER.log(Level.WARNING, LocalizationMessages.EJB_CLASS_SIMPLE_LOOKUP_FAILED(c.getName()), ex);
            return EjbComponentProvider.lookupFullyQualifiedForm(ic, c, name);
        }
    }

    private static Object lookupSimpleForm(InitialContext ic, String name) throws NamingException {
        String jndiName = "java:module/" + name;
        return ic.lookup(jndiName);
    }

    private static Object lookupFullyQualifiedForm(InitialContext ic, Class<?> c, String name) throws NamingException {
        String jndiName = "java:module/" + name + "!" + c.getName();
        return ic.lookup(jndiName);
    }

    private static class EjbFactory<T>
    implements Factory<T> {
        final InitialContext ctx;
        final Class<T> clazz;

        @Override
        public T provide() {
            try {
                return (T)EjbComponentProvider.lookup(this.ctx, this.clazz, this.clazz.getSimpleName());
            }
            catch (NamingException ex) {
                Logger.getLogger(ApplicationHandler.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        @Override
        public void dispose(T instance) {
        }

        public EjbFactory(Class<T> rawType, InitialContext ctx) {
            this.clazz = rawType;
            this.ctx = ctx;
        }
    }
}

