/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorType;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.Metadata;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.UseProxy;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.internal.ActiveDescriptorBuilderImpl;
import org.glassfish.hk2.internal.ConstantActiveDescriptor;
import org.glassfish.hk2.internal.DescriptorBuilderImpl;
import org.glassfish.hk2.internal.IndexedFilterImpl;
import org.glassfish.hk2.internal.SpecificFilterImpl;
import org.glassfish.hk2.internal.StarFilter;
import org.glassfish.hk2.utilities.AbstractActiveDescriptor;
import org.glassfish.hk2.utilities.ActiveDescriptorBuilder;
import org.glassfish.hk2.utilities.DescriptorBuilder;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.hk2.utilities.reflection.ReflectionHelper;
import org.jvnet.hk2.annotations.Contract;

public class BuilderHelper {
    public static IndexedFilter createContractFilter(String contract) {
        return new IndexedFilterImpl(contract, null);
    }

    public static IndexedFilter createNameFilter(String name) {
        return new IndexedFilterImpl(null, name);
    }

    public static IndexedFilter createNameAndContractFilter(String contract, String name) {
        return new IndexedFilterImpl(contract, name);
    }

    public static IndexedFilter createSpecificDescriptorFilter(Descriptor descriptor) {
        Set<String> contracts = descriptor.getAdvertisedContracts();
        String contract = null;
        Iterator<String> i$ = contracts.iterator();
        if (i$.hasNext()) {
            String candidate;
            contract = candidate = i$.next();
        }
        String name = descriptor.getName();
        if (descriptor.getServiceId() == null) {
            throw new IllegalArgumentException("The descriptor must have a specific service ID");
        }
        if (descriptor.getLocatorId() == null) {
            throw new IllegalArgumentException("The descriptor must have a specific locator ID");
        }
        return new SpecificFilterImpl(contract, name, descriptor.getServiceId(), descriptor.getLocatorId());
    }

    public static Filter allFilter() {
        return StarFilter.getDescriptorFilter();
    }

    public static DescriptorBuilder link(String implementationClass, boolean addToContracts) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        return new DescriptorBuilderImpl(implementationClass, addToContracts);
    }

    public static DescriptorBuilder link(String implementationClass) throws IllegalArgumentException {
        return BuilderHelper.link(implementationClass, true);
    }

    public static DescriptorBuilder link(Class<?> implementationClass, boolean addToContracts) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        DescriptorBuilder builder = BuilderHelper.link(implementationClass.getName(), addToContracts);
        return builder;
    }

    public static DescriptorBuilder link(Class<?> implementationClass) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        boolean isFactory = Factory.class.isAssignableFrom(implementationClass);
        DescriptorBuilder db = BuilderHelper.link(implementationClass, !isFactory);
        return db;
    }

    public static ActiveDescriptorBuilder activeLink(Class<?> implementationClass) throws IllegalArgumentException {
        if (implementationClass == null) {
            throw new IllegalArgumentException();
        }
        return new ActiveDescriptorBuilderImpl(implementationClass);
    }

    public static <T> AbstractActiveDescriptor<T> createConstantDescriptor(T constant) {
        if (constant == null) {
            throw new IllegalArgumentException();
        }
        Set<Type> contracts = ReflectionHelper.getAdvertisedTypesFromObject(constant, Contract.class);
        return BuilderHelper.createConstantDescriptor(constant, ReflectionHelper.getName(constant.getClass()), contracts.toArray(new Type[contracts.size()]));
    }

    public static <T> AbstractActiveDescriptor<T> createConstantDescriptor(T constant, String name, Type ... contracts) {
        if (constant == null) {
            throw new IllegalArgumentException();
        }
        Annotation scope = ReflectionHelper.getScopeAnnotationFromObject(constant);
        Class scopeClass = scope == null ? PerLookup.class : scope.annotationType();
        Set<Annotation> qualifiers = ReflectionHelper.getQualifiersFromObject(constant);
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        if (scope != null) {
            BuilderHelper.getMetadataValues(scope, metadata);
        }
        for (Annotation qualifier : qualifiers) {
            BuilderHelper.getMetadataValues(qualifier, metadata);
        }
        LinkedHashSet<Type> contractsAsSet = new LinkedHashSet<Type>();
        for (Type cType : contracts) {
            contractsAsSet.add(cType);
        }
        Boolean proxy = null;
        UseProxy up = constant.getClass().getAnnotation(UseProxy.class);
        if (up != null) {
            proxy = up.value() ? Boolean.TRUE : Boolean.FALSE;
        }
        DescriptorVisibility visibility = DescriptorVisibility.NORMAL;
        Visibility vi = constant.getClass().getAnnotation(Visibility.class);
        if (vi != null) {
            visibility = vi.value();
        }
        return new ConstantActiveDescriptor<T>(constant, contractsAsSet, scopeClass, name, qualifiers, visibility, proxy, metadata);
    }

    public static DescriptorImpl createDescriptorFromClass(Class<?> clazz) {
        if (clazz == null) {
            return new DescriptorImpl();
        }
        Set<String> contracts = ReflectionHelper.getContractsFromClass(clazz, Contract.class);
        String name = ReflectionHelper.getName(clazz);
        String scope = ReflectionHelper.getScopeFromClass(clazz, PerLookup.class).getName();
        Set<String> qualifiers = ReflectionHelper.getQualifiersFromClass(clazz);
        DescriptorType type2 = DescriptorType.CLASS;
        if (Factory.class.isAssignableFrom(clazz)) {
            type2 = DescriptorType.PROVIDE_METHOD;
        }
        Boolean proxy = null;
        UseProxy up = clazz.getAnnotation(UseProxy.class);
        if (up != null) {
            proxy = new Boolean(up.value());
        }
        DescriptorVisibility visibility = DescriptorVisibility.NORMAL;
        Visibility vi = clazz.getAnnotation(Visibility.class);
        if (vi != null) {
            visibility = vi.value();
        }
        return new DescriptorImpl(contracts, name, scope, clazz.getName(), new HashMap<String, List<String>>(), qualifiers, type2, visibility, null, 0, proxy, null, null, null);
    }

    public static DescriptorImpl deepCopyDescriptor(Descriptor copyMe) {
        return new DescriptorImpl(copyMe);
    }

    public static void getMetadataValues(Annotation annotation, Map<String, List<String>> metadata) {
        Method[] annotationMethods;
        if (annotation == null || metadata == null) {
            throw new IllegalArgumentException();
        }
        Class<? extends Annotation> annotationClass = annotation.annotationType();
        for (Method annotationMethod : annotationMethods = annotationClass.getDeclaredMethods()) {
            Object addMe;
            Metadata metadataAnno = annotationMethod.getAnnotation(Metadata.class);
            if (metadataAnno == null) continue;
            String key = metadataAnno.value();
            try {
                addMe = ReflectionHelper.invoke(annotation, annotationMethod, new Object[0]);
            }
            catch (Throwable th) {
                throw new MultiException(th);
            }
            if (addMe == null) continue;
            String addMeString = addMe instanceof Class ? ((Class)addMe).getName() : addMe.toString();
            ReflectionHelper.addMetadata(metadata, key, addMeString);
        }
    }
}

