/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets.draft06;

import java.net.URI;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.FrameType;
import org.glassfish.grizzly.websockets.HandShake;
import org.glassfish.grizzly.websockets.Masker;
import org.glassfish.grizzly.websockets.ProtocolError;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.draft06.HandShake06;
import org.glassfish.grizzly.websockets.frametypes.BinaryFrameType;
import org.glassfish.grizzly.websockets.frametypes.ClosingFrameType;
import org.glassfish.grizzly.websockets.frametypes.ContinuationFrameType;
import org.glassfish.grizzly.websockets.frametypes.PingFrameType;
import org.glassfish.grizzly.websockets.frametypes.PongFrameType;
import org.glassfish.grizzly.websockets.frametypes.TextFrameType;

public class Draft06Handler
extends ProtocolHandler {
    private final ParsingState state = new ParsingState();

    public Draft06Handler() {
        super(false);
    }

    public Draft06Handler(boolean maskData) {
        super(maskData);
    }

    @Override
    public HandShake createHandShake(HttpContent requestContent) {
        return new HandShake06((HttpRequestPacket)requestContent.getHttpHeader());
    }

    @Override
    public HandShake createHandShake(URI uri) {
        return new HandShake06(uri);
    }

    @Override
    public byte[] frame(DataFrame frame) {
        byte opcode = this.checkForLastFrame(frame, this.getOpcode(frame.getType()));
        byte[] payloadBytes = frame.getBytes();
        int payloadLen = payloadBytes != null ? payloadBytes.length : 0;
        byte[] lengthBytes = this.encodeLength(payloadLen);
        int packetLength = 1 + lengthBytes.length;
        byte[] packet = new byte[packetLength + payloadLen];
        packet[0] = opcode;
        System.arraycopy(lengthBytes, 0, packet, 1, lengthBytes.length);
        if (payloadBytes != null) {
            System.arraycopy(payloadBytes, 0, packet, packetLength, payloadLen);
        }
        if (this.maskData) {
            packet = new Masker().maskAndPrepend(packet);
        }
        return packet;
    }

    @Override
    public DataFrame parse(Buffer buffer) {
        DataFrame dataFrame = null;
        try {
            switch (this.state.state) {
                case 0: {
                    this.state.masker = new Masker(buffer);
                    if (!this.maskData) {
                        if (buffer.remaining() < 4) {
                            return null;
                        }
                        this.state.masker.readMask();
                    }
                    ++this.state.state;
                }
                case 1: {
                    if (buffer.remaining() < 2) {
                        return null;
                    }
                    this.state.masker.setBuffer(buffer);
                    this.state.opcode = this.state.masker.unmask();
                    this.state.finalFragment = (this.state.opcode & 0x80) == 128;
                    this.state.controlFrame = this.isControlFrame(this.state.opcode);
                    this.state.opcode = (byte)(this.state.opcode & 0x7F);
                    this.state.frameType = this.valueOf(this.inFragmentedType, this.state.opcode);
                    if (!this.state.finalFragment) {
                        if (this.inFragmentedType == 0) {
                            this.inFragmentedType = this.state.opcode;
                        }
                    } else {
                        this.inFragmentedType = 0;
                    }
                    this.state.lengthCode = this.state.masker.unmask();
                    ++this.state.state;
                }
                case 2: {
                    if (this.state.lengthCode <= 125) {
                        this.state.length = this.state.lengthCode;
                    } else {
                        int lengthBytes;
                        int n = lengthBytes = this.state.lengthCode == 126 ? 2 : 8;
                        if (buffer.remaining() < lengthBytes) {
                            return null;
                        }
                        this.state.masker.setBuffer(buffer);
                        this.state.length = this.decodeLength(this.state.masker.unmask(lengthBytes));
                    }
                    ++this.state.state;
                }
                case 3: {
                    if ((long)buffer.remaining() < this.state.length) {
                        return null;
                    }
                    this.state.masker.setBuffer(buffer);
                    byte[] data = this.state.masker.unmask((int)this.state.length);
                    if ((long)data.length != this.state.length) {
                        throw new ProtocolError(String.format("Data read (%s) is not the expected size (%s)", data.length, this.state.length));
                    }
                    dataFrame = this.state.frameType.create(this.state.finalFragment, data);
                    if (!this.state.controlFrame && (this.isTextFrame(this.state.opcode) || this.inFragmentedType == 4)) {
                        this.utf8Decode(this.state.finalFragment, data, dataFrame);
                    }
                    if (!this.state.controlFrame && this.state.finalFragment) {
                        this.inFragmentedType = 0;
                    }
                    this.state.recycle();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state: " + this.state.state);
                }
            }
        }
        catch (Exception e) {
            this.state.recycle();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        return dataFrame;
    }

    private boolean isTextFrame(byte opcode) {
        return opcode == 4;
    }

    @Override
    protected boolean isControlFrame(byte opcode) {
        return opcode == 1 || opcode == 2 || opcode == 3;
    }

    private byte getOpcode(FrameType type2) {
        if (type2 instanceof ClosingFrameType) {
            return 1;
        }
        if (type2 instanceof PingFrameType) {
            return 2;
        }
        if (type2 instanceof PongFrameType) {
            return 3;
        }
        if (type2 instanceof TextFrameType) {
            return 4;
        }
        if (type2 instanceof BinaryFrameType) {
            return 5;
        }
        throw new ProtocolError("Unknown frame type: " + type2.getClass().getName());
    }

    private FrameType valueOf(byte fragmentType, byte value) {
        int opcode = value & 0xF;
        switch (opcode & 0xF) {
            case 0: {
                return new ContinuationFrameType((fragmentType & 4) == 4);
            }
            case 1: {
                return new ClosingFrameType();
            }
            case 2: {
                return new PingFrameType();
            }
            case 3: {
                return new PongFrameType();
            }
            case 4: {
                return new TextFrameType();
            }
            case 5: {
                return new BinaryFrameType();
            }
        }
        throw new ProtocolError("Unknown frame type: " + value);
    }

    private static class ParsingState {
        int state = 0;
        byte opcode = (byte)-1;
        long length = -1L;
        byte lengthCode = (byte)-1;
        FrameType frameType;
        Masker masker;
        boolean finalFragment;
        boolean controlFrame;

        private ParsingState() {
        }

        void recycle() {
            this.state = 0;
            this.opcode = (byte)-1;
            this.length = -1L;
            this.lengthCode = (byte)-1;
            this.masker = null;
            this.finalFragment = false;
            this.controlFrame = false;
            this.frameType = null;
        }
    }
}

