/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import org.glassfish.grizzly.utils.NullaryFunction;

public abstract class Holder<E> {
    public static <T> Holder<T> staticHolder(final T value) {
        return new Holder<T>(){

            @Override
            public T get() {
                return value;
            }
        };
    }

    public static IntHolder staticIntHolder(final int value) {
        return new IntHolder(){

            @Override
            public int getInt() {
                return value;
            }
        };
    }

    public static <T> LazyHolder<T> lazyHolder(final NullaryFunction<T> factory) {
        return new LazyHolder<T>(){

            @Override
            protected T evaluate() {
                return factory.evaluate();
            }
        };
    }

    public static LazyIntHolder lazyIntHolder(final NullaryFunction<Integer> factory) {
        return new LazyIntHolder(){

            @Override
            protected int evaluate() {
                return (Integer)factory.evaluate();
            }
        };
    }

    public abstract E get();

    protected void set(E value) {
    }

    public String toString() {
        E obj = this.get();
        return obj != null ? "{" + obj + "}" : null;
    }

    public static abstract class IntHolder
    extends Holder<Integer> {
        @Override
        public final Integer get() {
            return this.getInt();
        }

        @Override
        protected final void set(Integer value) {
            this.setInt(value);
        }

        public abstract int getInt();

        protected void setInt(int value) {
        }
    }

    public static abstract class LazyHolder<E>
    extends Holder<E> {
        private volatile boolean isSet;
        private E value;

        @Override
        protected synchronized void set(E value) {
            this.value = value;
            this.isSet = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final E get() {
            if (this.isSet) {
                return this.value;
            }
            LazyHolder lazyHolder = this;
            synchronized (lazyHolder) {
                if (!this.isSet) {
                    this.value = this.evaluate();
                    this.isSet = true;
                }
            }
            return this.value;
        }

        protected abstract E evaluate();
    }

    public static abstract class LazyIntHolder
    extends IntHolder {
        private volatile boolean isSet;
        private int value;

        @Override
        protected synchronized void setInt(int value) {
            this.value = value;
            this.isSet = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int getInt() {
            if (this.isSet) {
                return this.value;
            }
            LazyIntHolder lazyIntHolder = this;
            synchronized (lazyIntHolder) {
                if (!this.isSet) {
                    this.value = this.evaluate();
                    this.isSet = true;
                }
            }
            return this.value;
        }

        protected abstract int evaluate();
    }
}

