/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class DelayedExecutor {
    public static final long UNSET_TIMEOUT = -1L;
    private final ExecutorService threadPool;
    private final DelayedRunnable runnable = new DelayedRunnable();
    private final Queue<DelayQueue> queues = new ConcurrentLinkedQueue<DelayQueue>();
    private final Object sync = new Object();
    private volatile boolean isStarted;
    private final long checkIntervalMillis;

    public DelayedExecutor(ExecutorService threadPool) {
        this(threadPool, 1000L, TimeUnit.MILLISECONDS);
    }

    public DelayedExecutor(ExecutorService threadPool, long checkInterval, TimeUnit timeunit) {
        if (checkInterval < 0L) {
            throw new IllegalArgumentException("check interval can't be negative");
        }
        this.threadPool = threadPool;
        this.checkIntervalMillis = TimeUnit.MILLISECONDS.convert(checkInterval, timeunit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isStarted) {
                this.isStarted = true;
                this.threadPool.execute(this.runnable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.sync;
        synchronized (object) {
            if (this.isStarted) {
                this.isStarted = false;
                this.sync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.stop();
        Object object = this.sync;
        synchronized (object) {
            this.queues.clear();
        }
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public <E> DelayQueue<E> createDelayQueue(Worker<E> worker, Resolver<E> resolver) {
        DelayQueue<E> queue = new DelayQueue<E>(worker, resolver);
        this.queues.add(queue);
        return queue;
    }

    private static boolean wasModified(long l1, long l2) {
        return l1 != l2;
    }

    public final class DelayQueue<E> {
        final ConcurrentHashMap<E, DelayQueue> queue = new ConcurrentHashMap();
        final Worker<E> worker;
        final Resolver<E> resolver;

        public DelayQueue(Worker<E> worker, Resolver<E> resolver) {
            this.worker = worker;
            this.resolver = resolver;
        }

        public void add(E elem, long delay, TimeUnit timeUnit) {
            if (delay >= 0L) {
                this.resolver.setTimeoutMillis(elem, System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(delay, timeUnit));
                this.queue.put(elem, this);
            }
        }

        public void remove(E elem) {
            this.resolver.removeTimeout(elem);
        }

        public void destroy() {
            DelayedExecutor.this.queues.remove(this);
        }
    }

    private class DelayedRunnable
    implements Runnable {
        private DelayedRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (DelayedExecutor.this.isStarted) {
                long currentTimeMillis = System.currentTimeMillis();
                for (DelayQueue delayQueue : DelayedExecutor.this.queues) {
                    if (delayQueue.queue.isEmpty()) continue;
                    Resolver resolver = delayQueue.resolver;
                    Iterator it = delayQueue.queue.keySet().iterator();
                    while (it.hasNext()) {
                        Object element = it.next();
                        long timeoutMillis = resolver.getTimeoutMillis(element);
                        if (timeoutMillis == -1L) {
                            it.remove();
                            if (!DelayedExecutor.wasModified(timeoutMillis, resolver.getTimeoutMillis(element))) continue;
                            delayQueue.queue.put(element, delayQueue);
                            continue;
                        }
                        if (currentTimeMillis - timeoutMillis < 0L) continue;
                        it.remove();
                        if (DelayedExecutor.wasModified(timeoutMillis, resolver.getTimeoutMillis(element))) {
                            delayQueue.queue.put(element, delayQueue);
                            continue;
                        }
                        try {
                            if (delayQueue.worker.doWork(element)) continue;
                            delayQueue.queue.put(element, delayQueue);
                        }
                        catch (Exception ignored) {}
                    }
                }
                Object object = DelayedExecutor.this.sync;
                synchronized (object) {
                    if (!DelayedExecutor.this.isStarted) {
                        return;
                    }
                    try {
                        DelayedExecutor.this.sync.wait(DelayedExecutor.this.checkIntervalMillis);
                    }
                    catch (InterruptedException ignored) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static interface Resolver<E> {
        public boolean removeTimeout(E var1);

        public long getTimeoutMillis(E var1);

        public void setTimeoutMillis(E var1, long var2);
    }

    public static interface Worker<E> {
        public boolean doWork(E var1);
    }
}

