/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.ssl;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.ssl.InputBufferWrapper;
import org.glassfish.grizzly.ssl.SSLUtils;

public final class SSLConnectionContext {
    private static final Logger LOGGER = Grizzly.logger(SSLConnectionContext.class);
    final ByteBufferArray outputByteBufferArray = ByteBufferArray.create();
    final ByteBufferArray inputByteBufferArray = ByteBufferArray.create();
    private Buffer lastOutputBuffer;
    private final InputBufferWrapper inputBuffer = new InputBufferWrapper();
    private InputBufferWrapper lastInputBuffer;
    private boolean isServerMode;
    private SSLEngine sslEngine;
    private volatile int appBufferSize;
    private volatile int netBufferSize;
    private final Connection connection;

    public SSLConnectionContext(Connection connection) {
        this.connection = connection;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void attach() {
        SSLUtils.SSL_CTX_ATTR.set(this.connection, this);
    }

    public void configure(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
        this.isServerMode = !sslEngine.getUseClientMode();
        this.updateBufferSizes();
    }

    public boolean isServerMode() {
        return this.isServerMode;
    }

    void updateBufferSizes() {
        SSLSession session = this.sslEngine.getSession();
        this.appBufferSize = session.getApplicationBufferSize();
        this.netBufferSize = session.getPacketBufferSize();
    }

    public int getAppBufferSize() {
        return this.appBufferSize;
    }

    public int getNetBufferSize() {
        return this.netBufferSize;
    }

    Buffer resetLastOutputBuffer() {
        Buffer tmp = this.lastOutputBuffer;
        this.lastOutputBuffer = null;
        return tmp;
    }

    void setLastOutputBuffer(Buffer lastOutputBuffer) {
        this.lastOutputBuffer = lastOutputBuffer;
    }

    InputBufferWrapper resetLastInputBuffer() {
        InputBufferWrapper tmp = this.lastInputBuffer;
        this.lastInputBuffer = null;
        return tmp;
    }

    InputBufferWrapper useInputBuffer() {
        this.lastInputBuffer = this.inputBuffer;
        return this.lastInputBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SslResult unwrap(Buffer input, Buffer output, Allocator allocator) {
        boolean isOverflow;
        SSLEngineResult sslEngineResult;
        int outPos;
        int inPos;
        block10: {
            output = this.ensureBufferSize(output, this.appBufferSize, allocator);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "unwrap engine: {0} input: {1} output: {2}", new Object[]{this.sslEngine, input, output});
            }
            inPos = input.position();
            outPos = output.position();
            ByteBuffer inputByteBuffer = input.toByteBuffer();
            try {
                if (!output.isComposite()) {
                    sslEngineResult = this.sslEngine.unwrap(inputByteBuffer, output.toByteBuffer());
                    break block10;
                }
                ByteBufferArray bba = output.toByteBufferArray(this.outputByteBufferArray);
                ByteBuffer[] outputArray = (ByteBuffer[])bba.getArray();
                try {
                    sslEngineResult = this.sslEngine.unwrap(inputByteBuffer, outputArray, 0, bba.size());
                }
                finally {
                    bba.restore();
                    bba.reset();
                }
            }
            catch (SSLException e) {
                return new SslResult(output, e);
            }
        }
        SSLEngineResult.Status status = sslEngineResult.getStatus();
        boolean bl = isOverflow = status == SSLEngineResult.Status.BUFFER_OVERFLOW;
        if (allocator != null && isOverflow) {
            this.updateBufferSizes();
            output = this.ensureBufferSize(output, this.appBufferSize, allocator);
            return this.unwrap(input, output, null);
        }
        if (isOverflow || status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            return new SslResult(output, new SSLException("SSL unwrap error: " + (Object)((Object)status)));
        }
        input.position(inPos + sslEngineResult.bytesConsumed());
        output.position(outPos + sslEngineResult.bytesProduced());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "unwrap done engine: {0} result: {1} input: {2} output: {3}", new Object[]{this.sslEngine, sslEngineResult, input, output});
        }
        return new SslResult(output, sslEngineResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Buffer wrapAll(Buffer input, Allocator allocator) throws SSLException {
        MemoryManager memoryManager = this.connection.getTransport().getMemoryManager();
        ByteBufferArray bba = input.toByteBufferArray(this.inputByteBufferArray);
        ByteBuffer[] inputArray = (ByteBuffer[])bba.getArray();
        int inputArraySize = bba.size();
        Buffer output = null;
        SslResult result = null;
        try {
            result = this.wrap(input, inputArray, inputArraySize, null, allocator);
            if (result.isError()) {
                throw result.getError();
            }
            output = result.getOutput();
            output.trim();
            if (input.hasRemaining()) {
                do {
                    if ((result = this.wrap(input, inputArray, inputArraySize, null, allocator)).isError()) {
                        throw result.getError();
                    }
                    Buffer newOutput = result.getOutput();
                    newOutput.trim();
                    output = Buffers.appendBuffers(memoryManager, output, newOutput);
                } while (input.hasRemaining());
            }
            Buffer buffer = output;
            return buffer;
        }
        finally {
            bba.restore();
            bba.reset();
            if (result != null && result.isError()) {
                if (output != null) {
                    output.dispose();
                }
                result.getOutput().dispose();
            }
        }
    }

    private SslResult wrap(Buffer input, ByteBuffer[] inputArray, int inputArraySize, Buffer output, Allocator allocator) {
        boolean isOverflow;
        SSLEngineResult sslEngineResult;
        output = this.ensureBufferSize(output, this.netBufferSize, allocator);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "wrap engine: {0} input: {1} output: {2}", new Object[]{this.sslEngine, input, output});
        }
        int inPos = input.position();
        int outPos = output.position();
        ByteBuffer outputByteBuffer = output.toByteBuffer();
        try {
            sslEngineResult = this.sslEngine.wrap(inputArray, 0, inputArraySize, outputByteBuffer);
        }
        catch (SSLException e) {
            return new SslResult(output, e);
        }
        SSLEngineResult.Status status = sslEngineResult.getStatus();
        if (status == SSLEngineResult.Status.CLOSED) {
            return new SslResult(output, new SSLException("SSLEngine is CLOSED"));
        }
        boolean bl = isOverflow = status == SSLEngineResult.Status.BUFFER_OVERFLOW;
        if (allocator != null && isOverflow) {
            this.updateBufferSizes();
            output = this.ensureBufferSize(output, this.netBufferSize, allocator);
            return this.wrap(input, inputArray, inputArraySize, output, null);
        }
        if (isOverflow || status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            return new SslResult(output, new SSLException("SSL wrap error: " + (Object)((Object)status)));
        }
        input.position(inPos + sslEngineResult.bytesConsumed());
        output.position(outPos + sslEngineResult.bytesProduced());
        this.lastOutputBuffer = output;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "wrap done engine: {0} result: {1} input: {2} output: {3}", new Object[]{this.sslEngine, sslEngineResult, input, output});
        }
        return new SslResult(output, sslEngineResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SslResult wrap(Buffer input, Buffer output, Allocator allocator) {
        boolean isOverflow;
        SSLEngineResult sslEngineResult;
        int outPos;
        int inPos;
        block11: {
            output = this.ensureBufferSize(output, this.netBufferSize, allocator);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "wrap engine: {0} input: {1} output: {2}", new Object[]{this.sslEngine, input, output});
            }
            inPos = input.position();
            outPos = output.position();
            ByteBuffer outputByteBuffer = output.toByteBuffer();
            try {
                if (!input.isComposite()) {
                    sslEngineResult = this.sslEngine.wrap(input.toByteBuffer(), outputByteBuffer);
                    break block11;
                }
                ByteBufferArray bba = input.toByteBufferArray(this.inputByteBufferArray);
                ByteBuffer[] inputArray = (ByteBuffer[])bba.getArray();
                try {
                    sslEngineResult = this.sslEngine.wrap(inputArray, 0, bba.size(), outputByteBuffer);
                }
                finally {
                    bba.restore();
                    bba.reset();
                }
            }
            catch (SSLException e) {
                return new SslResult(output, e);
            }
        }
        SSLEngineResult.Status status = sslEngineResult.getStatus();
        if (status == SSLEngineResult.Status.CLOSED) {
            return new SslResult(output, new SSLException("SSLEngine is CLOSED"));
        }
        boolean bl = isOverflow = status == SSLEngineResult.Status.BUFFER_OVERFLOW;
        if (allocator != null && isOverflow) {
            this.updateBufferSizes();
            output = this.ensureBufferSize(output, this.netBufferSize, allocator);
            return this.wrap(input, output, null);
        }
        if (isOverflow || status == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
            return new SslResult(output, new SSLException("SSL wrap error: " + (Object)((Object)status)));
        }
        input.position(inPos + sslEngineResult.bytesConsumed());
        output.position(outPos + sslEngineResult.bytesProduced());
        this.lastOutputBuffer = output;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "wrap done engine: {0} result: {1} input: {2} output: {3}", new Object[]{this.sslEngine, sslEngineResult, input, output});
        }
        return new SslResult(output, sslEngineResult);
    }

    private Buffer ensureBufferSize(Buffer output, int size, Allocator allocator) {
        if (output == null) {
            assert (allocator != null);
            output = allocator.grow(this, null, size * 2);
        } else if (output.remaining() < size) {
            assert (allocator != null);
            output = allocator.grow(this, output, output.capacity() + (size - output.remaining()));
        }
        return output;
    }

    static interface Allocator {
        public Buffer grow(SSLConnectionContext var1, Buffer var2, int var3);
    }

    static final class SslResult {
        private final Buffer output;
        private final SSLException error;
        private final SSLEngineResult sslEngineResult;

        public SslResult(Buffer output, SSLEngineResult sslEngineResult) {
            this.output = output;
            this.sslEngineResult = sslEngineResult;
            this.error = null;
        }

        public SslResult(Buffer output, SSLException error) {
            this.output = output;
            this.error = error;
            this.sslEngineResult = null;
        }

        public Buffer getOutput() {
            return this.output;
        }

        public boolean isError() {
            return this.error != null;
        }

        public SSLException getError() {
            return this.error;
        }

        public SSLEngineResult getSslEngineResult() {
            return this.sslEngineResult;
        }
    }
}

