/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.io.NIOOutputStream;
import org.glassfish.grizzly.servlet.AsyncContextImpl;

public class ServletOutputStreamImpl
extends ServletOutputStream {
    private NIOOutputStream outputStream;
    private WriteHandler writeHandler = null;
    private boolean hasSetWriteListener = false;
    private boolean prevCanWrite = true;
    private static final ThreadLocal<Boolean> CAN_WRITE_SCOPE = new ThreadLocal();

    protected void initialize(Response response) throws IOException {
        this.outputStream = response.createOutputStream();
    }

    @Override
    public void write(int i) throws IOException {
        this.outputStream.write(i);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWrite() {
        if (!this.prevCanWrite) {
            return false;
        }
        boolean result = this.outputStream.canWrite();
        if (!result) {
            if (this.hasSetWriteListener) {
                this.prevCanWrite = false;
                CAN_WRITE_SCOPE.set(Boolean.TRUE);
                try {
                    this.outputStream.notifyCanWrite(this.writeHandler);
                }
                finally {
                    CAN_WRITE_SCOPE.remove();
                }
            } else {
                this.prevCanWrite = true;
            }
        }
        return result;
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
        if (this.hasSetWriteListener) {
            throw new IllegalStateException("The WriteListener has already been set.");
        }
        this.writeHandler = new WriteHandlerImpl(writeListener);
        this.hasSetWriteListener = true;
    }

    void recycle() {
        this.outputStream = null;
        this.writeHandler = null;
        this.prevCanWrite = true;
        this.hasSetWriteListener = false;
    }

    class WriteHandlerImpl
    implements WriteHandler {
        private WriteListener writeListener = null;

        private WriteHandlerImpl(WriteListener listener) {
            this.writeListener = listener;
        }

        @Override
        public void onWritePossible() {
            if (!Boolean.TRUE.equals(CAN_WRITE_SCOPE.get())) {
                ServletOutputStreamImpl.this.prevCanWrite = true;
                this.writeListener.onWritePossible();
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ServletOutputStreamImpl.this.prevCanWrite = true;
                        WriteHandlerImpl.this.writeListener.onWritePossible();
                    }
                });
            }
        }

        @Override
        public void onError(final Throwable t) {
            if (!Boolean.TRUE.equals(CAN_WRITE_SCOPE.get())) {
                this.writeListener.onError(t);
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        WriteHandlerImpl.this.writeListener.onError(t);
                    }
                });
            }
        }
    }
}

