/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.io.IOException;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.io.NIOInputStream;
import org.glassfish.grizzly.servlet.AsyncContextImpl;

public class ServletInputStreamImpl
extends ServletInputStream {
    private NIOInputStream inputStream;
    private ReadHandler readHandler = null;
    private boolean hasSetReadListener = false;
    private boolean prevIsReady = true;
    private static final ThreadLocal<Boolean> IS_READY_SCOPE = new ThreadLocal();

    protected ServletInputStreamImpl() {
    }

    public void initialize(Request request) throws IOException {
        this.inputStream = request.createInputStream();
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.inputStream.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputStream.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    void recycle() {
        this.inputStream = null;
        this.prevIsReady = true;
        this.hasSetReadListener = false;
        this.readHandler = null;
    }

    @Override
    public boolean isFinished() {
        return this.inputStream.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReady() {
        if (!this.prevIsReady) {
            return false;
        }
        boolean result = this.inputStream.isReady();
        if (!result) {
            if (this.hasSetReadListener) {
                this.prevIsReady = false;
                IS_READY_SCOPE.set(Boolean.TRUE);
                try {
                    this.inputStream.notifyAvailable(this.readHandler);
                }
                finally {
                    IS_READY_SCOPE.remove();
                }
            } else {
                this.prevIsReady = true;
            }
        }
        return result;
    }

    @Override
    public void setReadListener(ReadListener readListener) {
        if (this.hasSetReadListener) {
            throw new IllegalStateException("The ReadListener has already been set");
        }
        this.readHandler = new ReadHandlerImpl(readListener);
        this.hasSetReadListener = true;
    }

    class ReadHandlerImpl
    implements ReadHandler {
        private ReadListener readListener = null;

        private ReadHandlerImpl(ReadListener listener) {
            this.readListener = listener;
        }

        @Override
        public void onDataAvailable() {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                ServletInputStreamImpl.this.prevIsReady = true;
                this.readListener.onDataAvailable();
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ServletInputStreamImpl.this.prevIsReady = true;
                        ReadHandlerImpl.this.readListener.onDataAvailable();
                    }
                });
            }
        }

        @Override
        public void onAllDataRead() {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                ServletInputStreamImpl.this.prevIsReady = true;
                this.readListener.onAllDataRead();
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ServletInputStreamImpl.this.prevIsReady = true;
                        ReadHandlerImpl.this.readListener.onAllDataRead();
                    }
                });
            }
        }

        @Override
        public void onError(final Throwable t) {
            if (!Boolean.TRUE.equals(IS_READY_SCOPE.get())) {
                this.readListener.onError(t);
            } else {
                AsyncContextImpl.pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        ReadHandlerImpl.this.readListener.onError(t);
                    }
                });
            }
        }
    }
}

