/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.nio;

import java.io.IOException;
import java.nio.channels.spi.SelectorProvider;
import java.util.Random;
import org.glassfish.grizzly.AbstractTransport;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.TransportProbe;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.SelectionKeyHandler;
import org.glassfish.grizzly.nio.SelectorHandler;
import org.glassfish.grizzly.nio.SelectorRunner;

public abstract class NIOTransport
extends AbstractTransport {
    protected static final Random RANDOM = new Random();
    protected SelectorHandler selectorHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    private int selectorRunnersCount = -1;
    protected SelectorRunner[] selectorRunners;
    protected NIOChannelDistributor nioChannelDistributor;
    protected SelectorProvider selectorProvider = SelectorProvider.provider();

    public NIOTransport(String name) {
        super(name);
    }

    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
        NIOTransport.notifyProbesConfigChanged(this);
    }

    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
        NIOTransport.notifyProbesConfigChanged(this);
    }

    public int getSelectorRunnersCount() {
        if (this.selectorRunnersCount <= 0) {
            this.selectorRunnersCount = this.getDefaultSelectorRunnersCount();
        }
        return this.selectorRunnersCount;
    }

    public void setSelectorRunnersCount(int selectorRunnersCount) {
        this.selectorRunnersCount = selectorRunnersCount;
        this.kernelPoolConfig.setCorePoolSize(selectorRunnersCount);
        this.kernelPoolConfig.setMaxPoolSize(selectorRunnersCount);
        NIOTransport.notifyProbesConfigChanged(this);
    }

    public SelectorProvider getSelectorProvider() {
        return this.selectorProvider;
    }

    public void setSelectorProvider(SelectorProvider selectorProvider) {
        this.selectorProvider = selectorProvider != null ? selectorProvider : SelectorProvider.provider();
    }

    @Override
    public void start() throws IOException {
        if (this.selectorProvider == null) {
            this.selectorProvider = SelectorProvider.provider();
        }
    }

    protected synchronized void startSelectorRunners() throws IOException {
        this.selectorRunners = new SelectorRunner[this.selectorRunnersCount];
        for (int i = 0; i < this.selectorRunnersCount; ++i) {
            SelectorRunner runner = SelectorRunner.create(this);
            runner.start();
            this.selectorRunners[i] = runner;
        }
    }

    protected synchronized void stopSelectorRunners() throws IOException {
        if (this.selectorRunners == null) {
            return;
        }
        for (int i = 0; i < this.selectorRunners.length; ++i) {
            SelectorRunner runner = this.selectorRunners[i];
            if (runner == null) continue;
            runner.stop();
            this.selectorRunners[i] = null;
        }
        this.selectorRunners = null;
    }

    public NIOChannelDistributor getNIOChannelDistributor() {
        return this.nioChannelDistributor;
    }

    public void setNIOChannelDistributor(NIOChannelDistributor nioChannelDistributor) {
        this.nioChannelDistributor = nioChannelDistributor;
        NIOTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public void notifyTransportError(Throwable error) {
        NIOTransport.notifyProbesError(this, error);
    }

    protected SelectorRunner[] getSelectorRunners() {
        return this.selectorRunners;
    }

    protected static void notifyProbesError(NIOTransport transport, Throwable error) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onErrorEvent(transport, error);
            }
        }
    }

    protected static void notifyProbesStart(NIOTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onStartEvent(transport);
            }
        }
    }

    protected static void notifyProbesStop(NIOTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onStopEvent(transport);
            }
        }
    }

    protected static void notifyProbesPause(NIOTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onPauseEvent(transport);
            }
        }
    }

    protected static void notifyProbesResume(NIOTransport transport) {
        TransportProbe[] probes = (TransportProbe[])transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onResumeEvent(transport);
            }
        }
    }

    @Override
    protected abstract void closeConnection(Connection var1) throws IOException;

    protected int getDefaultSelectorRunnersCount() {
        return Runtime.getRuntime().availableProcessors();
    }
}

