/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.util;

import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.memory.MemoryManager;

public class HttpCodecUtils {
    public static int checkEOL(HttpCodecFilter.HeaderParsingState parsingState, Buffer input) {
        byte b2;
        byte b1;
        int offset = parsingState.offset;
        int avail = input.limit() - offset;
        if (avail >= 2) {
            short s = input.getShort(offset);
            b1 = (byte)(s >>> 8);
            b2 = (byte)(s & 0xFF);
        } else if (avail == 1) {
            b1 = input.get(offset);
            b2 = -1;
        } else {
            return -2;
        }
        return HttpCodecUtils.checkCRLF(parsingState, b1, b2);
    }

    public static int checkEOL(HttpCodecFilter.HeaderParsingState parsingState, byte[] input, int end) {
        byte b2;
        byte b1;
        int arrayOffs = parsingState.arrayOffset;
        int offset = arrayOffs + parsingState.offset;
        int avail = end - offset;
        if (avail >= 2) {
            b1 = input[offset];
            b2 = input[offset + 1];
        } else if (avail == 1) {
            b1 = input[offset];
            b2 = -1;
        } else {
            return -2;
        }
        return HttpCodecUtils.checkCRLF(parsingState, b1, b2);
    }

    public static boolean findEOL(HttpCodecFilter.HeaderParsingState state, Buffer input) {
        int offset;
        int limit = Math.min(input.limit(), state.packetLimit);
        for (offset = state.offset; offset < limit; ++offset) {
            byte b = input.get(offset);
            if (b == 13) {
                state.checkpoint = offset;
                continue;
            }
            if (b != 10) continue;
            if (state.checkpoint == -1) {
                state.checkpoint = offset;
            }
            state.offset = offset + 1;
            return true;
        }
        state.offset = offset;
        return false;
    }

    public static boolean findEOL(HttpCodecFilter.HeaderParsingState state, byte[] input, int end) {
        int offset;
        int arrayOffs = state.arrayOffset;
        int limit = Math.min(end, arrayOffs + state.packetLimit);
        for (offset = arrayOffs + state.offset; offset < limit; ++offset) {
            byte b = input[offset];
            if (b == 13) {
                state.checkpoint = offset - arrayOffs;
                continue;
            }
            if (b != 10) continue;
            if (state.checkpoint == -1) {
                state.checkpoint = offset - arrayOffs;
            }
            state.offset = offset + 1 - arrayOffs;
            return true;
        }
        state.offset = offset - arrayOffs;
        return false;
    }

    public static int findSpace(Buffer input, int offset, int packetLimit) {
        int limit = Math.min(input.limit(), packetLimit);
        while (offset < limit) {
            byte b = input.get(offset);
            if (HttpCodecUtils.isSpaceOrTab(b)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int findSpace(byte[] input, int offset, int end, int packetLimit) {
        int limit = Math.min(end, packetLimit);
        while (offset < limit) {
            byte b = input[offset];
            if (HttpCodecUtils.isSpaceOrTab(b)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int skipSpaces(Buffer input, int offset, int packetLimit) {
        int limit = Math.min(input.limit(), packetLimit);
        while (offset < limit) {
            byte b = input.get(offset);
            if (HttpCodecUtils.isNotSpaceAndTab(b)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int skipSpaces(byte[] input, int offset, int end, int packetLimit) {
        int limit = Math.min(end, packetLimit);
        while (offset < limit) {
            byte b = input[offset];
            if (HttpCodecUtils.isNotSpaceAndTab(b)) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static int indexOf(Buffer input, int offset, byte b, int packetLimit) {
        int limit = Math.min(input.limit(), packetLimit);
        while (offset < limit) {
            byte currentByte = input.get(offset);
            if (currentByte == b) {
                return offset;
            }
            ++offset;
        }
        return -1;
    }

    public static Buffer getLongAsBuffer(MemoryManager memoryManager, long length) {
        Object b = memoryManager.allocate(20);
        b.allowBufferDispose(true);
        HttpUtils.longToBuffer(length, b);
        return b;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, byte[] tempBuffer, DataChunk chunk) {
        if (chunk.isNull()) {
            return dstBuffer;
        }
        if (chunk.getType() == DataChunk.Type.Bytes) {
            ByteChunk byteChunk = chunk.getByteChunk();
            return HttpCodecUtils.put(memoryManager, dstBuffer, byteChunk.getBuffer(), byteChunk.getStart(), byteChunk.getLength());
        }
        if (chunk.getType() == DataChunk.Type.Buffer) {
            BufferChunk bc = chunk.getBufferChunk();
            int length = bc.getLength();
            dstBuffer = HttpCodecUtils.checkAndResizeIfNeeded(memoryManager, dstBuffer, length);
            dstBuffer.put(bc.getBuffer(), bc.getStart(), length);
            return dstBuffer;
        }
        return HttpCodecUtils.put(memoryManager, dstBuffer, tempBuffer, chunk.toString());
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, byte[] tempBuffer, String s) {
        int size = s.length();
        if ((dstBuffer = HttpCodecUtils.checkAndResizeIfNeeded(memoryManager, dstBuffer, size)).hasArray()) {
            byte[] array = dstBuffer.array();
            int arrayOffs = dstBuffer.arrayOffset();
            int pos = arrayOffs + dstBuffer.position();
            for (int i = 0; i < size; ++i) {
                byte b = (byte)s.charAt(i);
                array[pos++] = HttpCodecUtils.isNonPrintableUsAscii(b) ? 32 : (int)b;
            }
            dstBuffer.position(pos - arrayOffs);
        } else {
            HttpCodecUtils.fastAsciiEncode(s, tempBuffer, dstBuffer);
        }
        return dstBuffer;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, byte[] array) {
        return HttpCodecUtils.put(memoryManager, dstBuffer, array, 0, array.length);
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, byte[] array, int off, int len) {
        dstBuffer = HttpCodecUtils.checkAndResizeIfNeeded(memoryManager, dstBuffer, len);
        dstBuffer.put(array, off, len);
        return dstBuffer;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, Buffer buffer) {
        int addSize = buffer.remaining();
        dstBuffer = HttpCodecUtils.checkAndResizeIfNeeded(memoryManager, dstBuffer, addSize);
        dstBuffer.put(buffer);
        return dstBuffer;
    }

    public static Buffer put(MemoryManager memoryManager, Buffer dstBuffer, byte value) {
        if (!dstBuffer.hasRemaining()) {
            dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, 1);
        }
        dstBuffer.put(value);
        return dstBuffer;
    }

    public static Buffer resizeBuffer(MemoryManager memoryManager, Buffer buffer, int grow) {
        return memoryManager.reallocate(buffer, Math.max(buffer.capacity() + grow, buffer.capacity() * 3 / 2 + 1));
    }

    private static void fastAsciiEncode(String s, byte[] tempBuffer, Buffer dstBuffer) {
        int totalLen = s.length();
        if (tempBuffer == null) {
            tempBuffer = new byte[totalLen];
        }
        int count = 0;
        while (count < totalLen) {
            int len = Math.min(totalLen - count, tempBuffer.length);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(count);
                tempBuffer[i] = (byte)(HttpCodecUtils.isNonPrintableUsAscii(c) ? 32 : (byte)c);
                ++count;
            }
            dstBuffer.put(tempBuffer, 0, len);
        }
    }

    private static boolean isNonPrintableUsAscii(int ub) {
        return ub <= 31 && ub != 9 || ub >= 127;
    }

    private static int checkCRLF(HttpCodecFilter.HeaderParsingState parsingState, byte b1, byte b2) {
        if (b1 == 13) {
            if (b2 == 10) {
                parsingState.offset += 2;
                return 0;
            }
            if (b2 == -1) {
                return -2;
            }
        } else if (b1 == 10) {
            ++parsingState.offset;
            return 0;
        }
        return -1;
    }

    private static boolean isNotSpaceAndTab(byte b) {
        return b != 32 && b != 9;
    }

    private static boolean isSpaceOrTab(byte b) {
        return b == 32 || b == 9;
    }

    private static Buffer checkAndResizeIfNeeded(MemoryManager memoryManager, Buffer dstBuffer, int length) {
        if (dstBuffer.remaining() < length) {
            dstBuffer = HttpCodecUtils.resizeBuffer(memoryManager, dstBuffer, length);
        }
        return dstBuffer;
    }
}

