/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpPacketParsing;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.HttpResponsePacketImpl;
import org.glassfish.grizzly.http.KeepAlive;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.ProcessingState;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.BufferChunk;
import org.glassfish.grizzly.http.util.ByteChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.FastHttpDateFormat;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HexUtils;
import org.glassfish.grizzly.http.util.HttpCodecUtils;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.HttpUtils;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class HttpServerFilter
extends HttpCodecFilter {
    public static final String HTTP_SERVER_REQUEST_ATTR_NAME = HttpServerFilter.class.getName() + ".HttpRequest";
    public static final FilterChainEvent RESPONSE_COMPLETE_EVENT = new FilterChainEvent(){

        @Override
        public Object type() {
            return "RESPONSE_COMPLETE_EVENT";
        }
    };
    private static final byte[] CLOSE_BYTES = new byte[]{99, 108, 111, 115, 101};
    private static final byte[] KEEPALIVE_BYTES = new byte[]{107, 101, 101, 112, 45, 97, 108, 105, 118, 101};
    private static final int[] DEC = HexUtils.getDecBytes();
    private final Attribute<ServerHttpRequestImpl> httpRequestInProcessAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HTTP_SERVER_REQUEST_ATTR_NAME);
    private final Attribute<KeepAliveContext> keepAliveContextAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("HttpServerFilter.KeepAliveContext");
    private final DelayedExecutor.DelayQueue<KeepAliveContext> keepAliveQueue;
    private final KeepAlive keepAlive;
    private final boolean processKeepAlive;
    private String defaultResponseContentType;
    private int maxRequestHeaders;
    private int maxResponseHeaders;

    @Deprecated
    public HttpServerFilter() {
        this(true, 8192, null, null);
    }

    @Deprecated
    public HttpServerFilter(boolean chunkingEnabled, int maxHeadersSize, KeepAlive keepAlive, DelayedExecutor executor) {
        this(chunkingEnabled, maxHeadersSize, Constants.DEFAULT_RESPONSE_TYPE, keepAlive, executor);
    }

    @Deprecated
    public HttpServerFilter(boolean chunkingEnabled, int maxHeadersSize, String defaultResponseContentType, KeepAlive keepAlive, DelayedExecutor executor) {
        this(chunkingEnabled, maxHeadersSize, defaultResponseContentType, keepAlive, executor, 100, 100);
    }

    @Deprecated
    public HttpServerFilter(boolean chunkingEnabled, int maxHeadersSize, String defaultResponseContentType, KeepAlive keepAlive, DelayedExecutor executor, int maxRequestHeaders, int maxResponseHeaders) {
        super(chunkingEnabled, maxHeadersSize);
        this.keepAliveQueue = executor != null ? executor.createDelayQueue(new KeepAliveWorker(keepAlive), new KeepAliveResolver()) : null;
        this.keepAlive = keepAlive;
        boolean bl = this.processKeepAlive = keepAlive != null;
        if (defaultResponseContentType != null && !defaultResponseContentType.isEmpty()) {
            this.defaultResponseContentType = defaultResponseContentType;
        }
        this.maxRequestHeaders = maxRequestHeaders;
        this.maxResponseHeaders = maxResponseHeaders;
    }

    public String getDefaultResponseContentType() {
        return this.defaultResponseContentType;
    }

    public void setDefaultResponseContentType(String defaultResponseContentType) {
        this.defaultResponseContentType = defaultResponseContentType;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer input = (Buffer)ctx.getMessage();
        Connection connection = ctx.getConnection();
        ServerHttpRequestImpl httpRequest = this.getHttpRequestInProcess(connection);
        if (httpRequest == null) {
            boolean isSecureLocal = HttpServerFilter.isSecure(connection);
            httpRequest = ServerHttpRequestImpl.create();
            httpRequest.initialize(connection, this, input.position(), this.maxHeadersSize, this.maxRequestHeaders);
            httpRequest.setSecure(isSecureLocal);
            HttpResponsePacket response = httpRequest.getResponse();
            response.setSecure(isSecureLocal);
            response.getHeaders().setMaxNumHeaders(this.maxResponseHeaders);
            httpRequest.setResponse(response);
            response.setRequest(httpRequest);
            if (this.processKeepAlive) {
                KeepAliveContext keepAliveContext = this.keepAliveContextAttr.get(connection);
                if (keepAliveContext == null) {
                    keepAliveContext = new KeepAliveContext(connection);
                    this.keepAliveContextAttr.set(connection, keepAliveContext);
                }
                keepAliveContext.request = httpRequest;
                int requestsProcessed = keepAliveContext.requestsProcessed;
                if (requestsProcessed > 0) {
                    KeepAlive.notifyProbesHit(this.keepAlive, connection, requestsProcessed);
                }
                if (this.keepAliveQueue != null) {
                    this.keepAliveQueue.remove(keepAliveContext);
                }
            }
            this.httpRequestInProcessAttr.set(connection, httpRequest);
        } else if (httpRequest.isContentBroken()) {
            return ctx.getStopAction();
        }
        return this.handleRead(ctx, httpRequest);
    }

    private ServerHttpRequestImpl getHttpRequestInProcess(Connection connection) {
        return this.httpRequestInProcessAttr.get(connection);
    }

    @Override
    final boolean decodeInitialLineFromBytes(FilterChainContext ctx, HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, byte[] input, int end) {
        ServerHttpRequestImpl httpRequest = (ServerHttpRequestImpl)httpPacket;
        int arrayOffs = parsingState.arrayOffset;
        int reqLimit = arrayOffs + parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpCodecUtils.findSpace(input, arrayOffs + parsingState.offset, end, reqLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                httpRequest.getMethodDC().setBytes(input, arrayOffs + parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx - arrayOffs;
            }
            case 1: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, arrayOffs + parsingState.offset, end, reqLimit) - arrayOffs;
                if (nonSpaceIdx < 0) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                if (!HttpServerFilter.parseRequestURI(httpRequest, parsingState, input, end)) {
                    return false;
                }
            }
            case 3: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, arrayOffs + parsingState.offset, end, reqLimit) - arrayOffs;
                if (nonSpaceIdx < 0) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpCodecUtils.findEOL(parsingState, input, end)) {
                    parsingState.offset = end - arrayOffs;
                    return false;
                }
                if (parsingState.checkpoint > parsingState.start) {
                    httpRequest.getProtocolDC().setBytes(input, arrayOffs + parsingState.start, arrayOffs + parsingState.checkpoint);
                } else {
                    httpRequest.getProtocolDC().setString("");
                }
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                this.onInitialLineParsed(httpRequest, ctx);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean parseRequestURI(ServerHttpRequestImpl httpRequest, HttpCodecFilter.HeaderParsingState state, byte[] input, int end) {
        int offset;
        int arrayOffs = state.arrayOffset;
        int limit = Math.min(end, arrayOffs + state.packetLimit);
        boolean found = false;
        for (offset = arrayOffs + state.offset; offset < limit; ++offset) {
            byte b = input[offset];
            if (b == 32 || b == 9) {
                found = true;
                break;
            }
            if (b == 13 || b == 10) {
                found = true;
                break;
            }
            if (b != 63 || state.checkpoint != -1) continue;
            state.checkpoint = offset - arrayOffs;
        }
        if (found) {
            int requestURIEnd = offset;
            if (state.checkpoint != -1) {
                requestURIEnd = arrayOffs + state.checkpoint;
                httpRequest.getQueryStringDC().setBytes(input, requestURIEnd + 1, offset);
            }
            httpRequest.getRequestURIRef().init(input, arrayOffs + state.start, requestURIEnd);
            state.start = -1;
            state.checkpoint = -1;
            ++state.subState;
        }
        state.offset = offset - arrayOffs;
        return found;
    }

    @Override
    final boolean decodeInitialLineFromBuffer(FilterChainContext ctx, HttpPacketParsing httpPacket, HttpCodecFilter.HeaderParsingState parsingState, Buffer input) {
        ServerHttpRequestImpl httpRequest = (ServerHttpRequestImpl)httpPacket;
        int reqLimit = parsingState.packetLimit;
        int subState = parsingState.subState++;
        switch (subState) {
            case 0: {
                int spaceIdx = HttpCodecUtils.findSpace(input, parsingState.offset, reqLimit);
                if (spaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                httpRequest.getMethodDC().setBuffer(input, parsingState.start, spaceIdx);
                parsingState.start = -1;
                parsingState.offset = spaceIdx;
            }
            case 1: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, parsingState.offset, reqLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx + 1;
                ++parsingState.subState;
            }
            case 2: {
                if (!HttpServerFilter.parseRequestURI(httpRequest, parsingState, input)) {
                    return false;
                }
            }
            case 3: {
                int nonSpaceIdx = HttpCodecUtils.skipSpaces(input, parsingState.offset, reqLimit);
                if (nonSpaceIdx == -1) {
                    parsingState.offset = input.limit();
                    return false;
                }
                parsingState.start = nonSpaceIdx;
                parsingState.offset = nonSpaceIdx;
                ++parsingState.subState;
            }
            case 4: {
                if (!HttpCodecUtils.findEOL(parsingState, input)) {
                    parsingState.offset = input.limit();
                    return false;
                }
                if (parsingState.checkpoint > parsingState.start) {
                    httpRequest.getProtocolDC().setBuffer(input, parsingState.start, parsingState.checkpoint);
                } else {
                    httpRequest.getProtocolDC().setString("");
                }
                parsingState.subState = 0;
                parsingState.start = -1;
                parsingState.checkpoint = -1;
                this.onInitialLineParsed(httpRequest, ctx);
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean parseRequestURI(ServerHttpRequestImpl httpRequest, HttpCodecFilter.HeaderParsingState state, Buffer input) {
        int offset;
        int limit = Math.min(input.limit(), state.packetLimit);
        boolean found = false;
        for (offset = state.offset; offset < limit; ++offset) {
            byte b = input.get(offset);
            if (b == 32 || b == 9) {
                found = true;
                break;
            }
            if (b == 13 || b == 10) {
                found = true;
                break;
            }
            if (b != 63 || state.checkpoint != -1) continue;
            state.checkpoint = offset;
        }
        if (found) {
            int requestURIEnd = offset;
            if (state.checkpoint != -1) {
                requestURIEnd = state.checkpoint;
                httpRequest.getQueryStringDC().setBuffer(input, state.checkpoint + 1, offset);
            }
            httpRequest.getRequestURIRef().init(input, state.start, requestURIEnd);
            state.start = -1;
            state.checkpoint = -1;
            ++state.subState;
        }
        state.offset = offset;
        return found;
    }

    @Override
    protected boolean onHttpHeaderParsed(HttpHeader httpHeader, Buffer buffer, FilterChainContext ctx) {
        ServerHttpRequestImpl request = (ServerHttpRequestImpl)httpHeader;
        this.prepareRequest(request, buffer.hasRemaining());
        return request.getProcessingState().error;
    }

    private void prepareRequest(ServerHttpRequestImpl request, boolean hasReadyContent) {
        boolean isHttp11;
        Protocol protocol2;
        ProcessingState state = request.getProcessingState();
        HttpResponsePacket response = request.getResponse();
        try {
            protocol2 = request.getProtocol();
        }
        catch (IllegalStateException e) {
            state.error = true;
            HttpStatus.HTTP_VERSION_NOT_SUPPORTED_505.setValues(response);
            Protocol protocol2 = Protocol.HTTP_1_1;
            request.setProtocol(protocol2);
            return;
        }
        boolean isUpgraded = !request.getUpgradeDC().isNull();
        request.getResponse().setChunkingAllowed(isUpgraded || this.isChunkingEnabled());
        if (isUpgraded) {
            return;
        }
        Method method = request.getMethod();
        Method.PayloadExpectation payloadExpectation = method.getPayloadExpectation();
        if (payloadExpectation != Method.PayloadExpectation.NOT_ALLOWED) {
            request.setExpectContent(request.getContentLength() != -1L || request.isChunked());
        } else {
            request.setExpectContent(method == Method.CONNECT);
        }
        if (request.getHeaderParsingState().contentLengthsDiffer) {
            request.getProcessingState().error = true;
            return;
        }
        MimeHeaders headers = request.getHeaders();
        DataChunk hostDC = null;
        DataChunk uriBC = request.getRequestURIRef().getRequestURIBC();
        if (uriBC.startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 4);
            int uriBCStart = uriBC.getStart();
            if (pos != -1) {
                int slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    uriBC.setStart(uriBCStart + pos + 1);
                    uriBC.setEnd(uriBCStart + pos + 2);
                } else {
                    uriBC.setStart(uriBCStart + slashPos);
                    uriBC.setEnd(uriBC.getEnd());
                }
                hostDC = headers.setValue("host");
                hostDC.set(uriBC, uriBCStart + pos + 3, uriBCStart + slashPos);
            }
        }
        boolean bl = isHttp11 = protocol2 == Protocol.HTTP_1_1;
        if (method == Method.CONNECT) {
            state.keepAlive = false;
        } else {
            boolean isConnectionClose;
            DataChunk connectionValueDC = headers.getValue(Header.Connection);
            boolean bl2 = isConnectionClose = connectionValueDC != null && connectionValueDC.equalsIgnoreCaseLowerCase(CLOSE_BYTES);
            if (!isConnectionClose) {
                boolean bl3 = state.keepAlive = isHttp11 || connectionValueDC != null && connectionValueDC.equalsIgnoreCaseLowerCase(KEEPALIVE_BYTES);
            }
        }
        if (hostDC == null) {
            hostDC = headers.getValue(Header.Host);
        }
        if (hostDC == null && isHttp11) {
            state.error = true;
            return;
        }
        HttpServerFilter.parseHost(hostDC, request, response, state);
        if (isHttp11 && request.serverName().getLength() == 0) {
            state.error = true;
            return;
        }
        if (request.requiresAcknowledgement()) {
            request.requiresAcknowledgement(isHttp11 && !hasReadyContent);
        }
    }

    private static void parseHost(DataChunk hostDC, HttpRequestPacket request, HttpResponsePacket response, ProcessingState state) {
        if (hostDC == null) {
            Connection connection = request.getConnection();
            request.setServerPort(((InetSocketAddress)connection.getLocalAddress()).getPort());
            InetAddress localAddress = ((InetSocketAddress)connection.getLocalAddress()).getAddress();
            request.setLocalHost(localAddress.getHostName());
            request.serverName().setString(localAddress.getHostName());
            return;
        }
        if (hostDC.getType() == DataChunk.Type.Bytes) {
            ByteChunk valueBC = hostDC.getByteChunk();
            int valueS = valueBC.getStart();
            int valueL = valueBC.getEnd() - valueS;
            int colonPos = -1;
            byte[] valueB = valueBC.getBuffer();
            boolean ipv6 = valueB[valueS] == 91;
            boolean bracketClosed = false;
            for (int i = 0; i < valueL; ++i) {
                byte b = valueB[i + valueS];
                if (b == 93) {
                    bracketClosed = true;
                    continue;
                }
                if (b != 58 || ipv6 && !bracketClosed) continue;
                colonPos = i;
                break;
            }
            if (colonPos < 0) {
                if (!request.isSecure()) {
                    request.setServerPort(80);
                } else {
                    request.setServerPort(443);
                }
                request.serverName().setBytes(valueB, valueS, valueS + valueL);
            } else {
                request.serverName().setBytes(valueB, valueS, valueS + colonPos);
                int port = 0;
                int mult = 1;
                for (int i = valueL - 1; i > colonPos; --i) {
                    int charValue = DEC[valueB[i + valueS]];
                    if (charValue == -1) {
                        state.error = true;
                        HttpStatus.BAD_REQUEST_400.setValues(response);
                        return;
                    }
                    port += charValue * mult;
                    mult = 10 * mult;
                }
                request.setServerPort(port);
            }
        } else {
            BufferChunk valueBC = hostDC.getBufferChunk();
            int valueS = valueBC.getStart();
            int valueL = valueBC.getEnd() - valueS;
            int colonPos = -1;
            Buffer valueB = valueBC.getBuffer();
            boolean ipv6 = valueB.get(valueS) == 91;
            boolean bracketClosed = false;
            for (int i = 0; i < valueL; ++i) {
                byte b = valueB.get(i + valueS);
                if (b == 93) {
                    bracketClosed = true;
                    continue;
                }
                if (b != 58 || ipv6 && !bracketClosed) continue;
                colonPos = i;
                break;
            }
            if (colonPos < 0) {
                if (!request.isSecure()) {
                    request.setServerPort(80);
                } else {
                    request.setServerPort(443);
                }
                request.serverName().setBuffer(valueB, valueS, valueS + valueL);
            } else {
                request.serverName().setBuffer(valueB, valueS, valueS + colonPos);
                int port = 0;
                int mult = 1;
                for (int i = valueL - 1; i > colonPos; --i) {
                    int charValue = DEC[valueB.get(i + valueS)];
                    if (charValue == -1) {
                        state.error = true;
                        HttpStatus.BAD_REQUEST_400.setValues(response);
                        return;
                    }
                    port += charValue * mult;
                    mult = 10 * mult;
                }
                request.setServerPort(port);
            }
        }
    }

    @Override
    protected final boolean onHttpPacketParsed(HttpHeader httpHeader, FilterChainContext ctx) {
        ServerHttpRequestImpl request = (ServerHttpRequestImpl)httpHeader;
        boolean error = request.getProcessingState().error;
        if (!error) {
            this.httpRequestInProcessAttr.remove(ctx.getConnection());
        }
        return error;
    }

    @Override
    protected void onInitialLineParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersParsed(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentParsed(HttpContent content, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeaderError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        ServerHttpRequestImpl request = (ServerHttpRequestImpl)httpHeader;
        HttpResponsePacket response = request.getResponse();
        this.sendBadRequestResponse(ctx, response);
    }

    @Override
    protected void onHttpContentError(HttpHeader httpHeader, FilterChainContext ctx, Throwable t) throws IOException {
        ServerHttpRequestImpl request = (ServerHttpRequestImpl)httpHeader;
        HttpResponsePacket response = request.getResponse();
        if (!response.isCommitted()) {
            this.sendBadRequestResponse(ctx, response);
        }
        httpHeader.setContentBroken(true);
    }

    @Override
    protected Buffer encodeHttpPacket(FilterChainContext ctx, HttpPacket input) {
        HttpContent encodedHttpContent;
        HttpContent content;
        HttpHeader header;
        boolean isHeaderPacket = input.isHeader();
        if (isHeaderPacket) {
            header = (HttpHeader)input;
            content = null;
        } else {
            content = (HttpContent)input;
            header = content.getHttpHeader();
        }
        boolean wasContentAlreadyEncoded = false;
        HttpResponsePacket response = (HttpResponsePacket)header;
        if (!response.isCommitted() && (encodedHttpContent = this.prepareResponse(ctx.getConnection(), response.getRequest(), response, content)) != null) {
            content = encodedHttpContent;
            wasContentAlreadyEncoded = true;
        }
        Buffer encoded = super.encodeHttpPacket(ctx, header, content, wasContentAlreadyEncoded);
        if (!isHeaderPacket) {
            input.recycle();
        }
        return encoded;
    }

    private HttpContent prepareResponse(Connection connection, HttpRequestPacket request, HttpResponsePacket response, HttpContent httpContent) {
        if (!response.getRequest().getUpgradeDC().isNull() || response.getUpgrade() != null) {
            return httpContent;
        }
        Protocol requestProtocol = request.getProtocol();
        if (requestProtocol == Protocol.HTTP_0_9) {
            return null;
        }
        boolean entityBody = true;
        int statusCode = response.getStatus();
        if (statusCode == 204 || statusCode == 205 || statusCode == 304) {
            entityBody = false;
            response.setExpectContent(false);
        }
        boolean isHttp11 = requestProtocol == Protocol.HTTP_1_1;
        HttpContent encodedHttpContent = null;
        Method method = request.getMethod();
        if (!Method.CONNECT.equals(method)) {
            this.setContentEncodingsOnSerializing(response);
            long contentLength = response.getContentLength();
            if (entityBody && contentLength == -1L && !response.isChunked()) {
                if (httpContent != null && httpContent.isLast()) {
                    if (!response.getContentEncodings(true).isEmpty()) {
                        encodedHttpContent = this.encodeContent(connection, httpContent);
                    }
                    response.setContentLength(httpContent.getContent().remaining());
                } else if (this.chunkingEnabled && isHttp11) {
                    response.setChunked(true);
                }
            }
            if (Method.HEAD.equals(method)) {
                response.setExpectContent(false);
            }
        } else {
            response.setContentEncodingsSelected(true);
            response.setContentLength(-1);
            response.setChunked(false);
        }
        MimeHeaders headers = response.getHeaders();
        if (!entityBody) {
            response.setContentLength(-1);
        } else {
            DataChunk contenTypeValue;
            String contentType;
            String contentLanguage = response.getContentLanguage();
            if (contentLanguage != null) {
                headers.setValue(Header.ContentLanguage).setString(contentLanguage);
            }
            if ((contentType = response.getContentType()) != null) {
                DataChunk contenTypeValue2 = headers.setValue(Header.ContentType);
                if (contenTypeValue2.isNull()) {
                    contenTypeValue2.setString(contentType);
                }
            } else if (this.defaultResponseContentType != null && (contenTypeValue = headers.setValue(Header.ContentType)).isNull()) {
                contenTypeValue.setString(HttpUtils.composeContentType(this.defaultResponseContentType, response.getCharacterEncoding()));
            }
        }
        if (!response.containsHeader(Header.Date)) {
            String date = FastHttpDateFormat.getCurrentDate();
            response.addHeader(Header.Date, date);
        }
        ProcessingState state = response.getProcessingState();
        if (entityBody && !isHttp11 && response.getContentLength() == -1L) {
            state.keepAlive = false;
        } else if (entityBody && !response.isChunked() && response.getContentLength() == -1L) {
            state.keepAlive = false;
        } else if (!this.checkKeepAliveRequestsCount(request.getConnection())) {
            state.keepAlive = false;
        }
        boolean bl = state.keepAlive = state.keepAlive && !HttpServerFilter.statusDropsConnection(response.getStatus());
        if (!state.keepAlive) {
            headers.setValue(Header.Connection).setBytes(CLOSE_BYTES);
        } else if (!isHttp11 && !state.error) {
            headers.setValue(Header.Connection).setBytes(KEEPALIVE_BYTES);
        }
        return encodedHttpContent;
    }

    @Override
    Buffer encodeInitialLine(HttpPacket httpPacket, Buffer output, MemoryManager memoryManager) {
        HttpResponsePacket httpResponse = (HttpResponsePacket)httpPacket;
        output = HttpCodecUtils.put(memoryManager, output, httpResponse.getProtocol().getProtocolBytes());
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = HttpCodecUtils.put(memoryManager, output, httpResponse.getHttpStatus().getStatusBytes());
        output = HttpCodecUtils.put(memoryManager, output, (byte)32);
        output = httpResponse.isCustomReasonPhraseSet() ? HttpCodecUtils.put(memoryManager, output, httpResponse.getTempHeaderEncodingBuffer(), HttpStatus.filter(httpResponse.getReasonPhraseDC())) : HttpCodecUtils.put(memoryManager, output, httpResponse.getHttpStatus().getReasonPhraseBytes());
        return output;
    }

    @Override
    protected void onInitialLineEncoded(HttpHeader header, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpHeadersEncoded(HttpHeader httpHeader, FilterChainContext ctx) {
    }

    @Override
    protected void onHttpContentEncoded(HttpContent content, FilterChainContext ctx) {
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        Connection c = ctx.getConnection();
        if (event.type() == RESPONSE_COMPLETE_EVENT.type() && c.isOpen()) {
            if (this.processKeepAlive) {
                KeepAliveContext keepAliveContext = this.keepAliveContextAttr.get(c);
                if (this.keepAliveQueue != null) {
                    this.keepAliveQueue.add(keepAliveContext, this.keepAlive.getIdleTimeoutInSeconds(), TimeUnit.SECONDS);
                }
                HttpRequestPacket httpRequest = keepAliveContext.request;
                boolean isStayAlive = this.isKeepAlive(httpRequest, keepAliveContext);
                keepAliveContext.request = null;
                this.processResponseComplete(ctx, httpRequest, isStayAlive);
            } else {
                ServerHttpRequestImpl httpRequest = this.getHttpRequestInProcess(c);
                if (httpRequest != null) {
                    this.processResponseComplete(ctx, httpRequest, false);
                }
                HttpServerFilter.flushAndClose(ctx);
            }
            return ctx.getStopAction();
        }
        return ctx.getInvokeAction();
    }

    private void processResponseComplete(FilterChainContext ctx, HttpRequestPacket httpRequest, boolean isStayAlive) throws IOException {
        boolean hasTransferEncoding;
        boolean bl = hasTransferEncoding = httpRequest.getTransferEncoding() != null;
        if (httpRequest.isExpectContent()) {
            if (hasTransferEncoding && !httpRequest.isContentBroken()) {
                httpRequest.setSkipRemainder(true);
            } else {
                httpRequest.setExpectContent(false);
                this.onHttpPacketParsed(httpRequest, ctx);
                HttpServerFilter.flushAndClose(ctx);
            }
        } else if (!isStayAlive) {
            HttpServerFilter.flushAndClose(ctx);
        }
    }

    protected HttpContent customizeErrorResponse(HttpResponsePacket response) {
        response.setContentLength(0);
        return ((HttpContent.Builder)HttpContent.builder(response).last(true)).build();
    }

    private static boolean statusDropsConnection(int status) {
        return status == 400 || status == 408 || status == 411 || status == 413 || status == 414 || status == 417 || status == 500 || status == 503 || status == 501 || status == 505;
    }

    private boolean isKeepAlive(HttpRequestPacket request, KeepAliveContext keepAliveContext) {
        boolean isKeepAlive = request.getProcessingState().isStayAlive();
        if (isKeepAlive && keepAliveContext != null && keepAliveContext.requestsProcessed == 1) {
            if (isKeepAlive) {
                KeepAlive.notifyProbesConnectionAccepted(this.keepAlive, keepAliveContext.connection);
            } else {
                KeepAlive.notifyProbesRefused(this.keepAlive, keepAliveContext.connection);
            }
        }
        return isKeepAlive;
    }

    private boolean checkKeepAliveRequestsCount(Connection connection) {
        boolean firstCheck;
        KeepAliveContext keepAliveContext = this.keepAliveContextAttr.get(connection);
        boolean bl = firstCheck = this.processKeepAlive && keepAliveContext != null;
        if (!firstCheck) {
            return true;
        }
        keepAliveContext.requestsProcessed++;
        int maxRequestCount = this.keepAlive.getMaxRequestsCount();
        return maxRequestCount == -1 || keepAliveContext.requestsProcessed <= maxRequestCount;
    }

    private void sendBadRequestResponse(FilterChainContext ctx, HttpResponsePacket response) {
        if (response.getHttpStatus().getStatusCode() < 400) {
            HttpStatus.BAD_REQUEST_400.setValues(response);
        }
        this.commitAndCloseAsError(ctx, response);
    }

    private void commitAndCloseAsError(FilterChainContext ctx, HttpResponsePacket response) {
        HttpContent errorHttpResponse = this.customizeErrorResponse(response);
        Buffer resBuf = this.encodeHttpPacket(ctx, errorHttpResponse);
        ctx.write(resBuf);
        ctx.flush(FLUSH_AND_CLOSE_HANDLER);
    }

    private static class KeepAliveContext {
        private final Connection connection;
        private volatile long keepAliveTimeoutMillis = -1L;
        private int requestsProcessed;
        private HttpRequestPacket request;

        public KeepAliveContext(Connection connection) {
            this.connection = connection;
        }
    }

    private static class KeepAliveResolver
    implements DelayedExecutor.Resolver<KeepAliveContext> {
        private KeepAliveResolver() {
        }

        @Override
        public boolean removeTimeout(KeepAliveContext context) {
            if (context.keepAliveTimeoutMillis != -1L) {
                context.keepAliveTimeoutMillis = -1L;
                return true;
            }
            return false;
        }

        @Override
        public long getTimeoutMillis(KeepAliveContext element) {
            return element.keepAliveTimeoutMillis;
        }

        @Override
        public void setTimeoutMillis(KeepAliveContext element, long timeoutMillis) {
            element.keepAliveTimeoutMillis = timeoutMillis;
        }
    }

    private static class KeepAliveWorker
    implements DelayedExecutor.Worker<KeepAliveContext> {
        private final KeepAlive keepAlive;

        public KeepAliveWorker(KeepAlive keepAlive) {
            this.keepAlive = keepAlive;
        }

        @Override
        public boolean doWork(KeepAliveContext context) {
            KeepAlive.notifyProbesTimeout(this.keepAlive, context.connection);
            context.connection.closeSilently();
            return true;
        }
    }

    private static final class ServerHttpRequestImpl
    extends HttpRequestPacket
    implements HttpPacketParsing {
        private static final ThreadCache.CachedTypeIndex<ServerHttpRequestImpl> CACHE_IDX = ThreadCache.obtainIndex(ServerHttpRequestImpl.class, 16);
        private boolean charEncodingParsed = false;
        private boolean contentTypeParsed;
        private boolean isHeaderParsed;
        private final HttpCodecFilter.HeaderParsingState headerParsingState = new HttpCodecFilter.HeaderParsingState();
        private final HttpCodecFilter.ContentParsingState contentParsingState = new HttpCodecFilter.ContentParsingState();
        private final ProcessingState processingState = new ProcessingState();
        private final HttpResponsePacket finalHttpResponse = new HttpResponsePacketImpl();

        public static ServerHttpRequestImpl create() {
            ServerHttpRequestImpl httpRequestImpl = ThreadCache.takeFromCache(CACHE_IDX);
            if (httpRequestImpl != null) {
                return httpRequestImpl;
            }
            return new ServerHttpRequestImpl();
        }

        private ServerHttpRequestImpl() {
            this.isExpectContent = true;
        }

        public void initialize(Connection connection, HttpCodecFilter filter, int initialOffset, int maxHeaderSize, int maxNumberOfHeaders) {
            this.headerParsingState.initialize(filter, initialOffset, maxHeaderSize);
            this.contentParsingState.trailerHeaders.setMaxNumHeaders(maxNumberOfHeaders);
            this.headers.setMaxNumHeaders(maxNumberOfHeaders);
            this.finalHttpResponse.setProtocol(Protocol.HTTP_1_1);
            this.setResponse(this.finalHttpResponse);
            this.setConnection(connection);
        }

        @Override
        public String getCharacterEncoding() {
            if (this.characterEncoding != null || this.charEncodingParsed) {
                return this.characterEncoding;
            }
            this.getContentType();
            this.charEncodingParsed = true;
            return this.characterEncoding;
        }

        @Override
        public String getContentType() {
            if (!this.contentTypeParsed) {
                DataChunk dc;
                this.contentTypeParsed = true;
                if (this.contentType == null && (dc = this.headers.getValue(Header.ContentType)) != null && !dc.isNull()) {
                    this.setContentType(dc.toString());
                }
            }
            return super.getContentType();
        }

        @Override
        public ProcessingState getProcessingState() {
            return this.processingState;
        }

        @Override
        public HttpCodecFilter.HeaderParsingState getHeaderParsingState() {
            return this.headerParsingState;
        }

        @Override
        public HttpCodecFilter.ContentParsingState getContentParsingState() {
            return this.contentParsingState;
        }

        @Override
        public boolean isHeaderParsed() {
            return this.isHeaderParsed;
        }

        @Override
        public void setHeaderParsed(boolean isHeaderParsed) {
            if (isHeaderParsed && this.isExpectContent() && !this.isChunked) {
                this.contentParsingState.chunkRemainder = this.getContentLength();
            }
            this.isHeaderParsed = isHeaderParsed;
        }

        @Override
        protected void reset() {
            this.charEncodingParsed = false;
            this.contentTypeParsed = false;
            this.isHeaderParsed = false;
            this.headerParsingState.recycle();
            this.contentParsingState.recycle();
            this.processingState.recycle();
            super.reset();
        }

        @Override
        public void recycle() {
            if (this.isExpectContent()) {
                return;
            }
            this.reset();
            ThreadCache.putToCache(CACHE_IDX, this);
        }
    }
}

