/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.glassfish.grizzly.config.ssl.ServerSocketFactory;
import org.glassfish.grizzly.http.util.StringManager;

public abstract class JSSESocketFactory
extends ServerSocketFactory {
    private static final StringManager sm = StringManager.getManager(JSSESocketFactory.class.getPackage().getName(), JSSESocketFactory.class.getClassLoader());
    public static final String defaultProtocol = "TLS";
    public static final String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    static final boolean defaultClientAuth = false;
    private static final String defaultKeyPass = "changeit";
    protected static final Logger logger = Logger.getLogger(JSSESocketFactory.class.getName());
    protected boolean initialized;
    protected boolean clientAuthNeed = false;
    protected boolean clientAuthWant = false;
    protected SSLServerSocketFactory sslProxy = null;
    protected String[] enabledCiphers;

    @Override
    public ServerSocket createSocket(int port) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public ServerSocket createSocket(int port, int backlog) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    @Override
    public Socket acceptSocket(ServerSocket socket) throws IOException {
        SSLSocket asock;
        try {
            asock = (SSLSocket)socket.accept();
            if (this.clientAuthNeed) {
                asock.setNeedClientAuth(this.clientAuthNeed);
            } else {
                asock.setWantClientAuth(this.clientAuthWant);
            }
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    @Override
    public void handshake(Socket sock) throws IOException {
        ((SSLSocket)sock).startHandshake();
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) {
        String[] enabled = null;
        if (requestedCiphers != null) {
            ArrayList<String> vec = null;
            String cipher = requestedCiphers;
            int index = requestedCiphers.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    cipher = requestedCiphers.substring(fromIndex, index).trim();
                    if (cipher.length() > 0) {
                        for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                            if (!supportedCiphers[i].equals(cipher)) continue;
                            if (vec == null) {
                                vec = new ArrayList();
                            }
                            vec.add(cipher);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedCiphers.indexOf(44, fromIndex);
                }
                cipher = requestedCiphers.substring(fromIndex);
            }
            if (cipher != null && (cipher = cipher.trim()).length() > 0) {
                for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                    if (!supportedCiphers[i].equals(cipher)) continue;
                    if (vec == null) {
                        vec = new ArrayList<String>();
                    }
                    vec.add(cipher);
                    break;
                }
            }
            if (vec != null) {
                enabled = vec.toArray(new String[vec.size()]);
            }
        }
        return enabled;
    }

    protected String getKeystorePassword() {
        String keystorePass;
        String keyPass = (String)this.attributes.get("keypass");
        if (keyPass == null) {
            keyPass = defaultKeyPass;
        }
        if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        return keystorePass;
    }

    protected KeyStore getKeystore(String pass) throws IOException {
        String keystoreFile = (String)this.attributes.get("keystore");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Keystore file= " + keystoreFile);
        }
        String keystoreType = (String)this.attributes.get("keystoreType");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Keystore type= " + keystoreType);
        }
        return this.getStore(keystoreType, keystoreFile, pass);
    }

    protected String getTruststorePassword() {
        String truststorePassword = (String)this.attributes.get("truststorePass");
        if (truststorePassword == null && (truststorePassword = System.getProperty("javax.net.ssl.trustStorePassword")) == null) {
            truststorePassword = this.getKeystorePassword();
        }
        return truststorePassword;
    }

    protected KeyStore getTrustStore() throws IOException {
        KeyStore ts = null;
        String truststore = (String)this.attributes.get("truststore");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Truststore file= " + truststore);
        }
        String truststoreType = (String)this.attributes.get("truststoreType");
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Truststore type= " + truststoreType);
        }
        String truststorePassword = this.getTruststorePassword();
        if (truststore != null && truststorePassword != null) {
            ts = this.getStore(truststoreType, truststore, truststorePassword);
        }
        return ts;
    }

    private KeyStore getStore(String type2, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = KeyStore.getInstance(type2);
            if (!"PKCS11".equalsIgnoreCase(type2) && !"".equalsIgnoreCase(path)) {
                File keyStoreFile = new File(path);
                if (!keyStoreFile.isAbsolute()) {
                    keyStoreFile = new File(System.getProperty("catalina.base"), path);
                }
                istream = new FileInputStream(keyStoreFile);
            }
            ks.load(istream, pass.toCharArray());
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.SEVERE, sm.getString("jsse.keystore_load_failed", type2, path, fnfe.getMessage()), fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, sm.getString("jsse.keystore_load_failed", type2, path, ioe.getMessage()), ioe);
            throw ioe;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, sm.getString("jsse.keystore_load_failed", type2, path, ex.getMessage()), ex);
            throw new IOException(sm.getString("jsse.keystore_load_failed", type2, path, ex.getMessage()));
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ks;
    }

    @Override
    public abstract void init() throws IOException;

    protected abstract String[] getEnabledProtocols(SSLServerSocket var1, String var2);

    protected abstract void setEnabledProtocols(SSLServerSocket var1, String[] var2);

    protected void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        if (this.attributes.get("ciphers") != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        }
        String requestedProtocols = (String)this.attributes.get("protocols");
        this.setEnabledProtocols(socket, this.getEnabledProtocols(socket, requestedProtocols));
        if (this.clientAuthNeed) {
            socket.setNeedClientAuth(this.clientAuthNeed);
        } else {
            socket.setWantClientAuth(this.clientAuthWant);
        }
    }
}

