/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config.dom;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DuckTyped;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
public interface ThreadPool
extends ConfigBeanProxy,
PropertyBag {
    public static final int IDLE_THREAD_TIMEOUT = 900;
    public static final int MAX_QUEUE_SIZE = 4096;
    public static final int MAX_THREADPOOL_SIZE = 5;
    public static final int MIN_THREADPOOL_SIZE = 5;

    @Attribute
    public String getClassname();

    public void setClassname(String var1);

    @Attribute(defaultValue="900", dataType=Integer.class)
    public String getIdleThreadTimeoutSeconds();

    public void setIdleThreadTimeoutSeconds(String var1);

    @Attribute(defaultValue="4096", dataType=Integer.class)
    public String getMaxQueueSize();

    public void setMaxQueueSize(String var1);

    @Attribute(defaultValue="5", dataType=Integer.class)
    public String getMaxThreadPoolSize();

    public void setMaxThreadPoolSize(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="5", dataType=Integer.class)
    public String getMinThreadPoolSize();

    public void setMinThreadPoolSize(String var1);

    @Attribute(required=true, key=true)
    public String getName();

    public void setName(String var1);

    @Attribute
    @Deprecated
    public String getThreadPoolId();

    public void setThreadPoolId(String var1);

    @DuckTyped
    public List<NetworkListener> findNetworkListeners();

    public static class Duck {
        public static List<NetworkListener> findNetworkListeners(ThreadPool threadpool) {
            NetworkConfig config = threadpool.getParent().getParent(NetworkConfig.class);
            if (!Dom.unwrap(config).getProxyType().equals(NetworkConfig.class)) {
                config = (NetworkConfig)Dom.unwrap(config).element("network-config").createProxy();
            }
            List<NetworkListener> listeners = config.getNetworkListeners().getNetworkListener();
            ArrayList<NetworkListener> refs = new ArrayList<NetworkListener>();
            for (NetworkListener listener : listeners) {
                if (!listener.getThreadPool().equals(threadpool.getName())) continue;
                refs.add(listener);
            }
            return refs;
        }
    }
}

