/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms.bootstrap;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.i18n.StringManager;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.logging.LogLevel;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=10)
public class GMSAdapterService
implements PostConstruct,
ConfigListener {
    private static final String GMSBS_LOGGER_NAME = "javax.enterprise.cluster.gms.bootstrap";
    private static final String LOG_MESSAGES_RB = "org.glassfish.cluster.gms.bootstrap.LogMessages";
    static final Logger GMSBS_LOGGER = Logger.getLogger("javax.enterprise.cluster.gms.bootstrap", "org.glassfish.cluster.gms.bootstrap.LogMessages");
    private static final String GMSBS_GMSADAPTER_NOT_AVAILABLE = "NLCS-CLSTR-10001";
    private static final StringManager strings = StringManager.getManager(GMSAdapterService.class);
    @Inject
    Clusters clusters;
    @Inject
    @Named(value="default-instance-name")
    Server server;
    @Inject
    ServerEnvironment env;
    @Inject
    private ServiceLocator habitat;
    @Inject
    StartupContext startupContext;
    @Inject
    private Provider<GMSAdapter> gmsAdapterProvider;
    private static final Object lock = new Object();
    List<GMSAdapter> gmsAdapters = new LinkedList<GMSAdapter>();
    private static final Level TRACE_LEVEL = LogLevel.FINE;

    @Override
    public void postConstruct() {
        Properties args;
        if (this.startupContext != null && (args = this.startupContext.getArguments()) != null && Boolean.valueOf(args.getProperty("-upgrade")).booleanValue()) {
            return;
        }
        if (this.clusters != null) {
            if (this.env.isDas()) {
                this.checkAllClusters(this.clusters);
            } else {
                Cluster cluster = this.server.getCluster();
                if (cluster != null) {
                    this.checkCluster(cluster);
                }
            }
        }
    }

    public String toString() {
        return "GMS Loader";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GMSAdapter getGMSAdapter() {
        Object object = lock;
        synchronized (object) {
            if (this.gmsAdapters.size() > 1) {
                throw new IllegalStateException(strings.getString("use.getByName"));
            }
            if (this.gmsAdapters.size() == 1) {
                return this.gmsAdapters.get(0);
            }
            return null;
        }
    }

    public boolean isGmsEnabled() {
        return this.gmsAdapters.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GMSAdapter getGMSAdapterByName(String clusterName) {
        Object object = lock;
        synchronized (object) {
            return this.habitat.getService(GMSAdapter.class, clusterName, new Annotation[0]);
        }
    }

    private void checkAllClusters(Clusters clusters) {
        if (GMSBS_LOGGER.isLoggable(TRACE_LEVEL)) {
            GMSBS_LOGGER.log(TRACE_LEVEL, "In DAS. Checking all clusters.");
        }
        for (Cluster cluster : clusters.getCluster()) {
            this.checkCluster(cluster);
        }
    }

    private GMSAdapter checkCluster(Cluster cluster) {
        GMSAdapter result = null;
        String gmsEnString = cluster.getGmsEnabled();
        if (GMSBS_LOGGER.isLoggable(TRACE_LEVEL)) {
            GMSBS_LOGGER.log(TRACE_LEVEL, String.format("cluster %s found with gms-enabled='%s'", cluster.getName(), gmsEnString));
        }
        if (gmsEnString != null && Boolean.parseBoolean(gmsEnString)) {
            result = this.loadModule(cluster);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GMSAdapter loadModule(Cluster cluster) {
        GMSAdapter result = null;
        Object object = lock;
        synchronized (object) {
            result = this.getGMSAdapterByName(cluster.getName());
            if (GMSBS_LOGGER.isLoggable(TRACE_LEVEL)) {
                GMSBS_LOGGER.log(TRACE_LEVEL, "lookup GMSAdapter by clusterName=" + cluster.getName() + " returned " + result);
            }
            if (result == null) {
                if (GMSBS_LOGGER.isLoggable(TRACE_LEVEL)) {
                    GMSBS_LOGGER.log(TRACE_LEVEL, "creating gms-adapter for clustername " + cluster.getName() + " since no gms adapter found for clustername " + cluster.getName());
                }
                if ((result = this.gmsAdapterProvider.get()) == null) {
                    GMSBS_LOGGER.log(LogLevel.WARNING, GMSBS_GMSADAPTER_NOT_AVAILABLE);
                    return null;
                }
                boolean initResult = result.initialize(cluster.getName());
                if (!initResult) {
                    return null;
                }
                ServiceLocatorUtilities.addOneConstant(this.habitat, result, cluster.getName(), new Type[]{GMSAdapter.class});
                if (GMSBS_LOGGER.isLoggable(TRACE_LEVEL)) {
                    GMSBS_LOGGER.log(TRACE_LEVEL, "loadModule: registered created gmsadapter for cluster " + cluster.getName() + " initialized result=" + initResult);
                }
                this.gmsAdapters.add(result);
            }
        }
        return result;
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] events) {
        if (this.env.isDas()) {
            return ConfigSupport.sortAndDispatch(events, new Changed(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> changedType, T changedInstance) {
                    Cluster cluster;
                    if (changedType == Cluster.class && type2 == Changed.TYPE.ADD) {
                        GroupManagementService gms;
                        GMSAdapter localGmsAdapter;
                        cluster = (Cluster)changedInstance;
                        if (GMSBS_LOGGER.isLoggable(TRACE_LEVEL)) {
                            GMSBS_LOGGER.log(TRACE_LEVEL, "ClusterChangeEvent add cluster " + cluster.getName());
                        }
                        if ((localGmsAdapter = GMSAdapterService.this.checkCluster(cluster)) != null && (gms = localGmsAdapter.getModule()) != null) {
                            gms.reportJoinedAndReadyState();
                        }
                    }
                    if (changedType == Cluster.class && type2 == Changed.TYPE.REMOVE) {
                        cluster = (Cluster)changedInstance;
                        if (GMSBS_LOGGER.isLoggable(TRACE_LEVEL)) {
                            GMSBS_LOGGER.log(TRACE_LEVEL, "ClusterChangeEvent remove cluster " + cluster.getName());
                        }
                        Object object = lock;
                        synchronized (object) {
                            GMSAdapter localGmsAdapter = GMSAdapterService.this.getGMSAdapterByName(cluster.getName());
                            if (localGmsAdapter != null) {
                                GMSAdapterService.this.gmsAdapters.remove(localGmsAdapter);
                                localGmsAdapter.getModule().shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                                ServiceLocatorUtilities.removeFilter(GMSAdapterService.this.habitat, BuilderHelper.createNameAndContractFilter(GMSAdapter.class.getName(), cluster.getName()));
                                localGmsAdapter.complete();
                            }
                        }
                    }
                    return null;
                }
            }, GMSBS_LOGGER);
        }
        return null;
    }
}

