/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.glassfish.external.statistics.AverageRangeStatistic;
import org.glassfish.external.statistics.BoundaryStatistic;
import org.glassfish.external.statistics.BoundedRangeStatistic;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.RangeStatistic;
import org.glassfish.external.statistics.Statistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.TimeStatistic;
import org.glassfish.gmbal.AMXClient;
import org.glassfish.gmbal.AMXMBeanInterface;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.IncludeSubclass;
import org.glassfish.gmbal.InheritedAttribute;
import org.glassfish.gmbal.InheritedAttributes;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.gmbal.ManagedObjectManager;
import org.glassfish.gmbal.impl.AttributeDescriptor;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.MBeanImpl;
import org.glassfish.gmbal.impl.MBeanSkeleton;
import org.glassfish.gmbal.impl.MBeanTree;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;
import org.glassfish.gmbal.impl.ObjectRegistrationManagerImpl;
import org.glassfish.gmbal.impl.TimerAnnotationHelper;
import org.glassfish.gmbal.impl.TypeConverter;
import org.glassfish.gmbal.impl.TypeConverterImpl;
import org.glassfish.gmbal.impl.trace.TraceRegistration;
import org.glassfish.gmbal.impl.trace.TraceRegistrationFine;
import org.glassfish.gmbal.typelib.EvaluatedClassAnalyzer;
import org.glassfish.gmbal.typelib.EvaluatedClassDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedFieldDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedMethodDeclaration;
import org.glassfish.gmbal.typelib.EvaluatedType;
import org.glassfish.gmbal.typelib.TypeEvaluator;
import org.glassfish.pfl.basic.algorithm.Algorithms;
import org.glassfish.pfl.basic.algorithm.ClassAnalyzer;
import org.glassfish.pfl.basic.algorithm.DelayedObjectToString;
import org.glassfish.pfl.basic.algorithm.DumpIgnore;
import org.glassfish.pfl.basic.algorithm.ObjectUtility;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.facet.FacetAccessor;
import org.glassfish.pfl.basic.facet.FacetAccessorImpl;
import org.glassfish.pfl.basic.func.UnaryFunction;
import org.glassfish.pfl.basic.func.UnaryPredicate;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.glassfish.pfl.tf.timer.spi.ObjectRegistrationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TraceRegistration
@TraceRegistrationFine
public class ManagedObjectManagerImpl
implements ManagedObjectManagerInternal {
    private static final AMXMetadata DEFAULT_AMX_METADATA = DefaultAMXMetadataHolder.class.getAnnotation(AMXMetadata.class);
    private static ObjectUtility myObjectUtil = new ObjectUtility(true, 0, 4).useToString(EvaluatedType.class).useToString(ManagedObjectManager.class);
    private static Comparator<String> REV_COMP = new StringComparator();
    @DumpIgnore
    private final String domain;
    private final MBeanTree tree;
    private final Map<EvaluatedClassDeclaration, MBeanSkeleton> skeletonMap;
    private final Map<EvaluatedType, TypeConverter> typeConverterMap;
    private final Map<AnnotatedElement, Map<Class, Annotation>> addedAnnotations;
    private final MBeanSkeleton amxSkeleton;
    private final Set<String> amxAttributeNames;
    private final ObjectRegistrationManager orm;
    private boolean rootCreated;
    private ResourceBundle resourceBundle;
    private MBeanServer server;
    private ManagedObjectManager.RegistrationDebugLevel regDebugLevel;
    private boolean runDebugFlag;
    private boolean jmxRegistrationDebugFlag;
    private final SortedSet<String> typePrefixes = new TreeSet<String>(REV_COMP);
    private boolean stripPackagePrefix = false;
    List<Pair<Class, Class>> statsData = Algorithms.list(Algorithms.pair(DummyStringStatistic.class, StringStatistic.class), Algorithms.pair(DummyTimeStatistic.class, TimeStatistic.class), Algorithms.pair(DummyStatistic.class, Statistic.class), Algorithms.pair(DummyBoundaryStatistic.class, BoundaryStatistic.class), Algorithms.pair(DummyBoundedRangeStatistic.class, BoundedRangeStatistic.class), Algorithms.pair(DummyCountStatistic.class, CountStatistic.class), Algorithms.pair(DummyRangeStatistic.class, RangeStatistic.class), Algorithms.pair(DummyAverageRangeStatistic.class, AverageRangeStatistic.class));
    private Map<AnnotatedElement, Map<Class, Annotation>> annotationCache = new WeakHashMap<AnnotatedElement, Map<Class, Annotation>>();

    private ManagedObjectManagerImpl(String domain, ObjectName rootParentName) {
        this.domain = domain;
        this.tree = new MBeanTree(this, domain, rootParentName, "type");
        this.skeletonMap = new WeakHashMap<EvaluatedClassDeclaration, MBeanSkeleton>();
        this.typeConverterMap = new WeakHashMap<EvaluatedType, TypeConverter>();
        this.addedAnnotations = new HashMap<AnnotatedElement, Map<Class, Annotation>>();
        EvaluatedClassDeclaration ecd = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(AMXMBeanInterface.class);
        this.amxAttributeNames = new HashSet<String>();
        this.amxSkeleton = this.getSkeleton(ecd);
        for (MBeanAttributeInfo mbi : this.amxSkeleton.getMBeanInfo().getAttributes()) {
            this.amxAttributeNames.add(mbi.getName());
        }
        this.orm = new ObjectRegistrationManagerImpl(this);
    }

    private void addAnnotationIfNotNull(AnnotatedElement elemement, Annotation annotation) {
        if (annotation != null) {
            this.addAnnotation(elemement, annotation);
        }
    }

    private void initializeStatisticsSupport() {
        for (Pair<Class, Class> pair : this.statsData) {
            Class dummy = pair.first();
            Class real = pair.second();
            this.addAnnotationIfNotNull(real, dummy.getAnnotation(ManagedData.class));
            this.addAnnotationIfNotNull(real, dummy.getAnnotation(Description.class));
            this.addAnnotationIfNotNull(real, dummy.getAnnotation(InheritedAttributes.class));
        }
    }

    private void init() {
        this.server = AccessController.doPrivileged(new PrivilegedAction<MBeanServer>(){

            @Override
            public MBeanServer run() {
                return ManagementFactory.getPlatformMBeanServer();
            }
        });
        this.rootCreated = false;
        this.resourceBundle = null;
        this.regDebugLevel = ManagedObjectManager.RegistrationDebugLevel.NONE;
        this.runDebugFlag = false;
        this.jmxRegistrationDebugFlag = false;
        this.tree.clear();
        this.skeletonMap.clear();
        this.typeConverterMap.clear();
        this.addedAnnotations.clear();
        this.initializeStatisticsSupport();
        TimerAnnotationHelper.registerTimerClasses(this);
    }

    public ManagedObjectManagerImpl(String domain) {
        this(domain, null);
        this.init();
    }

    public ManagedObjectManagerImpl(ObjectName rootParentName) {
        this(rootParentName.getDomain(), rootParentName);
        this.init();
    }

    @Override
    @TraceRegistration
    public void close() throws IOException {
        this.init();
    }

    private synchronized void checkRootNotCreated(String methodName) {
        if (this.rootCreated) {
            throw Exceptions.self.createRootCalled(methodName);
        }
    }

    private synchronized void checkRootCreated(String methodName) {
        if (!this.rootCreated) {
            throw Exceptions.self.createRootNotCalled(methodName);
        }
    }

    @Override
    public synchronized void suspendJMXRegistration() {
        this.tree.suspendRegistration();
    }

    @Override
    public synchronized void resumeJMXRegistration() {
        this.tree.resumeRegistration();
    }

    @Override
    public synchronized void stripPackagePrefix() {
        this.checkRootNotCreated("stripPackagePrefix");
        this.stripPackagePrefix = true;
    }

    public String toString() {
        return "ManagedObjectManagerImpl[domain=" + this.domain + "]";
    }

    @Override
    public synchronized ObjectName getRootParentName() {
        this.checkRootCreated("getRootParentName");
        return this.tree.getRootParentName();
    }

    @Override
    public synchronized GmbalMBean createRoot() {
        return this.createRoot(new Root());
    }

    @Override
    public synchronized GmbalMBean createRoot(Object root) {
        return this.createRoot(root, null);
    }

    @Override
    public synchronized GmbalMBean createRoot(Object root, String name) {
        GmbalMBean result;
        this.checkRootNotCreated("createRoot");
        try {
            this.rootCreated = true;
            result = this.tree.setRoot(root, name);
            if (result == null) {
                this.rootCreated = false;
            }
        }
        catch (RuntimeException exc) {
            this.rootCreated = false;
            throw exc;
        }
        return result;
    }

    @Override
    public synchronized Object getRoot() {
        return this.tree.getRoot();
    }

    @InfoMethod
    private void message(String msg) {
    }

    @InfoMethod
    private void describe(String msg, Object data) {
    }

    @TraceRegistration
    private synchronized MBeanSkeleton getSkeleton(EvaluatedClassDeclaration cls) {
        boolean newSkeleton;
        MBeanSkeleton result = this.skeletonMap.get(cls);
        boolean bl = newSkeleton = result == null;
        if (newSkeleton) {
            this.message("Skeleton not found");
            Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer> pair = this.getClassAnalyzer(cls, ManagedObject.class);
            EvaluatedClassAnalyzer ca = pair.second();
            EvaluatedClassDeclaration annotatedClass = pair.first();
            this.describe("Annotated class for skeleton", annotatedClass);
            if (annotatedClass == null) {
                throw Exceptions.self.managedObjectAnnotationNotFound(cls.name());
            }
            MBeanSkeleton skel = new MBeanSkeleton(cls, ca, this);
            result = this.amxSkeleton == null ? skel : this.amxSkeleton.compose(skel);
            this.skeletonMap.put(cls, result);
        }
        if (newSkeleton) {
            this.describe("Skeleton", new DelayedObjectToString(result, myObjectUtil));
        }
        return result;
    }

    @Override
    @TraceRegistrationFine
    public synchronized TypeConverter getTypeConverter(EvaluatedType type2) {
        TypeConverter result = null;
        boolean newTypeConverter = false;
        result = this.typeConverterMap.get(type2);
        if (result == null) {
            this.message("Creating new TypeConverter");
            this.typeConverterMap.put(type2, new TypeConverterImpl.TypeConverterPlaceHolderImpl(type2));
            result = TypeConverterImpl.makeTypeConverter(type2, this);
            this.typeConverterMap.put(type2, result);
            newTypeConverter = true;
        }
        if (newTypeConverter) {
            this.describe("result", myObjectUtil.objectToString(result));
        }
        return result;
    }

    private static Field getDeclaredField(final Class<?> cls, final String name) throws PrivilegedActionException, NoSuchFieldException {
        SecurityManager sman = System.getSecurityManager();
        if (sman == null) {
            return cls.getDeclaredField(name);
        }
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

            @Override
            public Field run() throws Exception {
                return cls.getDeclaredField(name);
            }
        });
    }

    private String getAMXTypeFromField(Class<?> cls, String fieldName) {
        try {
            final Field fld = ManagedObjectManagerImpl.getDeclaredField(cls, fieldName);
            if (Modifier.isFinal(fld.getModifiers()) && Modifier.isStatic(fld.getModifiers()) && fld.getType().equals(String.class)) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        fld.setAccessible(true);
                        return null;
                    }
                });
                return (String)fld.get(null);
            }
            return "";
        }
        catch (PrivilegedActionException ex) {
            return "";
        }
        catch (IllegalArgumentException ex) {
            return "";
        }
        catch (IllegalAccessException ex) {
            return "";
        }
        catch (NoSuchFieldException ex) {
            return "";
        }
        catch (SecurityException ex) {
            return "";
        }
    }

    private boolean goodResult(String str) {
        return str != null && str.length() > 0;
    }

    @Override
    public synchronized String getTypeName(Class<?> cls, String fieldName, String nameFromAnnotation) {
        String result = this.getAMXTypeFromField(cls, fieldName);
        if (this.goodResult(result)) {
            return result;
        }
        if (this.goodResult(nameFromAnnotation)) {
            return nameFromAnnotation;
        }
        String className = cls.getName();
        for (String str : this.typePrefixes) {
            if (!className.startsWith(str)) continue;
            return className.substring(str.length() + 1);
        }
        if (this.stripPackagePrefix) {
            int lastDot = className.lastIndexOf(46);
            if (lastDot == -1) {
                return className;
            }
            return className.substring(lastDot + 1);
        }
        return className;
    }

    @Override
    public synchronized boolean isManagedObject(Object obj) {
        EvaluatedClassDeclaration cdecl = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(obj.getClass());
        ManagedObject mo = this.getFirstAnnotationOnClass(cdecl, ManagedObject.class);
        return mo != null;
    }

    @Override
    @TraceRegistration
    public synchronized MBeanImpl constructMBean(MBeanImpl parentEntity, Object obj, String name) {
        MBeanImpl result = null;
        String objName = name;
        try {
            Class<?> cls = obj.getClass();
            EvaluatedClassDeclaration cdecl = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(cls);
            MBeanSkeleton skel = this.getSkeleton(cdecl);
            AMXMetadata amd = this.getFirstAnnotationOnClass(cdecl, AMXMetadata.class);
            if (amd == null) {
                amd = this.getDefaultAMXMetadata();
            }
            String type2 = skel.getType();
            this.describe("Stripped type", type2);
            result = new MBeanImpl(skel, obj, this.server, type2);
            if (objName == null && (objName = skel.getNameValue(result)) == null) {
                objName = "";
            }
            if (objName.length() == 0) {
                if (!amd.isSingleton()) {
                    throw Exceptions.self.nonSingletonRequiresName(parentEntity, type2);
                }
            } else if (amd.isSingleton()) {
                throw Exceptions.self.singletonCannotSpecifyName(parentEntity, type2, name);
            }
            this.describe("Name value", objName);
            result.name(objName);
        }
        catch (JMException exc) {
            throw Exceptions.self.errorInConstructingMBean(objName, exc);
        }
        return result;
    }

    @Override
    @TraceRegistration
    public synchronized GmbalMBean register(Object parent, Object obj, String name) {
        this.checkRootCreated("register");
        if (obj instanceof String) {
            throw Exceptions.self.objStringWrongRegisterCall((String)obj);
        }
        try {
            MBeanImpl parentEntity = this.tree.getParentEntity(parent);
            MBeanImpl mb = this.constructMBean(parentEntity, obj, name);
            return this.tree.register(parentEntity, obj, mb);
        }
        catch (JMException exc) {
            throw Exceptions.self.exceptionInRegister(exc);
        }
    }

    @Override
    public synchronized GmbalMBean register(Object parent, Object obj) {
        return this.register(parent, obj, null);
    }

    @Override
    public synchronized GmbalMBean registerAtRoot(Object obj, String name) {
        return this.register(this.tree.getRoot(), obj, name);
    }

    @Override
    public synchronized GmbalMBean registerAtRoot(Object obj) {
        return this.register(this.tree.getRoot(), obj, null);
    }

    @Override
    @TraceRegistration
    public synchronized void unregister(Object obj) {
        this.checkRootCreated("unregister");
        try {
            this.tree.unregister(obj);
        }
        catch (JMException exc) {
            throw Exceptions.self.exceptionInUnregister(exc);
        }
    }

    @Override
    @TraceRegistration
    public synchronized ObjectName getObjectName(Object obj) {
        this.checkRootCreated("getObjectName");
        if (obj instanceof ObjectName) {
            return (ObjectName)obj;
        }
        if (obj instanceof AMXClient) {
            return ((AMXClient)obj).objectName();
        }
        ObjectName result = this.tree.getObjectName(obj);
        return result;
    }

    @Override
    public AMXClient getAMXClient(Object obj) {
        ObjectName oname = this.getObjectName(obj);
        if (oname == null) {
            return null;
        }
        return new AMXClient(this.server, oname);
    }

    @Override
    @TraceRegistration
    public synchronized Object getObject(ObjectName oname) {
        this.checkRootCreated("getObject");
        Object result = this.tree.getObject(oname);
        return result;
    }

    @Override
    public synchronized FacetAccessor getFacetAccessor(Object obj) {
        MBeanImpl mb = this.tree.getMBeanImpl(obj);
        if (mb != null) {
            return this.tree.getFacetAccessor(obj);
        }
        return new FacetAccessorImpl(obj);
    }

    @Override
    public synchronized String getDomain() {
        return this.domain;
    }

    @Override
    public synchronized void setMBeanServer(MBeanServer server) {
        this.checkRootNotCreated("setMBeanServer");
        this.server = server;
    }

    @Override
    public synchronized MBeanServer getMBeanServer() {
        return this.server;
    }

    @Override
    public synchronized void setResourceBundle(ResourceBundle rb) {
        this.checkRootNotCreated("setResourceBundle");
        this.resourceBundle = rb;
    }

    @Override
    public synchronized ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public synchronized String getDescription(EvaluatedDeclaration element) {
        Description desc;
        if (element instanceof EvaluatedClassDeclaration) {
            EvaluatedClassDeclaration ecd = (EvaluatedClassDeclaration)element;
            desc = this.getFirstAnnotationOnClass(ecd, Description.class);
        } else {
            desc = this.getAnnotation(element.element(), Description.class);
        }
        String result = "";
        if (desc != null) {
            result = desc.value();
        }
        if (result.length() == 0) {
            result = Exceptions.self.noDescriptionAvailable();
        } else if (this.resourceBundle != null) {
            result = this.resourceBundle.getString(result);
        }
        return result;
    }

    @Override
    @TraceRegistration
    public synchronized void addAnnotation(AnnotatedElement element, Annotation annotation) {
        Class<? extends Annotation> annotationType;
        Annotation ann;
        this.checkRootNotCreated("addAnnotation");
        if (annotation == null) {
            throw Exceptions.self.cannotAddNullAnnotation(element);
        }
        Map<Class, Annotation> map = this.addedAnnotations.get(element);
        if (map == null) {
            this.message("Creating new Map<Class,Annotation>");
            map = new HashMap<Class, Annotation>();
            this.addedAnnotations.put(element, map);
        }
        if ((ann = map.get(annotationType = annotation.annotationType())) != null) {
            this.message("Duplicate annotation");
            throw Exceptions.self.duplicateAnnotation(element, annotation.getClass().getName());
        }
        map.put(annotationType, annotation);
    }

    @Override
    @TraceRegistration
    public synchronized void addInheritedAnnotations(Class<?> cls) {
        this.checkRootNotCreated("addInheritedAnnotation");
    }

    @Override
    public <T extends Annotation> T getFirstAnnotationOnClass(EvaluatedClassDeclaration element, Class<T> type2) {
        EvaluatedClassAnalyzer eca = new EvaluatedClassAnalyzer(element);
        List<EvaluatedClassDeclaration> ecds = eca.findClasses(this.forAnnotation(type2, EvaluatedClassDeclaration.class));
        if (ecds.size() > 0) {
            return this.getAnnotation(ecds.get(0).element(), type2);
        }
        return null;
    }

    private Map<Class, Annotation> getAllAnnotations(Class cls) {
        Map<Class, Annotation> result = this.annotationCache.get(cls);
        if (result == null) {
            final HashMap<Class, Annotation> res = new HashMap<Class, Annotation>();
            ClassAnalyzer ca = ClassAnalyzer.getClassAnalyzer(cls);
            ca.findClasses(new UnaryPredicate<Class<?>>(){

                @Override
                public boolean evaluate(Class arg) {
                    Annotation[] annots;
                    for (Annotation anno : annots = arg.getDeclaredAnnotations()) {
                        ManagedObjectManagerImpl.this.putIfNotPresent(res, anno.annotationType(), anno);
                    }
                    Map emap = (Map)ManagedObjectManagerImpl.this.addedAnnotations.get(arg);
                    if (emap != null) {
                        for (Map.Entry entry : emap.entrySet()) {
                            ManagedObjectManagerImpl.this.putIfNotPresent(res, entry.getKey(), entry.getValue());
                        }
                    }
                    return true;
                }
            });
            this.annotationCache.put(cls, res);
            result = res;
        }
        return result;
    }

    @Override
    @TraceRegistrationFine
    public synchronized <T extends Annotation> T getAnnotation(AnnotatedElement element, Class<T> type2) {
        if (element instanceof Class) {
            Class cls = (Class)element;
            Map<Class, Annotation> annos = this.getAllAnnotations(cls);
            return (T)annos.get(type2);
        }
        Object result = element.getAnnotation(type2);
        if (result == null) {
            this.message("No annotation on element: trying addedAnnotations map");
            Map<Class, Annotation> map = this.addedAnnotations.get(element);
            if (map != null) {
                result = map.get(type2);
            }
        }
        return result;
    }

    @Override
    @TraceRegistrationFine
    public synchronized Collection<Annotation> getAnnotations(AnnotatedElement elem) {
        if (elem instanceof Class) {
            Class cls = (Class)elem;
            return this.getAllAnnotations(cls).values();
        }
        if (elem instanceof Method) {
            return Arrays.asList(elem.getAnnotations());
        }
        if (elem instanceof Field) {
            return Arrays.asList(elem.getAnnotations());
        }
        throw Exceptions.self.annotationsNotSupported(elem);
    }

    @Override
    @TraceRegistration
    public synchronized Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer> getClassAnalyzer(final EvaluatedClassDeclaration cls, final Class<? extends Annotation> annotationClass) {
        EvaluatedClassAnalyzer clsca = new EvaluatedClassAnalyzer(cls);
        EvaluatedClassDeclaration annotatedClass = Algorithms.getFirst(clsca.findClasses(this.forAnnotation(annotationClass, EvaluatedClassDeclaration.class)), new Runnable(){

            public void run() {
                throw Exceptions.self.noAnnotationFound(annotationClass.getName(), cls.name());
            }
        });
        this.describe("annotatedClass", annotatedClass);
        ArrayList<EvaluatedClassDeclaration> classes = new ArrayList<EvaluatedClassDeclaration>();
        classes.add(cls);
        IncludeSubclass incsub = this.getFirstAnnotationOnClass(cls, IncludeSubclass.class);
        if (incsub != null) {
            for (Class klass : incsub.value()) {
                EvaluatedClassDeclaration ecd = (EvaluatedClassDeclaration)TypeEvaluator.getEvaluatedType(klass);
                classes.add(ecd);
                this.describe("included subclass", klass);
            }
        }
        EvaluatedClassAnalyzer ca = new EvaluatedClassAnalyzer(classes);
        return new Pair<EvaluatedClassDeclaration, EvaluatedClassAnalyzer>(annotatedClass, ca);
    }

    @Override
    @TraceRegistration
    public synchronized List<InheritedAttribute> getInheritedAttributes(EvaluatedClassAnalyzer ca) {
        UnaryPredicate<EvaluatedClassDeclaration> pred = Algorithms.or(this.forAnnotation(InheritedAttribute.class, EvaluatedClassDeclaration.class), this.forAnnotation(InheritedAttributes.class, EvaluatedClassDeclaration.class));
        List<EvaluatedClassDeclaration> iaClasses = ca.findClasses(pred);
        List<InheritedAttribute> isList = Algorithms.flatten(iaClasses, new UnaryFunction<EvaluatedClassDeclaration, List<InheritedAttribute>>(){

            @Override
            public List<InheritedAttribute> evaluate(EvaluatedClassDeclaration cls) {
                InheritedAttribute ia = ManagedObjectManagerImpl.this.getFirstAnnotationOnClass(cls, InheritedAttribute.class);
                InheritedAttributes ias = ManagedObjectManagerImpl.this.getFirstAnnotationOnClass(cls, InheritedAttributes.class);
                if (ia != null && ias != null) {
                    throw Exceptions.self.badInheritedAttributeAnnotation(cls);
                }
                ArrayList<InheritedAttribute> result = new ArrayList<InheritedAttribute>();
                if (ia != null) {
                    result.add(ia);
                } else if (ias != null) {
                    result.addAll(Arrays.asList(ias.value()));
                }
                return result;
            }
        });
        return isList;
    }

    private AttributeDescriptor getAttributeDescriptorIfInherited(EvaluatedMethodDeclaration method, List<InheritedAttribute> ias, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        ADHolder adh = new ADHolder(method, adt);
        Algorithms.find(ias, adh);
        return adh.content();
    }

    @Override
    @TraceRegistrationFine
    public synchronized <K, V> void putIfNotPresent(Map<K, V> map, K key, V value) {
        if (!map.containsKey(key)) {
            this.message("Adding key, value to map");
            map.put(key, value);
        } else {
            this.message("Key,value already in map");
        }
    }

    static void checkFieldType(EvaluatedFieldDeclaration field) {
        if (!Modifier.isFinal(field.modifiers()) || !field.fieldType().isImmutable()) {
            Exceptions.self.illegalAttributeField(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> getAttributes(EvaluatedClassAnalyzer ca, final ManagedObjectManagerInternal.AttributeDescriptorType adt) {
        final HashMap getters = new HashMap();
        final HashMap setters = new HashMap();
        Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> result = new Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>>(getters, setters);
        final List<InheritedAttribute> ias = this.getInheritedAttributes(ca);
        ca.findFields(new UnaryPredicate<EvaluatedFieldDeclaration>(){

            @Override
            public boolean evaluate(EvaluatedFieldDeclaration field) {
                ManagedAttribute ma = ManagedObjectManagerImpl.this.getAnnotation(field.element(), ManagedAttribute.class);
                if (ma == null) {
                    return false;
                }
                ManagedObjectManagerImpl.checkFieldType(field);
                Description desc = ManagedObjectManagerImpl.this.getAnnotation(field.element(), Description.class);
                String description = desc == null ? "No description available for " + field.name() : desc.value();
                AttributeDescriptor ad = AttributeDescriptor.makeFromAnnotated(ManagedObjectManagerImpl.this, field, ma.id(), description, adt);
                ManagedObjectManagerImpl.this.putIfNotPresent(getters, ad.id(), ad);
                return true;
            }
        });
        ca.findMethods(new UnaryPredicate<EvaluatedMethodDeclaration>(){

            @Override
            public boolean evaluate(EvaluatedMethodDeclaration method) {
                AttributeDescriptor ad;
                ManagedAttribute ma = ManagedObjectManagerImpl.this.getAnnotation(method.element(), ManagedAttribute.class);
                if (ma == null) {
                    ad = ManagedObjectManagerImpl.this.getAttributeDescriptorIfInherited(method, ias, adt);
                } else {
                    Description desc = ManagedObjectManagerImpl.this.getAnnotation(method.element(), Description.class);
                    String description = desc == null ? "No description available for " + method.name() : desc.value();
                    ad = AttributeDescriptor.makeFromAnnotated(ManagedObjectManagerImpl.this, method, ma.id(), description, adt);
                }
                if (ad != null) {
                    if (ad.atype() == AttributeDescriptor.AttributeType.GETTER) {
                        ManagedObjectManagerImpl.this.putIfNotPresent(getters, ad.id(), ad);
                    } else {
                        ManagedObjectManagerImpl.this.putIfNotPresent(setters, ad.id(), ad);
                    }
                }
                return false;
            }
        });
        Pair<Map<String, AttributeDescriptor>, Map<String, AttributeDescriptor>> pair = result;
        return pair;
    }

    @Override
    public synchronized void setRegistrationDebug(ManagedObjectManager.RegistrationDebugLevel level) {
        this.regDebugLevel = level;
    }

    @Override
    public synchronized void setJMXRegistrationDebug(boolean flag) {
        this.jmxRegistrationDebugFlag = flag;
    }

    @Override
    public synchronized void setRuntimeDebug(boolean flag) {
        this.runDebugFlag = flag;
    }

    @Override
    public synchronized void setTypelibDebug(int level) {
        TypeEvaluator.setDebugLevel(level);
    }

    @Override
    public synchronized String dumpSkeleton(Object obj) {
        MBeanImpl impl = this.tree.getMBeanImpl(obj);
        if (impl == null) {
            return obj + " is not currently registered with mom " + this;
        }
        MBeanSkeleton skel = impl.skeleton();
        String skelString = myObjectUtil.objectToString(skel);
        return "Skeleton for MBean for object " + obj + ":\n" + skelString;
    }

    @Override
    public synchronized boolean registrationDebug() {
        return this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.NORMAL || this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.FINE;
    }

    @Override
    public synchronized boolean registrationFineDebug() {
        return this.regDebugLevel == ManagedObjectManager.RegistrationDebugLevel.FINE;
    }

    @Override
    public synchronized boolean runtimeDebug() {
        return this.runDebugFlag;
    }

    @Override
    public synchronized boolean jmxRegistrationDebug() {
        return this.jmxRegistrationDebugFlag;
    }

    @Override
    public synchronized void stripPrefix(String ... args) {
        this.checkRootNotCreated("stripPrefix");
        for (String str : args) {
            this.typePrefixes.add(str);
        }
    }

    @Override
    public synchronized <T extends EvaluatedDeclaration> UnaryPredicate<T> forAnnotation(final Class<? extends Annotation> annotation, Class<T> cls) {
        return new UnaryPredicate<T>(){

            @Override
            public boolean evaluate(T elem) {
                return ManagedObjectManagerImpl.this.getAnnotation(elem.element(), annotation) != null;
            }
        };
    }

    @Override
    public AMXMetadata getDefaultAMXMetadata() {
        return DEFAULT_AMX_METADATA;
    }

    @Override
    public boolean isAMXAttributeName(String name) {
        return this.amxAttributeNames.contains(name);
    }

    @Override
    public void suppressDuplicateRootReport(boolean suppressReport) {
        this.checkRootNotCreated("suppressDuplicateRootReport");
        this.tree.setSuppressDuplicateSetRootReport(suppressReport);
    }

    @Override
    public ObjectRegistrationManager getObjectRegistrationManager() {
        return this.orm;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ADHolder
    implements UnaryPredicate<InheritedAttribute> {
        private final EvaluatedMethodDeclaration method;
        private final ManagedObjectManagerInternal.AttributeDescriptorType adt;
        private AttributeDescriptor content;

        public ADHolder(EvaluatedMethodDeclaration method, ManagedObjectManagerInternal.AttributeDescriptorType adt) {
            this.method = method;
            this.adt = adt;
        }

        @Override
        public boolean evaluate(InheritedAttribute ia) {
            boolean result;
            AttributeDescriptor ad = AttributeDescriptor.makeFromInherited(ManagedObjectManagerImpl.this, this.method, ia.id(), ia.methodName(), ia.description(), this.adt);
            boolean bl = result = ad != null;
            if (result) {
                this.content = ad;
            }
            return result;
        }

        public AttributeDescriptor content() {
            return this.content;
        }
    }

    @AMXMetadata
    static class DefaultAMXMetadataHolder {
        DefaultAMXMetadataHolder() {
        }
    }

    @ManagedData
    @Description(value="Adds an average to the range statistic")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getAverage", description="The average value of this attribute since its last reset")})
    public static interface DummyAverageRangeStatistic {
    }

    @ManagedData
    @Description(value="Specifies standard measurements of the upper and lower limits of the value of an attribute")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getUpperBound", description="The upper limit of the value of this attribute"), @InheritedAttribute(methodName="getLowerBound", description="The lower limit of the value of this attribute")})
    public static interface DummyBoundaryStatistic
    extends DummyStatistic {
    }

    @ManagedData
    @Description(value="Provides standard measurements of a range that has fixed limits")
    public static interface DummyBoundedRangeStatistic
    extends DummyBoundaryStatistic,
    DummyRangeStatistic {
    }

    @ManagedData
    @Description(value="Specifies standard count measurements")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getCount", description="The count since the last reset")})
    public static interface DummyCountStatistic {
    }

    @ManagedData
    @Description(value="Specifies standard measurements of the lowest and highest values an attribute has held as well as its current value")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getHighWaterMark", description="The highest value this attribute has held since the beginninYg of the measurement"), @InheritedAttribute(methodName="getLowWaterMark", description="The lowest value this attribute has held since the beginninYg of the measurement"), @InheritedAttribute(methodName="getCurrent", description="The current value of this attribute")})
    public static interface DummyRangeStatistic {
    }

    @ManagedData
    @Description(value="The Statistic model and its sub-models specify the data models which are requried to be used to provide the performance data described by the specific attributes in the Stats models")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getName", description="The name of this Statistic"), @InheritedAttribute(methodName="getUnit", description="The unit of measurement for this Statistic"), @InheritedAttribute(methodName="getDescription", description="A human-readable description of the Statistic"), @InheritedAttribute(methodName="getStartTime", description="The time of the first measurement represented as a long"), @InheritedAttribute(methodName="getLastSampleTime", description="The time of the first measurement represented as a long")})
    public static interface DummyStatistic {
    }

    @ManagedData
    @Description(value="Custom statistic type whose value is a string")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getCurrent", description="Returns the String value of the statistic")})
    public static interface DummyStringStatistic
    extends DummyStatistic {
    }

    @ManagedData
    @Description(value="Specifies standard timing measurements")
    @InheritedAttributes(value={@InheritedAttribute(methodName="getCount", description="Number of times the operation was invoked since the beginning of this measurement"), @InheritedAttribute(methodName="getMaxTime", description="The maximum amount of time taken to complete one invocation of this operation since the beginning of this measurement"), @InheritedAttribute(methodName="getMinTime", description="The minimum amount of time taken to complete one invocation of this operation since the beginning of this measurement"), @InheritedAttribute(methodName="getTotalTime", description="The total amount of time taken to complete every invocation of this operation since the beginning of this measurement")})
    public static interface DummyTimeStatistic
    extends DummyStatistic {
    }

    @ManagedObject
    @AMXMetadata(type="gmbal-root", isSingleton=true)
    @Description(value="Dummy class used when no root is specified")
    private static class Root {
        private Root() {
        }

        public String toString() {
            return "GmbalDefaultRoot";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringComparator
    implements Serializable,
    Comparator<String> {
        private static final long serialVersionUID = 8274851916877850245L;

        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return -o1.compareTo(o2);
        }
    }
}

