/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.enterprise.iiop.api;

import com.sun.logging.LogDomains;
import java.nio.channels.SelectableChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.grizzly.LazyServiceInitializer;
import org.jvnet.hk2.annotations.Service;

@Service
public class ORBLazyServiceInitializer
implements LazyServiceInitializer,
PostConstruct {
    static Logger logger = LogDomains.getLogger(ORBLazyServiceInitializer.class, "javax.enterprise.system");
    @Inject
    private GlassFishORBHelper orbHelper;
    boolean initializedSuccessfully = false;

    @Override
    public void postConstruct() {
    }

    @Override
    public String getServiceName() {
        return "iiop-service";
    }

    @Override
    public boolean initializeService() {
        try {
            this.orbHelper.getORB();
            this.initializedSuccessfully = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ORB initialization failed in lazy init", e);
        }
        return this.initializedSuccessfully;
    }

    @Override
    public void handleRequest(SelectableChannel channel) {
        if (this.initializedSuccessfully) {
            this.orbHelper.getSelectableChannelDelegate().handleRequest(channel);
        } else {
            logger.log(Level.WARNING, "Cannot handle SelectableChannel request in ORBLazyServiceInitializer.ORB did not initialize successfully");
        }
    }
}

