/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.embeddable.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import org.glassfish.embeddable.archive.ScatteredArchive;
import org.glassfish.embeddable.archive.ScatteredEnterpriseArchive;

class Assembler {
    private static final List<Pattern> EXCLUDE_JAR_ENTRIES = new ArrayList<Pattern>();

    Assembler() {
    }

    public URI assemble(ScatteredArchive archive) throws IOException {
        switch (archive.type) {
            case WAR: {
                return this.assembleWAR(archive.name, archive.rootDirectory, archive.classpaths, archive.metadatas);
            }
            case JAR: {
                return this.assembleJAR(archive.name, archive.rootDirectory, archive.classpaths, archive.metadatas);
            }
            case RAR: {
                return this.assembleRAR(archive.name, archive.rootDirectory, archive.classpaths, archive.metadatas);
            }
        }
        return null;
    }

    public URI assemble(ScatteredEnterpriseArchive archive) throws IOException {
        return this.assembleEAR(archive.name, archive.archives, archive.metadatas);
    }

    private URI assembleEAR(String name, Map<String, File> archives, Map<String, File> metadatas) throws IOException {
        File ear = new File(System.getProperty("java.io.tmpdir"), name + ".ear");
        ear.deleteOnExit();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(ear));
        for (String key : metadatas.keySet()) {
            this.tranferFile(metadatas.get(key), jos, key, false);
        }
        for (String archiveName : archives.keySet()) {
            File archive = archives.get(archiveName);
            if (archive.isDirectory()) {
                archive = new File(this.assembleJAR(archiveName, archive, Collections.EMPTY_LIST, Collections.EMPTY_MAP));
            }
            this.tranferFile(archive, jos, archiveName, false);
        }
        jos.close();
        return ear.toURI();
    }

    URI assembleWAR(String name, File rootDirectory, List<File> classpaths, Map<String, File> metadatas) throws IOException {
        File archive = new File(System.getProperty("java.io.tmpdir"), name + ".war");
        archive.deleteOnExit();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(archive));
        this.transferDir(rootDirectory, jos, "");
        for (String key : metadatas.keySet()) {
            this.tranferFile(metadatas.get(key), jos, key, false);
        }
        for (File classpath : classpaths) {
            if (classpath.isDirectory()) {
                this.transferDir(classpath, jos, "WEB-INF/classes/");
                continue;
            }
            this.tranferFile(classpath, jos, "WEB-INF/lib/" + classpath.getName(), false);
        }
        jos.close();
        return archive.toURI();
    }

    URI assembleJAR(String name, File rootDirectory, List<File> classpaths, Map<String, File> metadatas) throws IOException {
        File archive = new File(System.getProperty("java.io.tmpdir"), name + ".jar");
        archive.deleteOnExit();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(archive));
        this.transferDir(rootDirectory, jos, "");
        for (String key : metadatas.keySet()) {
            this.tranferFile(metadatas.get(key), jos, key, false);
        }
        for (File classpath : classpaths) {
            if (classpath.isDirectory()) {
                this.transferDir(classpath, jos, "");
                continue;
            }
            this.tranferFile(classpath, jos, "", true);
        }
        jos.close();
        return archive.toURI();
    }

    URI assembleRAR(String name, File rootDirectory, List<File> classpaths, Map<String, File> metadatas) throws IOException {
        File rar = new File(System.getProperty("java.io.tmpdir"), name + ".rar");
        rar.deleteOnExit();
        JarOutputStream jos = new JarOutputStream(new FileOutputStream(rar));
        this.transferDir(rootDirectory, jos, "");
        for (String key : metadatas.keySet()) {
            this.tranferFile(metadatas.get(key), jos, key, false);
        }
        ArrayList<File> classpathDirs = new ArrayList<File>();
        for (File classpath : classpaths) {
            if (!classpath.isDirectory()) continue;
            classpathDirs.add(classpath);
        }
        if (!classpathDirs.isEmpty()) {
            String connectorJarName = name;
            ArrayList<String> topLevelFileNames = new ArrayList<String>();
            topLevelFileNames.addAll(this.getFileNames(classpaths));
            topLevelFileNames.addAll(this.getFileNames(rootDirectory));
            int count = 0;
            while (topLevelFileNames.contains(connectorJarName + ".jar")) {
                connectorJarName = name + "_" + count;
                ++count;
            }
            File connectorJar = new File(this.assembleJAR(connectorJarName, null, classpathDirs, Collections.EMPTY_MAP));
            this.tranferFile(connectorJar, jos, connectorJar.getName(), false);
        }
        for (File classpath : classpaths) {
            if (classpath.isDirectory()) continue;
            this.tranferFile(classpath, jos, classpath.getName(), false);
        }
        jos.close();
        return rar.toURI();
    }

    void transferDir(File dir2, JarOutputStream jos, String entryNamePrefix) throws IOException {
        this.transferDir(dir2, dir2, jos, entryNamePrefix);
    }

    void transferDir(File basedir, File dir2, JarOutputStream jos, String entryNamePrefix) throws IOException {
        if (dir2 == null || jos == null) {
            return;
        }
        for (File f : dir2.listFiles()) {
            if (f.isFile()) {
                String entryName = entryNamePrefix + f.getPath().substring(basedir.getPath().length() + 1);
                this.tranferFile(f, jos, entryName, false);
                continue;
            }
            this.transferDir(basedir, f, jos, entryNamePrefix);
        }
    }

    void tranferFile(File file, JarOutputStream jos, String entryName, boolean explodeFile) throws IOException {
        if (explodeFile) {
            this.tranferEntries(file, jos);
        } else {
            this.transferFile(file, jos, entryName);
        }
    }

    void transferFile(File file, JarOutputStream jos, String entryName) throws IOException {
        if (file == null || jos == null || entryName == null) {
            return;
        }
        ZipEntry entry = new ZipEntry(entryName);
        try {
            jos.putNextEntry(entry);
        }
        catch (ZipException ex) {
            return;
        }
        FileInputStream fin = new FileInputStream(file);
        this.transferContents(fin, jos);
        jos.closeEntry();
    }

    void tranferEntries(File file, JarOutputStream jos) throws IOException {
        if (file == null || jos == null) {
            return;
        }
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || this.exclude(entry)) continue;
            InputStream in = jarFile.getInputStream(entry);
            try {
                jos.putNextEntry(new ZipEntry(entry.getName()));
            }
            catch (ZipException ex) {
                continue;
            }
            this.transferContents(in, jos);
            jos.closeEntry();
        }
    }

    void transferContents(InputStream fin, JarOutputStream jos) throws IOException {
        if (fin == null || jos == null) {
            return;
        }
        int read = 0;
        byte[] buffer = new byte[8192];
        while ((read = fin.read(buffer, 0, buffer.length)) != -1) {
            jos.write(buffer, 0, read);
        }
        jos.flush();
    }

    private List<String> getFileNames(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            return this.getFileNames(Arrays.asList(directory.listFiles()));
        }
        return Collections.EMPTY_LIST;
    }

    private List<String> getFileNames(List<File> files) {
        ArrayList<String> result = new ArrayList<String>();
        for (File f : files) {
            if (f.isDirectory()) continue;
            result.add(f.getName());
        }
        return result;
    }

    private boolean exclude(JarEntry entry) {
        for (Pattern p : EXCLUDE_JAR_ENTRIES) {
            if (!p.matcher(entry.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        EXCLUDE_JAR_ENTRIES.add(Pattern.compile("META-INF/MANIFEST\\.MF"));
        EXCLUDE_JAR_ENTRIES.add(Pattern.compile("META-INF/.*\\.RSA"));
        EXCLUDE_JAR_ENTRIES.add(Pattern.compile("META-INF/.*\\.inf"));
        EXCLUDE_JAR_ENTRIES.add(Pattern.compile("META-INF/.*\\.SF"));
    }
}

