/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;

public class InstalledLibrariesResolver {
    private static Map<Extension, String> extDirsLibsStore = new HashMap<Extension, String>();
    private static Set extDirJars = new LinkedHashSet();
    private static Map<Extension, String> appLibsDirLibsStore = new HashMap<Extension, String>();
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    private static final String PACKAGE_NOT_FOUND = "NCLS-DEPLOYMENT-00011";
    private static final String PACKAGE_SATISFIED = "NCLS-DEPLOYMENT-00012";
    private static final String INVALID_ZIP = "NCLS-DEPLOYMENT-00013";
    private static final String EXCEPTION_OCCURRED = "NCLS-DEPLOYMENT-00014";
    private static final String NULL_SPEC_VERS = "NCLS-DEPLOYMENT-00015";
    private static final String SKIPPING_PROCESSING_INFO = "NCLS-DEPLOYMENT-00016";

    public static boolean resolveDependencies(Manifest manifest, String archiveUri) {
        try {
            InstalledLibrariesResolver.getInstalledLibraries(archiveUri, manifest, true, extDirsLibsStore);
        }
        catch (MissingResourceException e) {
            try {
                InstalledLibrariesResolver.getInstalledLibraries(archiveUri, manifest, true, appLibsDirLibsStore);
            }
            catch (MissingResourceException e1) {
                deplLogger.log(Level.WARNING, PACKAGE_NOT_FOUND, new Object[]{e1.getClass(), archiveUri});
                return false;
            }
        }
        deplLogger.log(Level.INFO, PACKAGE_SATISFIED, new Object[]{archiveUri});
        return true;
    }

    public static void initializeInstalledLibRegistry(String libDir) {
        InstalledLibrariesResolver.initializeInstalledLibRegistryForExtDirs();
        InstalledLibrariesResolver.initializeInstalledLibRegistryForApplibs(libDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeInstalledLibRegistryForExtDirs() {
        String ext_dirStr = System.getProperty("java.ext.dirs");
        deplLogger.fine("ext-Dir-Str : " + ext_dirStr);
        Vector<String> extDirs = new Vector<String>();
        StringTokenizer st = new StringTokenizer(ext_dirStr, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            deplLogger.log(Level.FINE, "string tokens..." + next);
            extDirs.addElement(next);
        }
        for (int v = 0; v < extDirs.size(); ++v) {
            File extDir = new File((String)extDirs.elementAt(v));
            if (deplLogger.isLoggable(Level.FINE)) {
                deplLogger.log(Level.FINE, "extension dir..." + extDir);
            }
            ArrayList validExtDirLibFiles = new ArrayList();
            File[] installedLibraries = extDir.listFiles();
            if (installedLibraries == null) continue;
            try {
                Map<Extension, String> installedLibrariesList = InstalledLibrariesResolver.getInstalledLibraries(extDir.getAbsolutePath(), extDirJars, validExtDirLibFiles);
                extDirsLibsStore.putAll(installedLibrariesList);
                for (File file : validExtDirLibFiles) {
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(file);
                        Manifest m = jarFile.getManifest();
                        if (m == null) continue;
                        try {
                            InstalledLibrariesResolver.getInstalledLibraries(file.getAbsolutePath(), m, true, extDirsLibsStore);
                        }
                        catch (MissingResourceException e) {
                            deplLogger.log(Level.WARNING, PACKAGE_NOT_FOUND, new Object[]{e.getClass(), file.getAbsolutePath()});
                        }
                    }
                    catch (IOException ioe) {
                        deplLogger.log(Level.WARNING, INVALID_ZIP, new Object[]{file.getAbsolutePath(), ioe.getMessage()});
                    }
                    finally {
                        if (jarFile == null) continue;
                        jarFile.close();
                    }
                }
                continue;
            }
            catch (IOException e) {
                deplLogger.log(Level.WARNING, EXCEPTION_OCCURRED, new Object[]{e.getMessage()});
            }
        }
    }

    public static String getExtDirFilesAsClasspath() {
        StringBuffer classpath = new StringBuffer();
        for (String next : extDirJars) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(next);
        }
        return classpath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getInstalledLibraries(ReadableArchive archive) throws IOException {
        HashSet<String> libraries = new HashSet<String>();
        if (archive != null) {
            Manifest manifest = archive.getManifest();
            Set<String> installedLibraries = InstalledLibrariesResolver.getInstalledLibraries(archive.getURI().toString(), manifest, false, appLibsDirLibsStore);
            libraries.addAll(installedLibraries);
            Vector libs = InstalledLibrariesResolver.getArchiveLibraries(archive);
            if (libs != null) {
                for (String libUri : libs) {
                    ZipInputStream jis = null;
                    try {
                        InputStream libIs = archive.getEntry(libUri);
                        if (libIs == null || (manifest = ((JarInputStream)(jis = new JarInputStream(libIs))).getManifest()) == null) continue;
                        Set<String> jarLibraries = InstalledLibrariesResolver.getInstalledLibraries(archive.getURI().toString(), manifest, false, appLibsDirLibsStore);
                        libraries.addAll(jarLibraries);
                    }
                    finally {
                        if (jis != null) {
                            jis.close();
                        }
                    }
                }
            }
        }
        return libraries;
    }

    private static Set<String> getInstalledLibraries(String archiveURI, Manifest manifest, boolean strict, Map<Extension, String> libraryStore) {
        String extensionList;
        HashSet<String> libraries;
        block10: {
            libraries = new HashSet<String>();
            extensionList = null;
            try {
                extensionList = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_LIST);
                if (deplLogger.isLoggable(Level.FINE)) {
                    deplLogger.fine("Extension-List for archive [" + archiveURI + "] : " + extensionList);
                }
            }
            catch (Exception e) {
                if (!deplLogger.isLoggable(Level.FINE)) break block10;
                deplLogger.log(Level.FINE, "InstalledLibrariesResolver : exception occurred : " + e.toString());
            }
        }
        if (extensionList != null) {
            StringTokenizer st = new StringTokenizer(extensionList, " ");
            while (st.hasMoreTokens()) {
                boolean isLibraryInstalled;
                String token = st.nextToken().trim();
                String extName = manifest.getMainAttributes().getValue(token + "-" + Attributes.Name.EXTENSION_NAME);
                if (extName != null) {
                    extName = extName.trim();
                }
                String specVersion = manifest.getMainAttributes().getValue(token + "-" + Attributes.Name.SPECIFICATION_VERSION);
                Extension extension = new Extension(extName);
                if (specVersion != null) {
                    extension.setSpecVersion(specVersion);
                }
                if (isLibraryInstalled = libraryStore.containsKey(extension)) {
                    String libraryName = libraryStore.get(extension);
                    libraries.add(libraryName);
                } else if (strict) {
                    throw new MissingResourceException(extName + " not found", extName, null);
                }
                if (!deplLogger.isLoggable(Level.FINEST)) continue;
                deplLogger.log(Level.FINEST, " is library installed [" + extName + "] " + "for archive [" + archiveURI + "]: " + isLibraryInstalled);
            }
        }
        return libraries;
    }

    private static Vector getArchiveLibraries(ReadableArchive archive) {
        Enumeration<String> entries = archive.entries();
        if (entries == null) {
            return null;
        }
        Vector<String> libs = new Vector<String>();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement();
            if (entryName.indexOf(47) != -1 || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initializeInstalledLibRegistryForApplibs(String domainLibDir) {
        String applibsDirString = domainLibDir + File.separator + "applibs";
        deplLogger.fine("applib-Dir-String..." + applibsDirString);
        ArrayList validApplibsDirLibFiles = new ArrayList();
        Map<Extension, String> installedLibraries = InstalledLibrariesResolver.getInstalledLibraries(applibsDirString, null, validApplibsDirLibFiles);
        appLibsDirLibsStore.putAll(installedLibraries);
        for (File file : validApplibsDirLibFiles) {
            JarFile jarFile = null;
            jarFile = new JarFile(file);
            Manifest m = jarFile.getManifest();
            if (m != null) {
                boolean found = true;
                try {
                    InstalledLibrariesResolver.getInstalledLibraries(file.getAbsolutePath(), m, true, appLibsDirLibsStore);
                }
                catch (MissingResourceException mre) {
                    found = false;
                }
                if (!found) {
                    try {
                        InstalledLibrariesResolver.getInstalledLibraries(file.getAbsolutePath(), m, true, extDirsLibsStore);
                    }
                    catch (MissingResourceException mre) {
                        deplLogger.log(Level.WARNING, PACKAGE_NOT_FOUND, new Object[]{mre.getClass(), file.getAbsolutePath()});
                    }
                }
            }
            if (jarFile == null) continue;
            try {
                jarFile.close();
            }
            catch (IOException e) {
                deplLogger.log(Level.WARNING, EXCEPTION_OCCURRED, new Object[]{e.getMessage()});
            }
            continue;
            catch (IOException ioe) {
                try {
                    deplLogger.log(Level.WARNING, INVALID_ZIP, new Object[]{file.getAbsolutePath(), ioe.getMessage()});
                    if (jarFile == null) continue;
                }
                catch (Throwable throwable) {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {
                            deplLogger.log(Level.WARNING, EXCEPTION_OCCURRED, new Object[]{e.getMessage()});
                        }
                    }
                    throw throwable;
                }
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    deplLogger.log(Level.WARNING, EXCEPTION_OCCURRED, new Object[]{e.getMessage()});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Extension, String> getInstalledLibraries(String libraryDirectoryName, Set processedLibraryNames, List processedLibraries) {
        File[] libraries;
        HashMap<Extension, String> installedLibraries = new HashMap<Extension, String>();
        File dir2 = new File(libraryDirectoryName);
        if (deplLogger.isLoggable(Level.FINE)) {
            deplLogger.log(Level.FINE, "installed library directory : " + dir2);
        }
        if ((libraries = dir2.listFiles()) != null) {
            try {
                for (int i = 0; i < libraries.length; ++i) {
                    if (deplLogger.isLoggable(Level.FINE)) {
                        deplLogger.log(Level.FINE, "installed library : " + libraries[i]);
                    }
                    if (libraries[i].isDirectory()) {
                        deplLogger.log(Level.FINE, "Skipping installed library processing on " + libraries[i].getAbsolutePath() + "; it is a directory");
                        continue;
                    }
                    if (!libraries[i].getName().toLowerCase(Locale.getDefault()).endsWith(".jar")) {
                        deplLogger.log(Level.FINE, "Skipping installed library processing on " + libraries[i].getAbsolutePath() + "; it does not appear to be a JAR file based on its file type");
                        continue;
                    }
                    ZipFile jarFile = null;
                    try {
                        jarFile = new JarFile(libraries[i]);
                        Manifest manifest = ((JarFile)jarFile).getManifest();
                        if (processedLibraryNames != null) {
                            processedLibraryNames.add(libraries[i].toString());
                        }
                        if (processedLibraries != null) {
                            processedLibraries.add(libraries[i]);
                        }
                        if (manifest == null) continue;
                        String extName = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_NAME);
                        String specVersion = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
                        deplLogger.fine("Extension " + libraries[i].getAbsolutePath() + ", extNameOfOPtionalPkg..." + extName + ", specVersion..." + specVersion);
                        if (extName == null) continue;
                        if (specVersion == null) {
                            deplLogger.log(Level.WARNING, NULL_SPEC_VERS, new Object[]{extName, jarFile.getName()});
                            specVersion = "";
                        }
                        Extension extension = new Extension(extName);
                        extension.setSpecVersion(specVersion);
                        installedLibraries.put(extension, libraries[i].getName());
                        continue;
                    }
                    catch (Throwable thr) {
                        String msg = deplLogger.getResourceBundle().getString("enterprise.deployment.backend.optionalpkg.dependency.error");
                        if (deplLogger.isLoggable(Level.FINE)) {
                            deplLogger.log(Level.FINE, MessageFormat.format(msg, libraries[i].getAbsolutePath(), thr.getMessage()), thr);
                            continue;
                        }
                        LogRecord lr = new LogRecord(Level.INFO, SKIPPING_PROCESSING_INFO);
                        lr.setParameters(new Object[]{libraries[i].getAbsolutePath(), thr.getMessage()});
                        deplLogger.log(lr);
                        continue;
                    }
                    finally {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                deplLogger.log(Level.WARNING, "enterprise.deployment.backend.optionalpkg.dependency.exception", new Object[]{e.getMessage()});
            }
        }
        return installedLibraries;
    }

    static class Extension {
        private String extensionName;
        private String specVersion = "";
        private String specVendor = "";
        private String implVersion = "";
        private String implVendor = "";

        public Extension(String name) {
            this.extensionName = name;
        }

        public String getExtensionName() {
            return this.extensionName;
        }

        public void setExtensionName(String extensionName) {
            this.extensionName = extensionName;
        }

        public String getSpecVersion() {
            return this.specVersion;
        }

        public void setSpecVersion(String specVersion) {
            this.specVersion = specVersion;
        }

        public String getSpecVendor() {
            return this.specVendor;
        }

        public void setSpecVendor(String specVendor) {
            this.specVendor = specVendor;
        }

        public String getImplVersion() {
            return this.implVersion;
        }

        public void setImplVersion(String implVersion) {
            this.implVersion = implVersion;
        }

        public String getImplVendor() {
            return this.implVendor;
        }

        public void setImplVendor(String implVendor) {
            this.implVendor = implVendor;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof Extension) {
                Extension e = (Extension)o;
                return !(o != this && (!e.getExtensionName().equals(this.extensionName) || !e.getImplVendor().equals(this.implVendor) && !e.getImplVendor().equals("") || !e.getImplVersion().equals(this.implVersion) && !e.getImplVersion().equals("") || !e.getSpecVendor().equals(this.specVendor) && !e.getSpecVendor().equals("") || !e.getSpecVersion().equals(this.specVersion) && !e.getSpecVersion().equals("")));
            }
            return false;
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.extensionName.hashCode();
            return result;
        }
    }
}

