/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentContextImpl;

public class ClientArtifactsManager {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    private boolean isArtifactSetConsumed = false;
    private static final String CLIENT_ARTIFACTS_KEY = "ClientArtifacts";
    private final Map<URI, Artifacts.FullAndPartURIs> artifacts = new HashMap<URI, Artifacts.FullAndPartURIs>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientArtifactsManager get(DeploymentContext dc) {
        DeploymentContext deploymentContext = dc;
        synchronized (deploymentContext) {
            ClientArtifactsManager result = dc.getTransientAppMetaData(CLIENT_ARTIFACTS_KEY, ClientArtifactsManager.class);
            if (result == null) {
                result = new ClientArtifactsManager();
                dc.addTransientAppMetaData(CLIENT_ARTIFACTS_KEY, result);
            }
            return result;
        }
    }

    public void add(URI baseURI, URI artifactURI) {
        URIPair uris = new URIPair(baseURI, artifactURI);
        Artifacts.FullAndPartURIs newArtifact = new Artifacts.FullAndPartURIs(uris.absoluteURI, uris.relativeURI);
        this.add(newArtifact);
    }

    public void add(File baseFile, File artifactFile) {
        this.add(baseFile.toURI(), artifactFile.toURI());
    }

    public void add(File artifactFile, String relativePath, boolean isTemporary) {
        Artifacts.FullAndPartURIs artifact = new Artifacts.FullAndPartURIs(artifactFile.toURI(), relativePath, isTemporary);
        this.add(artifact);
    }

    public void add(Artifacts.FullAndPartURIs artifact) {
        if (this.isArtifactSetConsumed) {
            throw new IllegalStateException(this.formattedString("enterprise.deployment.backend.appClientArtifactOutOfOrder", artifact.getFull().toASCIIString()));
        }
        Artifacts.FullAndPartURIs existingArtifact = this.artifacts.get(artifact.getPart());
        if (existingArtifact != null) {
            throw new IllegalArgumentException(this.formattedString("enterprise.deployment.backend.appClientArtifactCollision", artifact.getPart().toASCIIString(), artifact.getFull().toASCIIString(), existingArtifact.getFull().toASCIIString()));
        }
        File f = new File(artifact.getFull());
        if (!f.exists() || !f.canRead()) {
            throw new IllegalArgumentException(this.formattedString("enterprise.deployment.backend.appClientArtifactMissing", artifact.getPart().toASCIIString(), artifact.getFull().toASCIIString()));
        }
        this.artifacts.put(artifact.getPart(), artifact);
    }

    public void addAll(File baseFile, Collection<File> artifactFiles) {
        for (File f : artifactFiles) {
            this.add(baseFile, f);
        }
    }

    public boolean contains(URI baseURI, URI artifactURI) {
        return this.artifacts.containsKey(artifactURI);
    }

    public boolean contains(File baseFile, File artifactFile) {
        return this.contains(baseFile.toURI(), artifactFile.toURI());
    }

    public Collection<Artifacts.FullAndPartURIs> artifacts() {
        this.isArtifactSetConsumed = true;
        return Collections.unmodifiableCollection(this.artifacts.values());
    }

    private String formattedString(String key, Object ... args) {
        String format = deplLogger.getResourceBundle().getString(key);
        return MessageFormat.format(format, args);
    }

    private static class URIPair {
        private final URI relativeURI;
        private final URI absoluteURI;

        private URIPair(URI baseURI, URI artifactURI) {
            if (artifactURI.isAbsolute()) {
                this.absoluteURI = artifactURI;
                this.relativeURI = baseURI.relativize(this.absoluteURI);
            } else {
                this.relativeURI = artifactURI;
                this.absoluteURI = baseURI.resolve(this.relativeURI);
            }
        }
    }
}

