/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class AnnotationScanner
implements ClassVisitor {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    private static final String SCANNING_EXCEPTION = "NCLS-DEPLOYMENT-00001";
    private static final String JAR_ENTRY_SCAN_ERROR = "NCLS-DEPLOYMENT-00002";
    private static final String FAILED_ANNOTATION_SCAN = "NCLS-DEPLOYMENT-00003";

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
    }

    @Override
    public void visitSource(String s, String s1) {
    }

    @Override
    public void visitOuterClass(String s, String s1, String s2) {
    }

    @Override
    public AnnotationVisitor visitAnnotation(String s, boolean b) {
        return null;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitInnerClass(String s, String s1, String s2, int i) {
    }

    @Override
    public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
        return null;
    }

    @Override
    public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
        return null;
    }

    @Override
    public void visitEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanArchive(ReadableArchive archive) {
        try {
            int crFlags = 7;
            Enumeration<String> entries = archive.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement();
                if (entryName.endsWith(".class")) {
                    InputStream is = archive.getEntry(entryName);
                    try {
                        ClassReader cr = new ClassReader(is);
                        cr.accept(this, crFlags);
                        continue;
                    }
                    catch (Exception e) {
                        LogRecord lr = new LogRecord(Level.WARNING, SCANNING_EXCEPTION);
                        Object[] args = new Object[]{entryName};
                        lr.setParameters(args);
                        lr.setThrown(e);
                        deplLogger.log(lr);
                        continue;
                    }
                    finally {
                        is.close();
                        continue;
                    }
                }
                if (!entryName.endsWith(".jar")) continue;
                try {
                    File archiveRoot = new File(archive.getURI());
                    File file = new File(archiveRoot, entryName);
                    JarFile jarFile = new JarFile(file);
                    try {
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry entry = jarEntries.nextElement();
                            String jarEntryName = entry.getName();
                            if (!jarEntryName.endsWith(".class")) continue;
                            InputStream is = jarFile.getInputStream(entry);
                            try {
                                ClassReader cr = new ClassReader(is);
                                cr.accept(this, crFlags);
                            }
                            catch (Exception e) {
                                deplLogger.log(Level.FINE, "Exception while scanning " + entryName, e);
                            }
                            finally {
                                is.close();
                            }
                        }
                    }
                    finally {
                        jarFile.close();
                    }
                }
                catch (IOException ioe) {
                    Object[] args = new Object[]{entryName, ioe.getMessage()};
                    deplLogger.log(Level.WARNING, JAR_ENTRY_SCAN_ERROR, args);
                }
            }
        }
        catch (Exception e) {
            deplLogger.log(Level.WARNING, FAILED_ANNOTATION_SCAN, e);
        }
    }
}

