/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommand;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-application-refs")
@I18n(value="list.application.refs")
@ExecuteOn(value={RuntimeType.DAS})
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.GET, path="list-application-refs", description="list-applications-refs")})
public class ListApplicationRefsCommand
implements AdminCommand,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListApplicationRefsCommand.class);
    @Param(primary=true, optional=true)
    String target = "server";
    @Param(optional=true, defaultValue="false", name="long", shortName="l")
    public Boolean long_opt = false;
    @Param(optional=true, defaultValue="false", shortName="t")
    public Boolean terse = false;
    @Inject
    Domain domain;
    private List<ApplicationRef> appRefs;

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        this.appRefs = this.domain.getApplicationRefsInTarget(this.target);
        for (ApplicationRef appRef : this.appRefs) {
            accessChecks.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy(appRef), "read"));
        }
        return accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport subReport = report.addSubActionsReport();
        ColumnFormatter cf = new ColumnFormatter();
        ActionReport.MessagePart part = report.getTopMessagePart();
        int numOfApplications = 0;
        if (!this.terse.booleanValue() && this.long_opt.booleanValue()) {
            String[] headings = new String[]{"NAME", "STATUS"};
            cf = new ColumnFormatter(headings);
        }
        for (ApplicationRef ref : this.appRefs) {
            Object[] row = new Object[]{ref.getRef()};
            if (!this.terse.booleanValue() && this.long_opt.booleanValue()) {
                row = new Object[]{ref.getRef(), this.getLongStatus(ref)};
            }
            cf.addRow(row);
            ++numOfApplications;
        }
        if (numOfApplications != 0) {
            report.setMessage(cf.toString());
        } else if (!this.terse.booleanValue()) {
            subReport.setMessage(localStrings.getLocalString(DeployCommand.class, "NoSuchAppDeployed", "No applications are deployed to this target {0}.", this.target));
            part.setMessage(localStrings.getLocalString("list.components.no.elements.to.list", "Nothing to List."));
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private String getLongStatus(ApplicationRef ref) {
        String message = "";
        if (DeploymentUtils.isDomainTarget(this.target)) {
            return message;
        }
        boolean isVersionEnabled = this.domain.isAppRefEnabledInTarget(ref.getRef(), this.target);
        message = isVersionEnabled ? localStrings.getLocalString("list.applications.verbose.enabled", "enabled") : localStrings.getLocalString("list.applications.verbose.disabled", "disabled");
        return message;
    }
}

