/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.StateCommandParameters;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.admin.InterceptorNotifier;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTargetResolver;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="enable")
@I18n(value="enable.command")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@PerLookup
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.POST, path="enable", description="enable", params={@RestParam(name="id", value="$parent")})})
public class EnableCommand
extends StateCommandParameters
implements AdminCommand,
DeploymentTargetResolver,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableCommand.class);
    static final String ENABLE_ACTION = "enable";
    @Inject
    Deployment deployment;
    @Inject
    ServiceLocator habitat;
    @Inject
    Domain domain;
    @Inject
    ServerEnvironment env;
    @Inject
    Applications applications;
    @Inject
    @Named(value="default-instance-name")
    protected Server server;
    @Inject
    VersioningService versioningService;
    @Inject
    ArchiveFactory archiveFactory;
    private ActionReport report;
    private Logger logger;
    private List<AccessRequired.AccessCheck> accessChecks;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        if (this.target == null) {
            this.target = this.deployment.getDefaultTarget(this.name(), OpsParams.Origin.load, this._classicstyle);
        }
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        this.accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        if (!DeploymentUtils.isDomainTarget(this.target)) {
            ApplicationRef applicationRef = this.domain.getApplicationRefInTarget(this.name(), this.target);
            if (applicationRef != null && !Boolean.getBoolean(applicationRef.getEnabled())) {
                this.accessChecks.add(new AccessRequired.AccessCheck((ConfigBeanProxy)applicationRef, ENABLE_ACTION, true));
            }
        } else {
            for (String t : this.domain.getAllReferencedTargetsForApplication(this.target)) {
                ApplicationRef applicationRef = this.domain.getApplicationRefInTarget(this.name(), t);
                if (applicationRef == null || Boolean.getBoolean(applicationRef.getEnabled())) continue;
                this.accessChecks.add(new AccessRequired.AccessCheck((ConfigBeanProxy)applicationRef, ENABLE_ACTION, true));
            }
        }
        String resourceForApp = DeploymentCommandUtils.getResourceNameForExistingApp(this.domain, this.name());
        if (resourceForApp != null) {
            this.accessChecks.add(new AccessRequired.AccessCheck(resourceForApp, ENABLE_ACTION));
        }
        return this.accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ApplicationRef applicationRef;
        this.deployment.validateSpecifiedTarget(this.target);
        if (!this.deployment.isRegistered(this.name())) {
            this.report.setMessage(localStrings.getLocalString("application.notreg", "Application {0} not registered", this.name()));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (!DeploymentUtils.isDomainTarget(this.target) && (applicationRef = this.domain.getApplicationRefInTarget(this.name(), this.target)) == null) {
            this.report.setMessage(localStrings.getLocalString("ref.not.referenced.target", "Application {0} is not referenced by target {1}", this.name(), this.target));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.domain.isAppEnabledInTarget(this.name(), this.target)) {
            this.logger.fine("The application is already enabled");
            return;
        }
        InterceptorNotifier notifier = new InterceptorNotifier(this.habitat, null);
        DeployCommandSupplementalInfo suppInfo = new DeployCommandSupplementalInfo();
        suppInfo.setDeploymentContext(notifier.dc());
        suppInfo.setAccessChecks(this.accessChecks);
        this.report.setResultType(DeployCommandSupplementalInfo.class, suppInfo);
        if (this.env.isDas()) {
            try {
                this.versioningService.handleDisable(this.name(), this.target, this.report, context.getSubject());
            }
            catch (VersioningSyntaxException e) {
                this.report.failure(this.logger, e.getMessage());
                return;
            }
            if (DeploymentUtils.isDomainTarget(this.target)) {
                List<String> targets = this.domain.getAllReferencedTargetsForApplication(this.name());
                try {
                    ParameterMapExtractor extractor = new ParameterMapExtractor(this);
                    ParameterMap paramMap = extractor.extract(Collections.EMPTY_LIST);
                    paramMap.set("DEFAULT", this.name());
                    notifier.ensureBeforeReported(ExtendedDeploymentContext.Phase.REPLICATION);
                    ClusterOperationUtil.replicateCommand(ENABLE_ACTION, FailurePolicy.Error, FailurePolicy.Warn, FailurePolicy.Ignore, targets, context, paramMap, this.habitat);
                }
                catch (Exception e) {
                    this.report.failure(this.logger, e.getMessage());
                    return;
                }
            }
            try {
                notifier.ensureBeforeReported(ExtendedDeploymentContext.Phase.REPLICATION);
                DeploymentCommandUtils.replicateEnableDisableToContainingCluster(ENABLE_ACTION, this.domain, this.target, this.name(), this.habitat, context, this);
            }
            catch (Exception e) {
                this.report.failure(this.logger, e.getMessage());
                return;
            }
        }
        try {
            Application app = this.applications.getApplication(this.name());
            ApplicationRef appRef = this.domain.getApplicationRefInServer(this.server.getName(), this.name());
            DeploymentContext dc = this.deployment.enable(this.target, app, appRef, this.report, this.logger);
            suppInfo.setDeploymentContext((ExtendedDeploymentContext)dc);
            if (!this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                try {
                    this.deployment.updateAppEnabledAttributeInDomainXML(this.name(), this.target, true);
                }
                catch (TransactionFailure e) {
                    this.logger.warning("failed to set enable attribute for " + this.name());
                }
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error during enabling: ", e);
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(e.getMessage());
        }
    }

    @Override
    public String getTarget(ParameterMap parameters) {
        return DeploymentCommandUtils.getTarget(parameters, OpsParams.Origin.load, this.deployment);
    }
}

