/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.admin.payload.PayloadImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.DeploymentCommandUtils;
import org.glassfish.deployment.common.ApplicationConfigInfo;
import org.glassfish.deployment.common.Artifacts;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningService;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.glassfish.internal.deployment.SnifferManager;
import org.glassfish.internal.deployment.Verifier;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;

@Service(name="deploy")
@I18n(value="deploy.command")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DOMAIN, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Applications.class, opType=RestEndpoint.OpType.POST, path="deploy"), @RestEndpoint(configBean=Cluster.class, opType=RestEndpoint.OpType.POST, path="deploy", params={@RestParam(name="target", value="$parent")}), @RestEndpoint(configBean=Server.class, opType=RestEndpoint.OpType.POST, path="deploy", params={@RestParam(name="target", value="$parent")})})
public class DeployCommand
extends DeployCommandParameters
implements AdminCommand,
EventListener,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeployCommand.class);
    @Inject
    Applications apps;
    @Inject
    ServerEnvironment env;
    @Inject
    ServiceLocator habitat;
    @Inject
    CommandRunner commandRunner;
    @Inject
    Deployment deployment;
    @Inject
    SnifferManager snifferManager;
    @Inject
    ArchiveFactory archiveFactory;
    @Inject
    Domain domain;
    @Inject
    Events events;
    @Inject
    VersioningService versioningService;
    private File safeCopyOfApp = null;
    private File safeCopyOfDeploymentPlan = null;
    private File safeCopyOfAltDD = null;
    private File safeCopyOfRuntimeAltDD = null;
    private File originalPathValue;
    private List<String> previousTargets = new ArrayList<String>();
    private Properties previousVirtualServers = new Properties();
    private Properties previousEnabledAttributes = new Properties();
    private Logger logger;
    private ExtendedDeploymentContext initialContext;
    private ExtendedDeploymentContext deploymentContext;
    private ArchiveHandler archiveHandler;
    private DeploymentTracing tracing;
    private File expansionDir;
    private ReadableArchive archive;
    private ActionReport report;
    private DeploymentTracing timing;
    private DeployCommandSupplementalInfo suppInfo;

    public DeployCommand() {
        this.origin = OpsParams.Origin.deploy;
    }

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.events.register(this);
        this.suppInfo = new DeployCommandSupplementalInfo();
        context.getActionReport().setResultType(DeployCommandSupplementalInfo.class, this.suppInfo);
        this.timing = new DeploymentTracing();
        this.tracing = null;
        if (System.getProperty("org.glassfish.deployment.trace") != null) {
            this.tracing = new DeploymentTracing();
        }
        this.report = context.getActionReport();
        this.logger = context.getLogger();
        this.originalPathValue = this.path;
        if (!this.path.exists()) {
            this.report.setMessage(localStrings.getLocalString("fnf", "File not found", this.path.getAbsolutePath()));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (!this.path.canRead()) {
            this.report.setMessage(localStrings.getLocalString("fnr", "File {0} does not have read permission", this.path.getAbsolutePath()));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return false;
        }
        if (this.snifferManager.hasNoSniffers()) {
            String msg = localStrings.getLocalString("nocontainer", "No container services registered, done...");
            this.report.failure(this.logger, msg);
            return false;
        }
        try {
            this.archive = this.archiveFactory.openArchive(this.path, this);
            if (this.tracing != null) {
                this.tracing.addMark(DeploymentTracing.Mark.ARCHIVE_OPENED);
            }
        }
        catch (IOException e) {
            String msg = localStrings.getLocalString("deploy.errOpeningArtifact", "deploy.errOpeningArtifact", this.path.getAbsolutePath());
            if (this.logReportedErrors.booleanValue()) {
                this.report.failure(this.logger, msg, e);
            } else {
                this.report.setMessage(msg + this.path.getAbsolutePath() + e.toString());
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            }
            return false;
        }
        if (this.altdd != null) {
            this.archive.addArchiveMetaData("altdd", this.altdd);
        }
        if (this.runtimealtdd != null) {
            this.archive.addArchiveMetaData("runtimealtdd", this.runtimealtdd);
        }
        this.expansionDir = null;
        this.deploymentContext = null;
        try {
            boolean isRegistered;
            String versionIdentifier;
            this.deployment.validateSpecifiedTarget(this.target);
            this.archiveHandler = this.deployment.getArchiveHandler(this.archive, this.type);
            if (this.tracing != null) {
                this.tracing.addMark(DeploymentTracing.Mark.ARCHIVE_HANDLER_OBTAINED);
            }
            if (this.archiveHandler == null) {
                this.report.failure(this.logger, localStrings.getLocalString("deploy.unknownarchivetype", "Archive type of {0} was not recognized", this.path));
                return false;
            }
            this.initialContext = new DeploymentContextImpl(this.report, this.archive, this, this.env);
            this.initialContext.setArchiveHandler(this.archiveHandler);
            if (this.tracing != null) {
                this.initialContext.addModuleMetaData(this.tracing);
                this.tracing.addMark(DeploymentTracing.Mark.INITIAL_CONTEXT_CREATED);
            }
            this.events.send(new EventListener.Event<ExtendedDeploymentContext>(Deployment.INITIAL_CONTEXT_CREATED, this.initialContext), false);
            if (this.name == null) {
                this.name = this.archiveHandler.getDefaultApplicationName(this.initialContext.getSource(), this.initialContext);
            } else {
                DeploymentUtils.validateApplicationName(this.name);
            }
            if (this.tracing != null) {
                this.tracing.addMark(DeploymentTracing.Mark.APPNAME_DETERMINED);
            }
            boolean isUntagged = VersioningUtils.isUntagged(this.name);
            if (this.name != null && !isUntagged && this.type != null && this.type.equals("osgi")) {
                ActionReport.MessagePart msgPart = context.getActionReport().getTopMessagePart();
                msgPart.setChildrenType("WARNING");
                ActionReport.MessagePart childPart = msgPart.addChild();
                childPart.setMessage(VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.osgi.warning", "OSGi bundles will not use the GlassFish versioning, any version information embedded as part of the name option will be ignored"));
                this.name = VersioningUtils.getUntaggedName(this.name);
            }
            if (isUntagged && (versionIdentifier = this.archiveHandler.getVersionIdentifier(this.initialContext.getSource())) != null && !versionIdentifier.isEmpty()) {
                StringBuilder sb = new StringBuilder(this.name).append(":").append(versionIdentifier);
                this.name = sb.toString();
            }
            if (this.target == null) {
                this.target = this.deployment.getDefaultTarget(this.name, this.origin, this._classicstyle);
            }
            this.isredeploy = (isRegistered = this.deployment.isRegistered(this.name)) && this.force != false;
            return true;
        }
        catch (Exception ex) {
            this.events.unregister(this);
            if (this.initialContext.getSource() != null) {
                try {
                    this.initialContext.getSource().close();
                }
                catch (IOException ioex) {
                    throw new RuntimeException(ioex);
                }
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getResourceNameForApps(this.domain), "create"));
        accessChecks.add(new AccessRequired.AccessCheck(DeploymentCommandUtils.getTargetResourceNameForNewAppRef(this.domain, this.target), "create"));
        if (this.isredeploy.booleanValue()) {
            String appResource = DeploymentCommandUtils.getResourceNameForNewApp(this.domain, this.name);
            accessChecks.add(new AccessRequired.AccessCheck(appResource, "delete"));
            String appRefResource = DeploymentCommandUtils.getTargetResourceNameForNewAppRef(this.domain, this.target, this.name);
            accessChecks.add(new AccessRequired.AccessCheck(appRefResource, "delete"));
        }
        return accessChecks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(AdminCommandContext context) {
        try {
            interceptors = this.habitat.getAllServices(Interceptor.class, new Annotation[0]);
            if (interceptors != null) {
                for (Interceptor interceptor : interceptors) {
                    interceptor.intercept(this, this.initialContext);
                }
            }
            this.deployment.validateDeploymentTarget(this.target, this.name, this.isredeploy);
            if (this.tracing != null) {
                this.tracing.addMark(DeploymentTracing.Mark.TARGET_VALIDATED);
            }
            part = this.report.getTopMessagePart();
            part.addProperty("name", this.name);
            savedAppConfig = new ApplicationConfigInfo(this.apps.getModule(Application.class, this.name));
            undeployProps = this.handleRedeploy(this.name, this.report, context);
            if (this.enabled == null) {
                this.enabled = Boolean.TRUE;
            }
            if (this.keepreposdir.booleanValue() || !(reposDir = new File(this.env.getApplicationRepositoryPath(), VersioningUtils.getRepositoryName(this.name))).exists()) ** GOTO lbl105
            i = 0;
lbl18:
            // 2 sources

            while (i < this.domain.getApplications().getApplications().size()) {
                existrepos = new File(new URI(this.domain.getApplications().getApplications().get(i).getLocation()));
                appname = this.domain.getApplications().getApplications().get(i).getName();
                if (appname.equals(this.name) || !existrepos.getAbsoluteFile().equals(reposDir.getAbsoluteFile())) ** GOTO lbl-1000
                this.report.failure(this.logger, DeployCommand.localStrings.getLocalString("deploy.dupdeployment", "Application {0} is trying to use the same repository directory as application {1}, please choose a different application name to deploy", new Object[]{this.name, appname}));
                this.events.unregister(this);
                ** GOTO lbl68
            }
            ** GOTO lbl102
        }
        catch (Throwable e) {
            try {
                this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                this.report.setMessage(e.getMessage());
                this.report.setFailureCause(e);
                this.events.unregister(this);
            }
            catch (Throwable var18_42) {
                this.events.unregister(this);
                try {
                    this.archive.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                }
                if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                    this.report.setResultType(String.class, this.name);
                    this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                    this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, this.timing.elapsed()}));
                } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                    errorMessage = this.report.getMessage();
                    cause = this.report.getFailureCause();
                    if (cause != null) {
                        causeMessage = cause.getMessage();
                        if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                            errorMessage = errorMessage + " : " + cause.getMessage();
                        }
                        this.logger.log(Level.SEVERE, errorMessage, cause.getCause());
                    }
                    this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                    this.report.setFailureCause(null);
                    if (this.expansionDir != null) {
                        try {
                            arch = DeploymentUtils.openAsFileArchive(this.expansionDir, this.archiveFactory);
                            arch.delete();
                        }
                        catch (IOException ex) {
                            msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                            this.report.failure(this.logger, msg, ex);
                        }
                    }
                }
                if (this.deploymentContext == null) throw var18_42;
                this.deploymentContext.postDeployClean(true);
                throw var18_42;
            }
lbl68:
            // 1 sources

            try {
                this.archive.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
            }
            if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.report.setResultType(String.class, this.name);
                this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, this.timing.elapsed()}));
            } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                errorMessage = this.report.getMessage();
                cause = this.report.getFailureCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                        errorMessage = errorMessage + " : " + cause.getMessage();
                    }
                    this.logger.log(Level.SEVERE, errorMessage, cause.getCause());
                }
                this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                this.report.setFailureCause(null);
                if (this.expansionDir != null) {
                    try {
                        arch = DeploymentUtils.openAsFileArchive(this.expansionDir, this.archiveFactory);
                        arch.delete();
                    }
                    catch (IOException ex) {
                        msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                        this.report.failure(this.logger, msg, ex);
                    }
                }
            }
            if (this.deploymentContext == null) return;
            this.deploymentContext.postDeployClean(true);
            return;
lbl-1000:
            // 1 sources

            {
                ++i;
                ** GOTO lbl18
lbl102:
                // 1 sources

                arch = DeploymentUtils.openAsFileArchive(reposDir, this.archiveFactory);
                arch.delete();
lbl105:
                // 2 sources

                if (DeploymentUtils.isDomainTarget(this.target) || !this.enabled.booleanValue()) ** GOTO lbl-1000
                try {
                    this.versioningService.handleDisable(this.name, this.target, this.report, context.getSubject());
                }
                catch (VersioningSyntaxException e) {
                    this.report.failure(this.logger, e.getMessage());
                    this.events.unregister(this);
                    try {
                        this.archive.close();
                    }
                    catch (IOException e) {
                        this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
                    }
                    if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                        this.report.setResultType(String.class, this.name);
                        this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                        this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, this.timing.elapsed()}));
                    } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                        errorMessage = this.report.getMessage();
                        cause = this.report.getFailureCause();
                        if (cause != null) {
                            causeMessage = cause.getMessage();
                            if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                                errorMessage = errorMessage + " : " + cause.getMessage();
                            }
                            this.logger.log(Level.SEVERE, errorMessage, cause.getCause());
                        }
                        this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                        this.report.setFailureCause(null);
                        if (this.expansionDir != null) {
                            try {
                                arch = DeploymentUtils.openAsFileArchive(this.expansionDir, this.archiveFactory);
                                arch.delete();
                            }
                            catch (IOException ex) {
                                msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                                this.report.failure(this.logger, msg, ex);
                            }
                        }
                    }
                    if (this.deploymentContext == null) return;
                    this.deploymentContext.postDeployClean(true);
                    return;
                }
            }
lbl-1000:
            // 2 sources

            {
                block89: {
                    source = new File(this.archive.getURI().getSchemeSpecificPart());
                    isDirectoryDeployed = true;
                    if (source.isDirectory()) break block89;
                    isDirectoryDeployed = false;
                    this.path = this.expansionDir = new File(this.domain.getApplicationRoot(), VersioningUtils.getRepositoryName(this.name));
                    ** GOTO lbl-1000
                }
                versionFromSameDir = this.versioningService.getVersionFromSameDir(source);
                if (this.force.booleanValue() || versionFromSameDir == null) ** GOTO lbl-1000
                this.report.failure(this.logger, VersioningUtils.LOCALSTRINGS.getLocalString("versioning.deployment.dual.inplace", "GlassFish do not support versioning for directory deployment when using the same directory. The directory {0} is already assigned to the version {1}.", new Object[]{source.getPath(), versionFromSameDir}));
                this.events.unregister(this);
            }
            try {
                this.archive.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
            }
            if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.report.setResultType(String.class, this.name);
                this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, this.timing.elapsed()}));
            } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                errorMessage = this.report.getMessage();
                cause = this.report.getFailureCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                        errorMessage = errorMessage + " : " + cause.getMessage();
                    }
                    this.logger.log(Level.SEVERE, errorMessage, cause.getCause());
                }
                this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                this.report.setFailureCause(null);
                if (this.expansionDir != null) {
                    try {
                        arch = DeploymentUtils.openAsFileArchive(this.expansionDir, this.archiveFactory);
                        arch.delete();
                    }
                    catch (IOException ex) {
                        msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                        this.report.failure(this.logger, msg, ex);
                    }
                }
            }
            if (this.deploymentContext == null) return;
            this.deploymentContext.postDeployClean(true);
            return;
lbl-1000:
            // 2 sources

            {
                this.deploymentContext = this.deployment.getBuilder(this.logger, this, this.report).source(this.initialContext.getSource()).archiveHandler(this.archiveHandler).build(this.initialContext);
                if (this.tracing != null) {
                    this.tracing.addMark(DeploymentTracing.Mark.CONTEXT_CREATED);
                    this.deploymentContext.addModuleMetaData(this.tracing);
                }
                if (undeployProps != null) {
                    this.deploymentContext.getAppProps().putAll((Map<?, ?>)undeployProps);
                }
                if (this.properties != null || this.property != null) {
                    if (this.properties == null) {
                        this.properties = new Properties();
                    }
                    if (this.property != null) {
                        this.properties.putAll((Map<?, ?>)this.property);
                    }
                }
                if (this.properties != null) {
                    this.deploymentContext.getAppProps().putAll((Map<?, ?>)this.properties);
                    this.validateDeploymentProperties(this.properties, this.deploymentContext);
                }
                this.deploymentContext.clean();
                appProps = this.deploymentContext.getAppProps();
                appLocation = DeploymentUtils.relativizeWithinDomainIfPossible(this.deploymentContext.getSource().getURI());
                appProps.setProperty("location", appLocation);
                appProps.setProperty("object-type", "user");
                if (this.contextroot != null) {
                    appProps.setProperty("context-root", this.contextroot);
                }
                appProps.setProperty("directory-deployed", String.valueOf(isDirectoryDeployed));
                if (this.type == null) {
                    this.type = this.archiveHandler.getArchiveType();
                }
                appProps.setProperty("archiveType", this.type);
                savedAppConfig.store(appProps);
                this.deploymentContext.addTransientAppMetaData("previousTargets", this.previousTargets);
                this.deploymentContext.addTransientAppMetaData("previousVirtualServers", this.previousVirtualServers);
                this.deploymentContext.addTransientAppMetaData("previousEnabledAttributes", this.previousEnabledAttributes);
                t = this.deployment.prepareAppConfigChanges(this.deploymentContext);
                if (this.tracing != null) {
                    this.tracing.addMark(DeploymentTracing.Mark.DEPLOY);
                }
                appInfo = this.deployment.deploy(this.deploymentContext);
                downloadableArtifacts = DeploymentUtils.downloadableArtifacts(this.deploymentContext);
                generatedArtifacts = DeploymentUtils.generatedArtifacts(this.deploymentContext);
                if (this.report.getActionExitCode() == ActionReport.ExitCode.SUCCESS) {
                    try {
                        this.moveAppFilesToPermanentLocation(this.deploymentContext, this.logger);
                        this.recordFileLocations(appProps);
                        downloadableArtifacts.record(appProps);
                        generatedArtifacts.record(appProps);
                        this.deployment.registerAppInDomainXML(appInfo, this.deploymentContext, t);
                        if (this.tracing != null) {
                            this.tracing.addMark(DeploymentTracing.Mark.REGISTRATION);
                        }
                        if (this.retrieve != null) {
                            DeployCommand.retrieveArtifacts(context, downloadableArtifacts.getArtifacts(), this.retrieve, false, this.name);
                        }
                        this.suppInfo.setDeploymentContext(this.deploymentContext);
                        worstExitCode = ActionReport.ExitCode.SUCCESS;
                        for (ActionReport var16_40 : this.report.getSubActionsReport()) {
                            actionExitCode = var16_40.getActionExitCode();
                            if (!actionExitCode.isWorse(worstExitCode)) continue;
                            worstExitCode = actionExitCode;
                        }
                        this.report.setActionExitCode(worstExitCode);
                        this.report.setResultType(String.class, this.name);
                    }
                    catch (Exception e) {
                        this.deployment.undeploy(this.name, this.deploymentContext);
                        this.deploymentContext.clean();
                        throw e;
                    }
                }
                this.events.unregister(this);
            }
            try {
                this.archive.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
            }
            if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.report.setResultType(String.class, this.name);
                this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, this.timing.elapsed()}));
            } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                errorMessage = this.report.getMessage();
                cause = this.report.getFailureCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                        errorMessage = errorMessage + " : " + cause.getMessage();
                    }
                    this.logger.log(Level.SEVERE, errorMessage, cause.getCause());
                }
                this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                this.report.setFailureCause(null);
                if (this.expansionDir != null) {
                    try {
                        arch = DeploymentUtils.openAsFileArchive(this.expansionDir, this.archiveFactory);
                        arch.delete();
                    }
                    catch (IOException ex) {
                        msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                        this.report.failure(this.logger, msg, ex);
                    }
                }
            }
            if (this.deploymentContext == null) return;
            this.deploymentContext.postDeployClean(true);
            return;
            try {
                this.archive.close();
            }
            catch (IOException e) {
                this.logger.log(Level.FINE, DeployCommand.localStrings.getLocalString("errClosingArtifact", "Error while closing deployable artifact : ", new Object[]{this.path.getAbsolutePath()}), e);
            }
            if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.SUCCESS)) {
                this.report.setResultType(String.class, this.name);
                this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.command.success", "Application deployed with name {0}", new Object[]{this.name}));
                this.logger.info(DeployCommand.localStrings.getLocalString("deploy.done", "Deployment of {0} done is {1} ms", new Object[]{this.name, this.timing.elapsed()}));
            } else if (this.report.getActionExitCode().equals((Object)ActionReport.ExitCode.FAILURE)) {
                errorMessage = this.report.getMessage();
                cause = this.report.getFailureCause();
                if (cause != null) {
                    causeMessage = cause.getMessage();
                    if (causeMessage != null && !causeMessage.equals(errorMessage)) {
                        errorMessage = errorMessage + " : " + cause.getMessage();
                    }
                    this.logger.log(Level.SEVERE, errorMessage, cause.getCause());
                }
                this.report.setMessage(DeployCommand.localStrings.getLocalString("deploy.errDuringDepl", "Error occur during deployment: {0}.", new Object[]{errorMessage}));
                this.report.setFailureCause(null);
                if (this.expansionDir != null) {
                    try {
                        arch = DeploymentUtils.openAsFileArchive(this.expansionDir, this.archiveFactory);
                        arch.delete();
                    }
                    catch (IOException ex) {
                        msg = DeployCommand.localStrings.getLocalString("deploy.errDelRepos", "Error deleting repository directory {0}", new Object[]{this.expansionDir.getAbsolutePath()});
                        this.report.failure(this.logger, msg, ex);
                    }
                }
            }
            if (this.deploymentContext == null) return;
            this.deploymentContext.postDeployClean(true);
            return;
        }
    }

    private void moveAppFilesToPermanentLocation(ExtendedDeploymentContext deploymentContext, Logger logger2) throws IOException {
        File finalUploadDir = deploymentContext.getAppInternalDir();
        File finalAltDDDir = deploymentContext.getAppAltDDDir();
        if (!finalUploadDir.mkdirs()) {
            logger2.log(Level.FINE, " Attempting to create upload directory {0} was reported as failed; attempting to continue", new Object[]{finalUploadDir.getAbsolutePath()});
        }
        this.safeCopyOfApp = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.originalPathValue, logger2, this.env);
        this.safeCopyOfDeploymentPlan = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalUploadDir, this.deploymentplan, logger2, this.env);
        this.safeCopyOfAltDD = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalAltDDDir, this.altdd, logger2, this.env);
        this.safeCopyOfRuntimeAltDD = DeploymentCommandUtils.renameUploadedFileOrCopyInPlaceFile(finalAltDDDir, this.runtimealtdd, logger2, this.env);
    }

    private void recordFileLocations(Properties appProps) throws URISyntaxException {
        if (this.safeCopyOfApp != null) {
            appProps.setProperty("appLocation", DeploymentUtils.relativizeWithinDomainIfPossible(this.safeCopyOfApp.toURI()));
        }
        if (this.safeCopyOfDeploymentPlan != null) {
            appProps.setProperty("deploymentPlanLocation", DeploymentUtils.relativizeWithinDomainIfPossible(this.safeCopyOfDeploymentPlan.toURI()));
        }
        if (this.safeCopyOfAltDD != null) {
            appProps.setProperty("altDDLocation", DeploymentUtils.relativizeWithinDomainIfPossible(this.safeCopyOfAltDD.toURI()));
        }
        if (this.safeCopyOfRuntimeAltDD != null) {
            appProps.setProperty("runtimeAltDDLocation", DeploymentUtils.relativizeWithinDomainIfPossible(this.safeCopyOfRuntimeAltDD.toURI()));
        }
    }

    private Properties handleRedeploy(String name, ActionReport report, AdminCommandContext context) throws Exception {
        if (this.isredeploy.booleanValue()) {
            Application app = this.apps.getModule(Application.class, name);
            if (app.isLifecycleModule()) {
                throw new IllegalArgumentException(localStrings.getLocalString("lifecyclemodule_withsamename_exists", "Lifecycle module with same name {0} already exists, please pick a different name for the application. ", name));
            }
            this.settingsFromDomainXML(app);
            ParameterMap parameters = new ParameterMap();
            parameters.add("DEFAULT", name);
            parameters.add("target", this.target);
            parameters.add("keepreposdir", this.keepreposdir.toString());
            parameters.add("isredeploy", this.isredeploy.toString());
            if (this.dropandcreatetables != null) {
                parameters.add("droptables", this.dropandcreatetables.toString());
            }
            parameters.add("_ignoreCascade", this.force.toString());
            if (this.keepstate != null) {
                parameters.add("keepstate", this.keepstate.toString());
            }
            ActionReport subReport = report.addSubActionsReport();
            subReport.setExtraProperties(new Properties());
            ArrayList<String> propertyNames = new ArrayList<String>();
            propertyNames.add("keepSessions");
            propertyNames.add("preserveAppScopedResources");
            this.populatePropertiesToParameterMap(parameters, propertyNames);
            CommandRunner.CommandInvocation inv = this.commandRunner.getCommandInvocation("undeploy", subReport, context.getSubject());
            inv.parameters(parameters).execute();
            return subReport.getExtraProperties();
        }
        return null;
    }

    private void populatePropertiesToParameterMap(ParameterMap parameters, List<String> propertyNamesList) {
        Properties props = new Properties();
        if (this.properties != null) {
            for (String propertyName : propertyNamesList) {
                if (!this.properties.containsKey(propertyName)) continue;
                props.put(propertyName, this.properties.getProperty(propertyName));
            }
        }
        parameters.add("properties", DeploymentUtils.propertiesValue(props, ':'));
    }

    public static void retrieveArtifacts(AdminCommandContext context, Application app, String targetLocalDir) {
        DeployCommand.retrieveArtifacts(context, app, targetLocalDir, true);
    }

    public static void retrieveArtifacts(AdminCommandContext context, Application app, String targetLocalDir, boolean reportErrorsInTopReport) {
        DeployCommand.retrieveArtifacts(context, DeploymentUtils.downloadableArtifacts(app).getArtifacts(), targetLocalDir, reportErrorsInTopReport, app.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void retrieveArtifacts(AdminCommandContext context, Collection<Artifacts.FullAndPartURIs> artifactInfo, String targetLocalDir, boolean reportErrorsInTopReport, String appname) {
        if (artifactInfo.isEmpty()) {
            ActionReport report = context.getActionReport();
            ActionReport subReport = report.addSubActionsReport();
            subReport.setMessage(localStrings.getLocalString(DeployCommand.class, "get-client-stubs.noStubApp", "There are no files to retrieve for application {0}", appname));
            subReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            return;
        }
        Logger logger2 = context.getLogger();
        FileOutputStream targetStream = null;
        try {
            Payload.Outbound outboundPayload = context.getOutboundPayload();
            boolean retrieveArtifacts = false;
            if (outboundPayload == null) {
                outboundPayload = PayloadImpl.Outbound.newInstance();
                retrieveArtifacts = true;
            }
            Properties props = new Properties();
            props.setProperty("file-xfer-root", targetLocalDir.replace('\\', '/'));
            for (Artifacts.FullAndPartURIs uriPair : artifactInfo) {
                if (logger2.isLoggable(Level.FINE)) {
                    logger2.log(Level.FINE, "About to download artifact {0}", uriPair.getFull());
                }
                outboundPayload.attachFile("application/octet-stream", uriPair.getPart(), "files", props, new File(uriPair.getFull().getSchemeSpecificPart()));
            }
            if (retrieveArtifacts) {
                String msg;
                File targetLocalFile = new File(targetLocalDir);
                if (targetLocalFile.exists()) {
                    msg = localStrings.getLocalString("download.errFileExists", "Unable to generate files. File [{0}] already exists.", targetLocalFile.getAbsolutePath());
                    throw new Exception(msg);
                }
                if (!targetLocalFile.getParentFile().exists()) {
                    msg = localStrings.getLocalString("download.errParentFileMissing", "Unable to generate files. Directory [{0}] does not exist.", targetLocalFile.getParent());
                    throw new Exception(msg);
                }
                targetStream = new FileOutputStream(targetLocalFile);
                outboundPayload.writeTo(targetStream);
                targetStream.flush();
            }
        }
        catch (Exception e) {
            DeployCommand.handleRetrieveException(e, context, reportErrorsInTopReport);
        }
        finally {
            if (targetStream != null) {
                try {
                    targetStream.close();
                }
                catch (IOException ex) {
                    DeployCommand.handleRetrieveException(ex, context, reportErrorsInTopReport);
                }
            }
        }
    }

    private static void handleRetrieveException(Exception e, AdminCommandContext context, boolean reportErrorsInTopReport) {
        String errorMsg = localStrings.getLocalString("download.errDownloading", "Error while downloading generated files");
        Logger logger2 = context.getLogger();
        logger2.log(Level.SEVERE, errorMsg, e);
        ActionReport report = context.getActionReport();
        if (!reportErrorsInTopReport) {
            report = report.addSubActionsReport();
            report.setActionExitCode(ActionReport.ExitCode.WARNING);
        } else {
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        report.setMessage(errorMsg);
        report.setFailureCause(e);
    }

    private void settingsFromDomainXML(Application app) {
        if (this.name != null) {
            String compatProp;
            if (this.contextroot == null && app.getContextRoot() != null) {
                this.previousContextRoot = app.getContextRoot();
            }
            if (this.libraries == null) {
                this.libraries = app.getLibraries();
            }
            this.previousTargets = this.domain.getAllReferencedTargetsForApplication(this.name);
            if (this.virtualservers == null) {
                if (DeploymentUtils.isDomainTarget(this.target)) {
                    for (String tgt : this.previousTargets) {
                        String vs = this.domain.getVirtualServersForApplication(tgt, this.name);
                        if (vs == null) continue;
                        this.previousVirtualServers.put(tgt, vs);
                    }
                } else {
                    this.virtualservers = this.domain.getVirtualServersForApplication(this.target, this.name);
                }
            }
            if (this.enabled == null) {
                if (DeploymentUtils.isDomainTarget(this.target)) {
                    for (String tgt : this.previousTargets) {
                        this.previousEnabledAttributes.put(tgt, this.domain.getEnabledForApplication(tgt, this.name));
                    }
                    this.previousEnabledAttributes.put("domain", app.getEnabled());
                    this.enabled = this.deployment.isAppEnabled(app);
                } else {
                    this.enabled = Boolean.valueOf(this.domain.getEnabledForApplication(this.target, this.name));
                }
            }
            if ((compatProp = app.getDeployProperties().getProperty("compatibility")) != null) {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                if (this.properties.getProperty("compatibility") == null) {
                    this.properties.setProperty("compatibility", compatProp);
                }
            }
        }
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(Deployment.DEPLOYMENT_BEFORE_CLASSLOADER_CREATION)) {
            DeploymentContext context = (DeploymentContext)event.hook();
            if (this.verify.booleanValue()) {
                Verifier verifier = this.habitat.getService(Verifier.class, new Annotation[0]);
                if (verifier != null) {
                    verifier.verify(context);
                } else {
                    context.getLogger().warning("Verifier is not installed yet. Install verifier module.");
                }
            }
        }
    }

    private void validateDeploymentProperties(Properties properties, DeploymentContext context) {
        String compatProp = properties.getProperty("compatibility");
        if (compatProp != null && !compatProp.equals("v2")) {
            String warningMsg = localStrings.getLocalString("compat.value.not.supported", "{0} is not a supported value for compatibility property.", compatProp);
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            subReport.setActionExitCode(ActionReport.ExitCode.WARNING);
            subReport.setMessage(warningMsg);
            context.getLogger().log(Level.WARNING, warningMsg);
        }
    }

    @Contract
    public static interface Interceptor {
        public void intercept(DeployCommand var1, DeploymentContext var2);
    }
}

