/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.hk2;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;
import org.glassfish.cdi.hk2.CDIHK2Descriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.Injectee;
import org.glassfish.hk2.api.JustInTimeInjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

@Singleton
public class CDISecondChanceResolver
implements JustInTimeInjectionResolver {
    private final ServiceLocator locator;
    private final BeanManager manager;

    CDISecondChanceResolver(ServiceLocator locator, BeanManager manager) {
        this.locator = locator;
        this.manager = manager;
    }

    @Override
    public boolean justInTimeResolution(Injectee failedInjectionPoint) {
        Set<Annotation> setQualifiers = failedInjectionPoint.getRequiredQualifiers();
        Annotation[] qualifiers = setQualifiers.toArray(new Annotation[setQualifiers.size()]);
        Set<Bean<?>> beans = this.manager.getBeans(failedInjectionPoint.getRequiredType(), qualifiers);
        if (beans == null || beans.isEmpty()) {
            return false;
        }
        DynamicConfiguration config = ServiceLocatorUtilities.createDynamicConfiguration(this.locator);
        for (Bean<?> bean : beans) {
            CDIHK2Descriptor descriptor = new CDIHK2Descriptor(this.manager, bean);
            config.addActiveDescriptor(descriptor);
        }
        config.commit();
        return true;
    }
}

