/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.invocation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.glassfish.hk2.api.IterableProvider;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class InvocationManagerImpl
implements InvocationManager {
    private InheritableThreadLocal<InvocationArray<ComponentInvocation>> frames;
    private final ThreadLocal<Stack<ApplicationEnvironment>> applicationEnvironments = new ThreadLocal<Stack<ApplicationEnvironment>>(){

        @Override
        protected Stack<ApplicationEnvironment> initialValue() {
            return new Stack<ApplicationEnvironment>();
        }
    };
    private Map<ComponentInvocation.ComponentInvocationType, List<RegisteredComponentInvocationHandler>> regCompInvHandlerMap = new HashMap<ComponentInvocation.ComponentInvocationType, List<RegisteredComponentInvocationHandler>>();
    private final ComponentInvocationHandler[] invHandlers;

    public InvocationManagerImpl() {
        this(null);
    }

    @Inject
    private InvocationManagerImpl(@Optional IterableProvider<ComponentInvocationHandler> handlers) {
        if (handlers == null) {
            this.invHandlers = null;
        } else {
            LinkedList<ComponentInvocationHandler> localHandlers = new LinkedList<ComponentInvocationHandler>();
            for (ComponentInvocationHandler handler : handlers) {
                localHandlers.add(handler);
            }
            this.invHandlers = localHandlers.size() > 0 ? localHandlers.toArray(new ComponentInvocationHandler[localHandlers.size()]) : null;
        }
        this.frames = new InheritableThreadLocal<InvocationArray<ComponentInvocation>>(){

            @Override
            protected InvocationArray initialValue() {
                return new InvocationArray();
            }

            @Override
            protected InvocationArray<ComponentInvocation> childValue(InvocationArray<ComponentInvocation> parentValue) {
                InvocationArray<ComponentInvocation> result = new InvocationArray<ComponentInvocation>();
                InvocationArray<ComponentInvocation> v = parentValue;
                if (v.size() > 0 && v.outsideStartup()) {
                    ComponentInvocation parentInv = (ComponentInvocation)v.get(v.size() - 1);
                    if (parentInv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVLET_INVOCATION) {
                        ComponentInvocation inv = new ComponentInvocation();
                        inv.componentId = parentInv.getComponentId();
                        inv.setComponentInvocationType(parentInv.getInvocationType());
                        inv.instance = null;
                        inv.container = parentInv.getContainerContext();
                        inv.transaction = null;
                        result.add(inv);
                    } else if (parentInv.getInvocationType() != ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                        ComponentInvocation cpy = new ComponentInvocation();
                        cpy.componentId = parentInv.getComponentId();
                        cpy.setComponentInvocationType(parentInv.getInvocationType());
                        cpy.instance = parentInv.getInstance();
                        cpy.container = parentInv.getContainerContext();
                        cpy.transaction = parentInv.getTransaction();
                        result.add(cpy);
                    }
                }
                return result;
            }
        };
    }

    @Override
    public <T extends ComponentInvocation> void preInvoke(T inv) throws InvocationException {
        List<RegisteredComponentInvocationHandler> setCIH;
        InvocationArray v = (InvocationArray)this.frames.get();
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            v.setInvocationAttribute(ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP);
            return;
        }
        int beforeSize = v.size();
        ComponentInvocation prevInv = beforeSize > 0 ? (ComponentInvocation)v.get(beforeSize - 1) : null;
        ComponentInvocation.ComponentInvocationType invType = inv.getInvocationType();
        if (this.invHandlers != null) {
            for (ComponentInvocationHandler handler : this.invHandlers) {
                handler.beforePreInvoke(invType, prevInv, inv);
            }
        }
        if ((setCIH = this.regCompInvHandlerMap.get((Object)invType)) != null) {
            for (int i = 0; i < setCIH.size(); ++i) {
                setCIH.get(i).getComponentInvocationHandler().beforePreInvoke(invType, prevInv, inv);
            }
        }
        v.add(inv);
        if (this.invHandlers != null) {
            for (ComponentInvocationHandler handler : this.invHandlers) {
                handler.afterPreInvoke(invType, prevInv, inv);
            }
        }
        if (setCIH != null) {
            for (int i = 0; i < setCIH.size(); ++i) {
                setCIH.get(i).getComponentInvocationHandler().afterPreInvoke(invType, prevInv, inv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ComponentInvocation> void postInvoke(T inv) throws InvocationException {
        int i;
        ComponentInvocation.ComponentInvocationType invType;
        InvocationArray v = (InvocationArray)this.frames.get();
        if (inv.getInvocationType() == ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP) {
            v.setInvocationAttribute(ComponentInvocation.ComponentInvocationType.UN_INITIALIZED);
            return;
        }
        int beforeSize = v.size();
        if (beforeSize == 0) {
            throw new InvocationException();
        }
        ComponentInvocation prevInv = beforeSize > 1 ? (ComponentInvocation)v.get(beforeSize - 2) : null;
        ComponentInvocation curInv = (ComponentInvocation)v.get(beforeSize - 1);
        try {
            List<RegisteredComponentInvocationHandler> setCIH;
            invType = inv.getInvocationType();
            if (this.invHandlers != null) {
                for (ComponentInvocationHandler handler : this.invHandlers) {
                    handler.beforePostInvoke(invType, prevInv, curInv);
                }
            }
            if ((setCIH = this.regCompInvHandlerMap.get((Object)invType)) != null) {
                for (i = 0; i < setCIH.size(); ++i) {
                    setCIH.get(i).getComponentInvocationHandler().beforePostInvoke(invType, prevInv, curInv);
                }
            }
        }
        finally {
            List<RegisteredComponentInvocationHandler> setCIH;
            v.remove(beforeSize - 1);
            if (this.invHandlers != null) {
                for (ComponentInvocationHandler handler : this.invHandlers) {
                    handler.afterPostInvoke(inv.getInvocationType(), prevInv, inv);
                }
            }
            if ((setCIH = this.regCompInvHandlerMap.get((Object)(invType = inv.getInvocationType()))) != null) {
                for (i = 0; i < setCIH.size(); ++i) {
                    setCIH.get(i).getComponentInvocationHandler().afterPostInvoke(invType, prevInv, curInv);
                }
            }
        }
    }

    @Override
    public boolean isInvocationStackEmpty() {
        ArrayList v = (ArrayList)this.frames.get();
        return v == null || v.size() == 0;
    }

    @Override
    public <T extends ComponentInvocation> T getCurrentInvocation() {
        ArrayList v = (ArrayList)this.frames.get();
        int size = v.size();
        if (size == 0) {
            return null;
        }
        return (T)((ComponentInvocation)v.get(size - 1));
    }

    @Override
    public <T extends ComponentInvocation> T getPreviousInvocation() throws InvocationException {
        ArrayList v = (ArrayList)this.frames.get();
        int i = v.size();
        if (i < 2) {
            return null;
        }
        return (T)((ComponentInvocation)v.get(i - 2));
    }

    public List getAllInvocations() {
        return (List)this.frames.get();
    }

    @Override
    public void registerComponentInvocationHandler(ComponentInvocation.ComponentInvocationType type2, RegisteredComponentInvocationHandler handler) {
        List<RegisteredComponentInvocationHandler> setRegCompInvHandlers = this.regCompInvHandlerMap.get((Object)type2);
        if (setRegCompInvHandlers == null) {
            setRegCompInvHandlers = new ArrayList<RegisteredComponentInvocationHandler>();
            this.regCompInvHandlerMap.put(type2, setRegCompInvHandlers);
        }
        if (setRegCompInvHandlers.size() == 0) {
            setRegCompInvHandlers.add(handler);
        }
    }

    @Override
    public void pushAppEnvironment(ApplicationEnvironment env) {
        Stack<ApplicationEnvironment> stack = this.applicationEnvironments.get();
        stack.push(env);
    }

    @Override
    public ApplicationEnvironment peekAppEnvironment() {
        Stack<ApplicationEnvironment> stack = this.applicationEnvironments.get();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    @Override
    public void popAppEnvironment() {
        Stack<ApplicationEnvironment> stack = this.applicationEnvironments.get();
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }

    static class InvocationArray<T extends ComponentInvocation>
    extends ArrayList<T> {
        private ComponentInvocation.ComponentInvocationType invocationAttribute;

        InvocationArray() {
        }

        public void setInvocationAttribute(ComponentInvocation.ComponentInvocationType attribute) {
            this.invocationAttribute = attribute;
        }

        public ComponentInvocation.ComponentInvocationType getInvocationAttribute() {
            return this.invocationAttribute;
        }

        public boolean outsideStartup() {
            return this.getInvocationAttribute() != ComponentInvocation.ComponentInvocationType.SERVICE_STARTUP;
        }
    }
}

