/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin.progress;

import java.util.ArrayList;
import java.util.List;
import org.glassfish.api.admin.progress.ProgressStatusBase;
import org.glassfish.api.admin.progress.ProgressStatusDTO;

public class ProgressStatusEvent {
    private final ProgressStatusDTO source;
    private final String parentSourceId;
    private final List<Changed> changed;
    private final String message;
    private final boolean spinner;
    private final int allocatedSteps;

    private ProgressStatusEvent(ProgressStatusBase source, String message, boolean spinner, int allocatedSteps, Changed ... changed) {
        this.source = ProgressStatusEvent.base2DTO(source);
        this.changed = new ArrayList<Changed>();
        if (changed != null) {
            for (Changed chng : changed) {
                if (chng == null) continue;
                this.changed.add(chng);
            }
        }
        this.message = message;
        this.spinner = spinner;
        this.allocatedSteps = allocatedSteps;
        ProgressStatusBase parrent = source.getParrent();
        this.parentSourceId = parrent != null ? source.getParrent().getId() : null;
    }

    public ProgressStatusEvent(ProgressStatusBase source, String message, boolean spinner, Changed ... changed) {
        this(source, message, spinner, 0, changed);
    }

    public ProgressStatusEvent(ProgressStatusBase source, int allocatedSteps) {
        this(source, null, false, allocatedSteps, Changed.NEW_CHILD);
    }

    public ProgressStatusEvent(ProgressStatusDTO source, String parentSourceId, String message, boolean spinner, int allocatedSteps, Changed ... changed) {
        this.source = source;
        this.parentSourceId = parentSourceId;
        this.changed = new ArrayList<Changed>();
        if (changed != null) {
            for (Changed chng : changed) {
                if (chng == null) continue;
                this.changed.add(chng);
            }
        }
        this.message = message;
        this.spinner = spinner;
        this.allocatedSteps = allocatedSteps;
    }

    private static ProgressStatusDTO base2DTO(ProgressStatusBase source) {
        if (source == null) {
            return null;
        }
        ProgressStatusDTO result = new ProgressStatusDTO();
        result.setId(source.getId());
        result.setName(source.getName());
        result.setTotalStepCount(source.getTotalStepCount());
        result.setCurrentStepCount(source.getCurrentStepCount());
        result.setCompleted(source.isComplete());
        return result;
    }

    public int getAllocatedSteps() {
        return this.allocatedSteps;
    }

    public List<Changed> getChanged() {
        return this.changed;
    }

    public String getMessage() {
        return this.message;
    }

    public ProgressStatusDTO getSource() {
        return this.source;
    }

    public String getParentSourceId() {
        return this.parentSourceId;
    }

    public boolean isSpinner() {
        return this.spinner;
    }

    public String toString() {
        return "ProgressStatusEvent{source=" + this.source + ", parentSourceId=" + this.parentSourceId + ", changed=" + this.changed + ", message=" + this.message + ", spinner=" + this.spinner + ", allocatedSteps=" + this.allocatedSteps + '}';
    }

    public static enum Changed {
        NEW_CHILD,
        STEPS,
        TOTAL_STEPS,
        COMPLETED,
        SPINNER;

    }
}

