/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.annotation.processing.logging;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.glassfish.annotation.processing.logging.BaseLoggingProcessor;
import org.glassfish.annotation.processing.logging.LoggingMetadata;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;

@SupportedAnnotationTypes(value={"org.glassfish.logging.annotation.LogMessageInfo", "org.glassfish.logging.annotation.LogMessagesResourceBundle"})
public class LogMessagesResourceBundleGenerator
extends BaseLoggingProcessor {
    private static final String[] VALIDATE_LEVELS = new String[]{"EMERGENCY", "ALERT", "SEVERE"};

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.debug("LogMessagesResourceBundleGenerator invoked.");
        if (!env.processingOver()) {
            LoggingMetadata logMessagesMap = new LoggingMetadata();
            Set<? extends Element> elements = env.getElementsAnnotatedWith(LogMessageInfo.class);
            Set<? extends Element> rbElems = env.getElementsAnnotatedWith(LogMessagesResourceBundle.class);
            if (rbElems.isEmpty() && elements.isEmpty()) {
                return false;
            }
            HashSet<String> rbNames = new HashSet<String>();
            for (Element element : rbElems) {
                Object rbValue = ((VariableElement)element).getConstantValue();
                if (rbValue == null) {
                    this.error("The resource bundle name value could not be computed. Specify the LogMessagesResourceBundle annotation only on a compile time constant String literal.");
                    return false;
                }
                rbNames.add(rbValue.toString());
            }
            if (rbNames.isEmpty()) {
                this.error("No resource bundle name found. Atleast one String literal constant needs to be decorated with the LogMessagesResourceBundle annotation.");
                return false;
            }
            if (rbNames.size() > 1) {
                this.error("More than one resource bundle name specified. Found the following resource bundle names: " + rbNames + ". Please specify only one resource bundle name per module.");
                return false;
            }
            String rbName = (String)rbNames.iterator().next();
            if (!rbName.endsWith("LogMessages")) {
                this.error("The resource bundle name '" + rbName + "' annotated by @LogMessagesResourceBundle does not end with 'LogMessages'");
                return false;
            }
            Iterator<? extends Element> iterator = elements.iterator();
            HashSet<String> messageIds = new HashSet<String>();
            while (iterator.hasNext()) {
                VariableElement element = (VariableElement)iterator.next();
                String msgId = (String)element.getConstantValue();
                this.debug("Processing: " + msgId);
                if (!messageIds.contains(msgId)) {
                    LogMessageInfo lmi = element.getAnnotation(LogMessageInfo.class);
                    this.checkLogMessageInfo(msgId, lmi);
                    logMessagesMap.put(msgId, lmi.message());
                    if (!lmi.comment().isEmpty()) {
                        logMessagesMap.putComment(msgId, lmi.comment());
                    }
                    messageIds.add(msgId);
                    continue;
                }
                this.error("Duplicate use of message-id " + msgId);
            }
            this.debug("Messages found so far: " + logMessagesMap);
            this.loadLogMessages(logMessagesMap, rbName);
            this.debug("Total Messages including ones found from disk so far: " + logMessagesMap);
            this.storeLogMessages(logMessagesMap, rbName);
            this.info("Annotation processing finished successfully.");
            return true;
        }
        return false;
    }

    private void checkLogMessageInfo(String msgId, LogMessageInfo lmi) {
        boolean needsCheck = false;
        for (String checkLevel : VALIDATE_LEVELS) {
            if (!checkLevel.equals(lmi.level())) continue;
            needsCheck = true;
        }
        this.debug("Message " + msgId + " needs checking for cause/action: " + needsCheck);
        if (needsCheck) {
            if (lmi.cause().trim().length() == 0) {
                this.error("Missing cause for message id '" + msgId + "' for levels SEVERE and above.");
            }
            if (lmi.action().trim().length() == 0) {
                this.error("Missing action for message id '" + msgId + "' for levels SEVERE and above.");
            }
        }
    }
}

