/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.composite.metadata.Confidential;
import org.glassfish.admin.rest.model.ResponseBody;
import org.glassfish.admin.rest.utils.StringUtil;

public class JsonUtil {
    public static final String CONFIDENTIAL_PROPERTY_SET = "@_Oracle_Confidential_Property_Set_V1.1_#";
    public static final String CONFIDENTIAL_PROPERTY_UNSET = null;

    public static Object getJsonObject(Object object) throws JSONException {
        Object result;
        if (object instanceof Collection) {
            result = JsonUtil.processCollection((Collection)object);
        } else if (object instanceof Map) {
            result = JsonUtil.processMap((Map)object);
        } else if (object == null) {
            result = JSONObject.NULL;
        } else if (RestModel.class.isAssignableFrom(object.getClass())) {
            result = JsonUtil.getJsonForRestModel((RestModel)object, true);
        } else if (object instanceof ResponseBody) {
            result = ((ResponseBody)object).toJson();
        } else {
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                JSONArray array = new JSONArray();
                int lenth = Array.getLength(object);
                for (int i = 0; i < lenth; ++i) {
                    array.put(JsonUtil.getJsonObject(Array.get(object, i)));
                }
                result = array;
            } else {
                result = object;
            }
        }
        return result;
    }

    public static JSONObject getJsonForRestModel(RestModel model, boolean hideConfidentialProperties) {
        JSONObject result = new JSONObject();
        for (Method m : model.getClass().getDeclaredMethods()) {
            if (!m.getName().startsWith("get")) continue;
            String propName = m.getName().substring(3);
            propName = propName.substring(0, 1).toLowerCase(Locale.getDefault()) + propName.substring(1);
            try {
                result.put(propName, JsonUtil.getJsonObject(JsonUtil.getRestModelProperty(model, m, hideConfidentialProperties)));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private static Object getRestModelProperty(RestModel model, Method method, boolean hideConfidentialProperties) throws Exception {
        Object object = method.invoke((Object)model, new Object[0]);
        if (hideConfidentialProperties && JsonUtil.isConfidentialString(model, method)) {
            String str = (String)object;
            return StringUtil.notEmpty(str) ? CONFIDENTIAL_PROPERTY_SET : CONFIDENTIAL_PROPERTY_UNSET;
        }
        return object;
    }

    private static boolean isConfidentialString(RestModel model, Method method) {
        if (!String.class.equals(method.getReturnType())) {
            return false;
        }
        return JsonUtil.isConfidentialProperty(model.getClass(), method.getName());
    }

    public static boolean isConfidentialProperty(Class clazz, String getterMethodName) {
        if (JsonUtil.getConfidentialAnnotation(clazz, getterMethodName) != null) {
            return true;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (JsonUtil.getConfidentialAnnotation(iface, getterMethodName) == null) continue;
            return true;
        }
        return false;
    }

    private static Confidential getConfidentialAnnotation(Class clazz, String getterMethodName) {
        try {
            Method m = clazz.getDeclaredMethod(getterMethodName, new Class[0]);
            return m.getAnnotation(Confidential.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JSONArray processCollection(Collection c) throws JSONException {
        JSONArray result = new JSONArray();
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object item = JsonUtil.getJsonObject(i.next());
            result.put(item);
        }
        return result;
    }

    public static JSONObject processMap(Map map) throws JSONException {
        JSONObject result = new JSONObject();
        for (Map.Entry entry : map.entrySet()) {
            result.put(entry.getKey().toString(), JsonUtil.getJsonObject(entry.getValue()));
        }
        return result;
    }
}

