/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.custom;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.config.Dom;

public class JmxServiceUrlsResource {
    @Context
    protected ServiceLocator habitat;

    public void setEntity(Dom p) {
    }

    @GET
    @Produces(value={"text/html;qs=2", "application/json", "application/xml"})
    @Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
    public ActionReportResult getJmxServiceUrl() {
        try {
            MBeanServer mBeanServer = this.habitat.getService(MBeanServer.class, new Annotation[0]);
            JMXServiceURL[] urls = (JMXServiceURL[])mBeanServer.getAttribute(this.getBootAMXMBeanObjectName(), "JMXServiceURLs");
            ArrayList<String> jmxUrls = new ArrayList<String>();
            for (JMXServiceURL url : urls) {
                jmxUrls.add(url.getURLPath());
            }
            RestActionReporter ar = new RestActionReporter();
            ar.setActionDescription("Get JMX Service URLs");
            ar.setSuccess();
            ar.getExtraProperties().put("jmxServiceUrls", jmxUrls);
            return new ActionReportResult(ar);
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    private ObjectName getBootAMXMBeanObjectName() {
        try {
            return new ObjectName("amx-support:type=boot-amx");
        }
        catch (Exception e) {
            throw new RuntimeException("bad ObjectName", e);
        }
    }
}

