/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.composite;

import com.sun.enterprise.v3.common.ActionReporter;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.glassfish.admin.rest.composite.CompositeResource;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.RestCollection;
import org.glassfish.admin.rest.resources.composite.Job;
import org.glassfish.admin.rest.resources.composite.JobResource;
import org.glassfish.admin.rest.utils.StringUtil;
import org.jvnet.hk2.annotations.Service;

@Service
@Path(value="/jobs")
public class JobsResources
extends CompositeResource {
    @GET
    public RestCollection<Job> getJobs(@QueryParam(value="currentUser") @DefaultValue(value="false") boolean currentUser) throws Exception {
        RestCollection<Job> rc = new RestCollection<Job>();
        ActionReporter ar = this.executeReadCommand("list-jobs");
        List jobMaps = (List)ar.getExtraProperties().get("jobs");
        if (jobMaps != null) {
            for (Map jobMap : jobMaps) {
                if (currentUser && !StringUtil.compareStrings((String)jobMap.get("user"), this.getAuthenticatedUser())) continue;
                Job model = JobsResources.constructJobModel(jobMap);
                URI uri = this.getChildItemUri(model.getJobId());
                rc.put(uri.toASCIIString(), model);
            }
        }
        return rc;
    }

    @Path(value="id/{jobId}")
    public JobResource getJobResource() {
        return this.getSubResource(JobResource.class);
    }

    public static Job constructJobModel(Map<String, Object> jobMap) {
        if (jobMap == null) {
            return null;
        }
        Job model = CompositeUtil.instance().getModel(Job.class);
        model.setJobId((String)jobMap.get("jobId"));
        model.setJobName((String)jobMap.get("jobName"));
        model.setExecutionDate(jobMap.get("executionDate").toString());
        model.setExitCode((String)jobMap.get("exitCode"));
        model.setMessage((String)jobMap.get("message"));
        model.setUser((String)jobMap.get("user"));
        return model;
    }
}

