/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.composite.metadata.RestResourceMetadata;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.config.support.Delete;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.TransactionFailure;

@Produces(value={"text/html;qs=2", "application/json", "application/xml", "application/x-www-form-urlencoded"})
@Consumes(value={"application/json", "application/xml", "application/x-www-form-urlencoded"})
public class TemplateRestResource
extends AbstractResource
implements OptionsCapable {
    protected Dom entity;
    protected Dom parent;
    protected String tagName;
    protected ConfigModel childModel;
    protected String childID;
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateRestResource.class);
    private static final List<String> attributesToSkip = new ArrayList<String>(){
        {
            this.add("parent");
            this.add("name");
            this.add("children");
            this.add("submit");
        }
    };

    @GET
    public Object getEntity(@QueryParam(value="expandLevel") @DefaultValue(value="1") int expandLevel) {
        if (this.childModel == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (Util.useLegacyResponseFormat(this.requestHeaders)) {
            return this.buildActionReportResult(true);
        }
        return this.getAttributes((ConfigBean)this.getEntity());
    }

    @POST
    public Response createEntity(HashMap<String, String> data) {
        if (data == null) {
            data = new HashMap();
        }
        try {
            this.removeAttributesToBeSkipped(data);
            if (data.containsKey("error")) {
                return Response.status(400).entity(ResourceUtil.getActionReportResult(ActionReport.ExitCode.FAILURE, localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax."), this.requestHeaders, this.uriInfo)).build();
            }
            ResourceUtil.purgeEmptyEntries(data);
            if ("__deleteoperation".equals(data.get("operation"))) {
                data.remove("operation");
                return this.delete(data);
            }
            RestActionReporter ar = Util.applyChanges(data = ResourceUtil.translateCamelCasedNamesToXMLNames(data), this.uriInfo, this.getSubject());
            if (ar.getActionExitCode() != ActionReport.ExitCode.SUCCESS) {
                return this.handleError(Response.Status.BAD_REQUEST, "Could not apply changes" + ar.getMessage());
            }
            if (Util.useLegacyResponseFormat(this.requestHeaders)) {
                String successMessage = localStrings.getLocalString("rest.resource.update.message", "\"{0}\" updated successfully.", this.uriInfo.getAbsolutePath());
                return Response.ok(ResourceUtil.getActionReportResult(ar, successMessage, this.requestHeaders, this.uriInfo)).build();
            }
            return Response.status(Response.Status.CREATED).build();
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Object post(FormDataMultiPart formData) {
        HashMap<String, String> data = TemplateRestResource.createDataBasedOnForm(formData);
        return this.createEntity(data);
    }

    @DELETE
    public Response delete(HashMap<String, String> data) {
        if (data == null) {
            data = new HashMap();
        }
        if (this.entity == null) {
            return this.handleError(Response.Status.NOT_FOUND, localStrings.getLocalString("rest.resource.erromessage.noentity", "Resource not found."));
        }
        if (this.getDeleteCommand() == null) {
            String message = localStrings.getLocalString("rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.", this.uriInfo.getAbsolutePath());
            return this.handleError(Response.Status.FORBIDDEN, message);
        }
        if (this.getDeleteCommand().equals("GENERIC-DELETE")) {
            try {
                ConfigBean p = (ConfigBean)this.parent;
                if (this.parent == null) {
                    p = (ConfigBean)this.entity.parent();
                }
                ConfigSupport.deleteChild(p, (ConfigBean)this.entity);
                return Response.ok(ResourceUtil.getActionReportResult(ActionReport.ExitCode.SUCCESS, localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", this.uriInfo.getAbsolutePath()), this.requestHeaders, this.uriInfo)).build();
            }
            catch (TransactionFailure ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        try {
            if (data.containsKey("error")) {
                return this.handleError(Response.Status.BAD_REQUEST, localStrings.getLocalString("rest.request.parsing.error", "Unable to parse the input entity. Please check the syntax."));
            }
            ResourceUtil.addQueryString(this.uriInfo.getQueryParameters(), data);
            ResourceUtil.purgeEmptyEntries(data);
            ResourceUtil.adjustParameters(data);
            if (data.get("DEFAULT") == null) {
                this.addDefaultParameter(data);
            } else {
                String resourceName = this.getResourceName(this.uriInfo.getAbsolutePath().getPath(), "/");
                if (!data.get("DEFAULT").equals(resourceName)) {
                    return this.handleError(Response.Status.FORBIDDEN, localStrings.getLocalString("rest.resource.not.deleted", "Resource not deleted. Value of \"name\" should be the name of this resource."));
                }
            }
            RestActionReporter actionReport = this.runCommand(this.getDeleteCommand(), data);
            if (actionReport != null) {
                ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
                if (exitCode != ActionReport.ExitCode.FAILURE) {
                    return Response.ok(ResourceUtil.getActionReportResult(actionReport, localStrings.getLocalString("rest.resource.delete.message", "\"{0}\" deleted successfully.", this.uriInfo.getAbsolutePath()), this.requestHeaders, this.uriInfo)).build();
                }
                return this.handleError(Response.Status.BAD_REQUEST, actionReport.getMessage());
            }
            return this.handleError(Response.Status.BAD_REQUEST, localStrings.getLocalString("rest.resource.delete.forbidden", "DELETE on \"{0}\" is forbidden.", this.uriInfo.getAbsolutePath()));
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @OPTIONS
    public Response options() {
        if (Util.useLegacyResponseFormat(this.requestHeaders)) {
            return Response.ok(this.buildActionReportResult(false)).build();
        }
        RestResourceMetadata rrmd = new RestResourceMetadata(this);
        String json = "";
        try {
            json = rrmd.toJson().toString(Util.getFormattingIndentLevel());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return Response.ok(json).build();
    }

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @Override
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public void setEntity(Dom p) {
        this.entity = p;
        this.childModel = p.model;
    }

    public Dom getEntity() {
        return this.entity;
    }

    public void setParentAndTagName(Dom parent, String tagName) {
        if (parent == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        this.parent = parent;
        this.tagName = tagName;
        this.entity = parent.nodeElement(tagName);
        if (this.entity == null) {
            ConfigBeanProxy cbp;
            String location = this.buildPath(parent) + "/" + tagName;
            if (location.startsWith("domain/configs") && (cbp = this.locatorBridge.getRemoteLocator().getService(ConfigModularityUtils.class, new Annotation[0]).getOwningObject(location)) != null) {
                this.entity = Dom.unwrap(cbp);
                this.childModel = this.entity.model;
            }
        } else {
            this.childModel = this.entity.model;
        }
    }

    private String buildPath(Dom node) {
        Dom parentNode = node.parent();
        String part = node.model.getTagName();
        String name = node.attribute("name");
        if (name != null) {
            part = name;
        }
        return parentNode != null ? this.buildPath(parentNode) + "/" + part : part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap<String, String> createDataBasedOnForm(FormDataMultiPart formData) {
        HashMap<String, String> data = new HashMap<String, String>();
        try {
            Map<String, List<FormDataBodyPart>> m1 = formData.getFields();
            Set<String> ss = m1.keySet();
            for (String fieldName : ss) {
                for (FormDataBodyPart bodyPart : formData.getFields(fieldName)) {
                    if (bodyPart.getContentDisposition().getFileName() != null) {
                        InputStream fileStream = bodyPart.getValueAs(InputStream.class);
                        String mimeType = bodyPart.getMediaType().toString();
                        String fileName = bodyPart.getContentDisposition().getFileName();
                        if (fileName.contains("/")) {
                            fileName = Util.getName(fileName, '/');
                        } else if (fileName.contains("\\")) {
                            fileName = Util.getName(fileName, '\\');
                        }
                        File f = Util.saveFile(fileName, mimeType, fileStream);
                        f.deleteOnExit();
                        data.put(fieldName, f.getAbsolutePath());
                        continue;
                    }
                    data.put(fieldName, bodyPart.getValue());
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(TemplateRestResource.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            formData.cleanup();
        }
        return data;
    }

    public void setBeanByKey(List<Dom> parentList, String id, String tag) {
        this.tagName = tag;
        this.childID = id;
        if (parentList != null) {
            for (Dom c : parentList) {
                String keyvalue;
                String keyAttributeName = null;
                ConfigModel model = c.model;
                if (model.key == null) {
                    try {
                        for (String s : model.getAttributeNames()) {
                            if (!s.equals("name")) continue;
                            keyAttributeName = s;
                        }
                        if (keyAttributeName == null) {
                            keyAttributeName = model.getAttributeNames().iterator().next();
                        }
                    }
                    catch (Exception e) {
                        keyAttributeName = "ThisIsAModelBug:NoKeyAttr";
                    }
                } else {
                    keyAttributeName = model.key.substring(1, model.key.length());
                }
                if (!(keyvalue = c.attribute(keyAttributeName.toLowerCase(Locale.US))).equals(id)) continue;
                this.setEntity((ConfigBean)c);
            }
        }
    }

    protected ActionReportResult buildActionReportResult(boolean showEntityValues) {
        RestActionReporter ar = new RestActionReporter();
        ar.setExtraProperties(new Properties());
        ConfigBean entity = (ConfigBean)this.getEntity();
        if (this.childID != null) {
            ar.setActionDescription(this.childID);
        } else if (this.childModel != null) {
            ar.setActionDescription(this.childModel.getTagName());
        }
        if (showEntityValues && entity != null) {
            ar.getExtraProperties().put("entity", this.getAttributes(entity));
        }
        OptionsResult optionsResult = new OptionsResult(Util.getResourceName(this.uriInfo));
        Map<String, MethodMetaData> mmd = this.getMethodMetaData();
        optionsResult.putMethodMetaData("GET", mmd.get("GET"));
        optionsResult.putMethodMetaData("POST", mmd.get("POST"));
        optionsResult.putMethodMetaData("DELETE", mmd.get("DELETE"));
        ResourceUtil.addMethodMetaData(ar, mmd);
        if (entity != null) {
            ar.getExtraProperties().put("childResources", ResourceUtil.getResourceLinks(entity, this.uriInfo, ResourceUtil.canShowDeprecatedItems(this.locatorBridge.getRemoteLocator())));
        }
        ar.getExtraProperties().put("commands", ResourceUtil.getCommandLinks(this.getCommandResourcesPaths()));
        return new ActionReportResult(ar, entity, optionsResult);
    }

    protected void removeAttributesToBeSkipped(Map<String, String> data) {
        for (String item : attributesToSkip) {
            data.remove(item);
        }
    }

    protected String[][] getCommandResourcesPaths() {
        return new String[0][];
    }

    protected String getDeleteCommand() {
        if (this.entity == null) {
            return null;
        }
        String result = ResourceUtil.getCommand(RestRedirect.OpType.DELETE, this.getEntity().model);
        if (result == null && this.entity.parent() != null) {
            Class<?> cbp = null;
            try {
                cbp = this.entity.parent().model.classLoaderHolder.loadClass(this.entity.parent().model.targetTypeName);
            }
            catch (MultiException e) {
                return null;
            }
            Delete del = null;
            for (Method m : cbp.getMethods()) {
                ConfigModel.Property pp = this.entity.parent().model.toProperty(m);
                if (pp == null || !pp.xmlName.equals(this.tagName) || !m.isAnnotationPresent(Delete.class)) continue;
                del = m.getAnnotation(Delete.class);
                break;
            }
            if (del != null) {
                return del.value();
            }
        }
        return result;
    }

    private RestActionReporter runCommand(String commandName, HashMap<String, String> data) {
        if (commandName != null) {
            return ResourceUtil.runCommand(commandName, data, this.locatorBridge.getRemoteLocator(), ResourceUtil.getResultType(this.requestHeaders));
        }
        return null;
    }

    private void addDefaultParameter(HashMap<String, String> data) {
        String defaultParameterValue = this.getEntity().getKey();
        if (defaultParameterValue == null) {
            defaultParameterValue = this.parent.getKey();
        }
        data.put("DEFAULT", defaultParameterValue);
    }

    private String getResourceName(String absoluteName, String delimiter) {
        if (null == absoluteName) {
            return absoluteName;
        }
        int index = absoluteName.lastIndexOf(delimiter);
        if (index != -1) {
            return absoluteName.substring(index += delimiter.length());
        }
        return absoluteName;
    }

    private Map<String, String> getAttributes(Dom entity) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Set<String> attributeNames = entity.model.getAttributeNames();
        for (String attributeName : attributeNames) {
            result.put(Util.eleminateHypen(attributeName), entity.attribute(attributeName));
        }
        return result;
    }

    private Map<String, MethodMetaData> getMethodMetaData() {
        TreeMap<String, MethodMetaData> map = new TreeMap<String, MethodMetaData>();
        map.put("GET", new MethodMetaData());
        MethodMetaData postMethodMetaData = ResourceUtil.getMethodMetaData(this.childModel);
        map.put("POST", postMethodMetaData);
        String command = this.getDeleteCommand();
        if (command != null) {
            MethodMetaData deleteMethodMetaData;
            if (command.equals("GENERIC-DELETE")) {
                deleteMethodMetaData = new MethodMetaData();
            } else {
                deleteMethodMetaData = ResourceUtil.getMethodMetaData(command, this.locatorBridge.getRemoteLocator(), RestService.logger);
                deleteMethodMetaData.removeParamMetaData("id");
            }
            map.put("DELETE", deleteMethodMetaData);
        }
        return map;
    }

    protected Response handleError(Response.Status error, String message) throws WebApplicationException {
        return Response.status(error).entity(message).build();
    }
}

