/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.metadata.RestResourceMetadata;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.resources.CommandResult;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.jersey.media.sse.EventOutput;

public class TemplateExecCommand
extends AbstractResource
implements OptionsCapable {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateExecCommand.class);
    protected String resourceName;
    protected String commandName;
    protected String commandDisplayName;
    protected String commandMethod;
    protected String commandAction;
    protected boolean isLinkedToParent = false;

    public TemplateExecCommand(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, boolean isLinkedToParent) {
        this.resourceName = resourceName;
        this.commandName = commandName;
        this.commandMethod = commandMethod;
        this.commandAction = commandAction;
        this.commandDisplayName = commandDisplayName;
        this.isLinkedToParent = isLinkedToParent;
    }

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @Override
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html;qs=2", "application/xml"})
    public Object options() {
        if (Util.useLegacyResponseFormat(this.requestHeaders)) {
            RestActionReporter ar = new RestActionReporter();
            ar.setExtraProperties(new Properties());
            ar.setActionDescription(this.commandDisplayName);
            OptionsResult optionsResult = new OptionsResult(this.resourceName);
            HashMap<String, MethodMetaData> mmd = new HashMap<String, MethodMetaData>();
            MethodMetaData methodMetaData = ResourceUtil.getMethodMetaData(this.commandName, this.getCommandParams(), this.locatorBridge.getRemoteLocator(), RestService.logger);
            optionsResult.putMethodMetaData(this.commandMethod, methodMetaData);
            mmd.put(this.commandMethod, methodMetaData);
            ResourceUtil.addMethodMetaData(ar, mmd);
            ActionReportResult ret = new ActionReportResult(ar, null, optionsResult);
            ret.setCommandDisplayName(this.commandDisplayName);
            return ret;
        }
        try {
            return new RestResourceMetadata(this).toJson().toString(Util.getFormattingIndentLevel());
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Response executeCommandAsSse(ParameterMap data) {
        EventOutput ec = ResourceUtil.runCommandWithSse(this.commandName, data, null, null);
        return Response.status(200).entity(ec).build();
    }

    protected Response executeCommand(ParameterMap data) {
        int status;
        RestActionReporter actionReport = ResourceUtil.runCommand(this.commandName, data, this.locatorBridge.getRemoteLocator(), ResourceUtil.getResultType(this.requestHeaders), this.getSubject());
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        int n = status = exitCode == ActionReport.ExitCode.FAILURE ? 500 : 200;
        if (Util.useLegacyResponseFormat(this.requestHeaders)) {
            ActionReportResult option = (ActionReportResult)this.options();
            ActionReportResult results = new ActionReportResult(this.commandName, actionReport, option.getMetaData());
            results.getActionReport().getExtraProperties().putAll((Map<?, ?>)option.getActionReport().getExtraProperties());
            results.setCommandDisplayName(this.commandDisplayName);
            if (exitCode == ActionReport.ExitCode.FAILURE) {
                results.setErrorMessage(actionReport.getCombinedMessage());
            }
            return Response.status(status).entity(results).build();
        }
        CommandResult cr = CompositeUtil.instance().getModel(CommandResult.class);
        cr.setMessage(actionReport.getMessage());
        cr.setProperties(actionReport.getTopMessagePart().getProps());
        cr.setExtraProperties(this.getExtraProperties(actionReport));
        return Response.status(status).entity(cr).build();
    }

    private Map<String, Object> getExtraProperties(RestActionReporter actionReport) {
        Properties props = actionReport.getExtraProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue());
        }
        return map;
    }

    protected HashMap<String, String> getCommandParams() {
        return null;
    }

    protected void processCommandParams(ParameterMap data) {
        HashMap<String, String> commandParams = this.getCommandParams();
        if (commandParams != null) {
            ResourceUtil.resolveParamValues(commandParams, this.uriInfo);
            for (Map.Entry<String, String> entry : commandParams.entrySet()) {
                data.add(entry.getKey(), entry.getValue());
            }
        }
    }

    protected void addQueryString(MultivaluedMap<String, String> qs, ParameterMap data) {
        for (Map.Entry entry : qs.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                data.add(key, value);
            }
        }
    }

    protected void adjustParameters(ParameterMap data) {
        if (data != null) {
            boolean isRenamed;
            if (!data.containsKey("DEFAULT") && !(isRenamed = this.renameParameter(data, "name", "DEFAULT"))) {
                this.renameParameter(data, "id", "DEFAULT");
            }
            data.remove("jsoncallback");
            data.remove("_");
        }
    }

    protected boolean renameParameter(ParameterMap data, String parameterToRename, String newName) {
        if (data.containsKey(parameterToRename)) {
            List value = data.get(parameterToRename);
            data.remove(parameterToRename);
            data.set(newName, value);
            return true;
        }
        return false;
    }

    protected void purgeEmptyEntries(ParameterMap data) {
        HashSet keyToRemove = new HashSet();
        Set entries = data.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            keyToRemove.add(entry.getKey());
        }
        if ("true".equals(data.getOne("__remove_empty_entries__"))) {
            data.remove("__remove_empty_entries__");
            Set entries2 = data.entrySet();
            for (Map.Entry entry : entries2) {
                if (entry.getValue().size() != 1 || !((String)entry.getValue().get(0)).equals("")) continue;
                keyToRemove.add(entry.getKey());
            }
        }
        for (String k : keyToRemove) {
            data.remove(k);
        }
    }

    protected String getParent(UriInfo uriInfo) {
        List<PathSegment> segments = uriInfo.getPathSegments(true);
        String parent = segments.get(segments.size() - 2).getPath();
        return parent;
    }
}

