/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.glassfish.admin.rest.provider.BaseProvider;
import org.glassfish.api.admin.progress.ProgressStatusDTO;
import org.glassfish.api.admin.progress.ProgressStatusEvent;

@Provider
@Produces(value={"application/json", "application/x-javascript"})
public class ProgressStatusEventJsonProvider
extends BaseProvider<ProgressStatusEvent> {
    private static final JsonFactory factory = new JsonFactory();

    public ProgressStatusEventJsonProvider() {
        super(ProgressStatusEvent.class, MediaType.APPLICATION_JSON_TYPE, new MediaType("application", "x-javascript"));
    }

    @Override
    protected boolean isGivenTypeWritable(Class<?> type2, Type genericType) {
        return this.desiredType.isAssignableFrom(type2);
    }

    @Override
    public void writeTo(ProgressStatusEvent proxy, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        JsonGenerator out = factory.createJsonGenerator(entityStream, JsonEncoding.UTF8);
        out.writeStartObject();
        this.writeJson("progress-status-event", proxy, out);
        out.writeEndObject();
        out.flush();
    }

    public void writeJson(String name, ProgressStatusEvent event, JsonGenerator out) throws IOException {
        if (event == null) {
            return;
        }
        if (name != null) {
            out.writeObjectFieldStart(name);
        } else {
            out.writeStartObject();
        }
        if (event.getChanged() != null && event.getChanged().size() > 0) {
            out.writeArrayFieldStart("changed");
            for (ProgressStatusEvent.Changed chng : event.getChanged()) {
                if (chng == null) continue;
                out.writeString(chng.name());
            }
            out.writeEndArray();
        }
        if (event.getMessage() != null && !event.getMessage().isEmpty()) {
            out.writeStringField("message", event.getMessage());
        }
        if (event.isSpinner()) {
            out.writeBooleanField("spinner", event.isSpinner());
        }
        if (event.getAllocatedSteps() > 0) {
            out.writeNumberField("allocated-steps", event.getAllocatedSteps());
        }
        if (event.getParentSourceId() != null) {
            out.writeStringField("parent-id", event.getParentSourceId());
        }
        this.writeJson("progress-status", event.getSource(), out);
        out.writeEndObject();
    }

    public void writeJson(String name, ProgressStatusDTO ps, JsonGenerator out) throws IOException {
        if (ps == null) {
            return;
        }
        if (name != null) {
            out.writeObjectFieldStart(name);
        } else {
            out.writeStartObject();
        }
        out.writeStringField("name", ps.getName());
        out.writeStringField("id", ps.getId());
        out.writeNumberField("total-step-count", ps.getTotalStepCount());
        out.writeNumberField("current-step-count", ps.getCurrentStepCount());
        out.writeBooleanField("complete", ps.isCompleted());
        out.writeEndObject();
    }

    @Override
    public String getContent(ProgressStatusEvent proxy) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

