/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.model;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.composite.RestModel;
import org.glassfish.admin.rest.model.Message;
import org.glassfish.admin.rest.utils.JsonUtil;

public class ResponseBody {
    public static final String EVENT_NAME = "response/body";
    private List<Message> messages = new ArrayList<Message>();
    private RestModel entity;

    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(List<Message> val) {
        this.messages = val;
    }

    public RestModel getEntity() {
        return this.entity;
    }

    public ResponseBody setEntity(RestModel entity) {
        this.entity = entity;
        return this;
    }

    public ResponseBody addSuccess(String message) {
        return this.add(Message.Severity.SUCCESS, message);
    }

    public ResponseBody addWarning(String message) {
        return this.add(Message.Severity.WARNING, message);
    }

    public ResponseBody addFailure(String message) {
        return this.add(Message.Severity.FAILURE, message);
    }

    public ResponseBody add(Message.Severity severity, String message) {
        return this.add(new Message(severity, message));
    }

    public ResponseBody add(Message message) {
        this.getMessages().add(message);
        return this;
    }

    public JSONObject toJson() throws JSONException {
        JSONObject object = new JSONObject();
        if (!this.messages.isEmpty()) {
            JSONArray array = new JSONArray();
            for (Message message : this.messages) {
                JSONObject o = new JSONObject();
                o.put("message", message.getMessage());
                o.put("severity", message.getSeverity().toString());
                array.put(o);
            }
            object.put("messages", array);
        }
        if (this.entity != null) {
            object.put("item", JsonUtil.getJsonObject(this.getEntity()));
        }
        return object;
    }
}

