/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite.metadata;

import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.metadata.Confidential;
import org.glassfish.admin.rest.composite.metadata.CreateOnly;
import org.glassfish.admin.rest.composite.metadata.Default;
import org.glassfish.admin.rest.composite.metadata.DefaultsGenerator;
import org.glassfish.admin.rest.composite.metadata.Immutable;
import org.glassfish.admin.rest.composite.metadata.ReadOnly;
import org.jvnet.hk2.config.Attribute;

public class ParamMetadata {
    private String name;
    private String type;
    private String help;
    private Object defaultValue;
    private boolean readOnly = false;
    private boolean confidential = false;
    private boolean immutable = false;
    private boolean createOnly = false;
    private OptionsCapable context;
    private Class<?> paramType;

    public ParamMetadata() {
    }

    public ParamMetadata(OptionsCapable context, Class<?> paramType, String name, Annotation[] annotations) {
        this.name = name;
        this.context = context;
        this.type = paramType.getSimpleName();
        this.paramType = paramType;
        CompositeUtil instance = CompositeUtil.instance();
        this.help = instance.getHelpText(annotations);
        this.defaultValue = this.getDefaultValue(annotations);
        for (Annotation a : annotations) {
            if (a.annotationType().equals(ReadOnly.class)) {
                this.readOnly = true;
            }
            if (a.annotationType().equals(Confidential.class)) {
                this.confidential = true;
            }
            if (a.annotationType().equals(Immutable.class)) {
                this.immutable = true;
            }
            if (!a.annotationType().equals(CreateOnly.class)) continue;
            this.createOnly = true;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        return "ParamMetadata{name=" + this.name + ", type=" + this.type + ", help=" + this.help + '}';
    }

    public JSONObject toJson() throws JSONException {
        JSONObject o = new JSONObject();
        o.put("type", this.type);
        o.put("help", this.help);
        Object defVal = this.defaultValue != null ? this.defaultValue : JSONObject.NULL;
        o.put("default", defVal);
        o.put("readOnly", this.readOnly);
        o.put("confidential", this.confidential);
        o.put("immutable", this.immutable);
        o.put("createOnly", this.createOnly);
        return o;
    }

    private Object getDefaultValue(Annotation[] annos) {
        Object defval = null;
        if (annos != null) {
            for (Annotation annotation : annos) {
                if (Default.class.isAssignableFrom(annotation.getClass())) {
                    try {
                        Default def = (Default)annotation;
                        Class<?> clazz = def.generator();
                        if (def.useContext()) {
                            defval = ((DefaultsGenerator)((Object)this.context)).getDefaultValue(this.name);
                            break;
                        }
                        if (clazz != null && clazz != Void.class) {
                            if (DefaultsGenerator.class.isAssignableFrom(clazz)) {
                                defval = ((DefaultsGenerator)clazz.newInstance()).getDefaultValue(this.name);
                                break;
                            }
                            Logger.getLogger(ParamMetadata.class.getName()).log(Level.SEVERE, null, "The class specified by generator does not implement DefaultsGenerator");
                            break;
                        }
                        defval = this.parseValue(def.value());
                        break;
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ParamMetadata.class.getName()).log(Level.SEVERE, null, ex);
                        continue;
                    }
                }
                if (!Attribute.class.isAssignableFrom(annotation.getClass())) continue;
                Attribute attr = (Attribute)annotation;
                defval = attr.defaultValue();
                break;
            }
        }
        return defval;
    }

    private Object parseValue(String value) {
        try {
            if (this.paramType.equals(String.class)) {
                return value;
            }
            if (this.paramType.equals(Boolean.TYPE) || this.paramType.equals(Boolean.class)) {
                return Boolean.valueOf(value);
            }
            if (this.paramType.equals(Integer.TYPE) || this.paramType.equals(Integer.class)) {
                return new Integer(value);
            }
            if (this.paramType.equals(Long.TYPE) || this.paramType.equals(Long.class)) {
                return new Long(value);
            }
            if (this.paramType.equals(Double.TYPE) || this.paramType.equals(Double.class)) {
                return new Double(value);
            }
            if (this.paramType.equals(Float.TYPE) || this.paramType.equals(Float.class)) {
                return new Float(value);
            }
            Logger.getLogger(ParamMetadata.class.getName()).log(Level.SEVERE, null, "Unsupported fixed value.  Supported types are String, boolean, Boolean, int, Integer, long, Long, double, Double, float, and Float");
        }
        catch (NumberFormatException e) {
            Logger.getLogger(ParamMetadata.class.getName()).log(Level.SEVERE, null, "Fixed value type does not match the property type");
        }
        return null;
    }
}

