/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.composite;

import com.sun.enterprise.v3.common.ActionReporter;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilderException;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.RestResource;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.ResponseBodyBuilder;
import org.glassfish.admin.rest.composite.metadata.DefaultsGenerator;
import org.glassfish.admin.rest.composite.metadata.RestResourceMetadata;
import org.glassfish.admin.rest.model.ResponseBody;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.utils.DetachedCommandHelper;
import org.glassfish.admin.rest.utils.SseCommandHelper;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.internal.api.Globals;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.media.sse.EventOutput;

@Produces(value={"application/vnd.oracle.glassfish+json"})
public abstract class CompositeResource
extends AbstractResource
implements RestResource,
DefaultsGenerator,
OptionsCapable {
    private static final String MEDIA_TYPE = "application";
    private static final String MEDIA_SUB_TYPE = "vnd.oracle.glassfish";
    public static final String MEDIA_TYPE_BASE = "application/vnd.oracle.glassfish";
    public static final String MEDIA_TYPE_JSON = "application/vnd.oracle.glassfish+json";
    public static final MediaType MEDIA_TYPE_JSON_TYPE = new MediaType("application", "vnd.oracle.glassfish+json");
    public static final String MEDIA_TYPE_SSE = "application/vnd.oracle.glassfish+sse";
    protected static final String CONSUMES_TYPE = "application/vnd.oracle.glassfish+json";
    protected static final int THREAD_POOL_CORE = 5;
    protected static final int THREAD_POOL_MAX = 10;
    protected CompositeUtil compositeUtil = CompositeUtil.instance();

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @Override
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public void setSubjectRef(Ref<Subject> subjectRef) {
        this.subjectRef = subjectRef;
    }

    @Override
    public Object getDefaultValue(String propertyName) {
        return null;
    }

    public CompositeUtil getCompositeUtil() {
        return this.compositeUtil;
    }

    @OPTIONS
    public String options() throws JSONException {
        RestResourceMetadata rrmd = new RestResourceMetadata(this);
        return rrmd.toJson().toString(Util.getFormattingIndentLevel());
    }

    public <T> T getSubResource(Class<T> clazz) {
        try {
            T resource = clazz.newInstance();
            CompositeResource cr = (CompositeResource)resource;
            cr.locatorBridge = this.locatorBridge;
            cr.subjectRef = this.subjectRef;
            cr.uriInfo = this.uriInfo;
            cr.securityContext = this.securityContext;
            cr.requestHeaders = this.requestHeaders;
            cr.serviceLocator = this.serviceLocator;
            return resource;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    protected ActionReporter executeDeleteCommand(String command) {
        return this.getCompositeUtil().executeDeleteCommand(this.getSubject(), command);
    }

    protected ActionReporter executeDeleteCommand(String command, ParameterMap parameters) {
        return this.getCompositeUtil().executeDeleteCommand(this.getSubject(), command, parameters);
    }

    protected ActionReporter executeWriteCommand(String command) {
        return this.getCompositeUtil().executeWriteCommand(this.getSubject(), command);
    }

    protected ActionReporter executeWriteCommand(String command, ParameterMap parameters) {
        return this.getCompositeUtil().executeWriteCommand(this.getSubject(), command, parameters);
    }

    protected ActionReporter executeReadCommand(String command) {
        return this.getCompositeUtil().executeReadCommand(this.getSubject(), command);
    }

    protected ActionReporter executeReadCommand(String command, ParameterMap parameters) {
        return this.getCompositeUtil().executeReadCommand(this.getSubject(), command, parameters);
    }

    protected ActionReporter executeCommand(String command, ParameterMap parameters, boolean throwBadRequest, boolean throwOnWarning) {
        return this.getCompositeUtil().executeCommand(this.getSubject(), command, parameters, throwBadRequest, throwOnWarning);
    }

    protected EventOutput executeSseCreateCommand(Subject subject, String command, ParameterMap parameters, final ResponseBodyBuilder builder) {
        return this.getCompositeUtil().executeSseCommand(subject, command, parameters, new SseCommandHelper.ActionReportProcessor(){

            @Override
            public ActionReport process(ActionReport report, EventOutput ec) {
                if (report != null) {
                    ResponseBody rb = builder.build(report);
                    Properties props = new Properties();
                    props.put("response", rb);
                    report.setExtraProperties(props);
                }
                return report;
            }
        });
    }

    protected EventOutput executeSseCommand(Subject subject, String command, ParameterMap parameters, SseCommandHelper.ActionReportProcessor processor) {
        return this.getCompositeUtil().executeSseCommand(subject, command, parameters, processor);
    }

    protected EventOutput executeSseCommand(Subject subject, String command, ParameterMap parameters) {
        return this.getCompositeUtil().executeSseCommand(subject, command, parameters);
    }

    protected URI getChildItemUri(String name) throws IllegalArgumentException, UriBuilderException {
        return this.uriInfo.getAbsolutePathBuilder().path("id").path(name).build(new Object[0]);
    }

    protected String generateDefaultName(String namePrefix, Collection<String> usedNames) {
        for (int i = 1; i <= 100; ++i) {
            String name = namePrefix + "-" + i;
            if (usedNames.contains(name)) continue;
            return name;
        }
        return "";
    }

    protected Response created(URI location, ResponseBody responseBody) {
        return Response.status(Response.Status.CREATED).header("Location", location).entity(responseBody).build();
    }

    protected Response updated(ResponseBody responseBody) {
        return Response.ok().entity(responseBody).build();
    }

    protected Response deleted(ResponseBody responseBody) {
        return Response.ok().entity(responseBody).build();
    }

    protected Response accepted(String command, ParameterMap parameters, URI childUri) {
        CommandRunner cr = Globals.getDefaultHabitat().getService(CommandRunner.class, new Annotation[0]);
        RestActionReporter ar = new RestActionReporter();
        CommandRunner.CommandInvocation commandInvocation = cr.getCommandInvocation(command, ar, this.getSubject()).parameters(parameters);
        String jobId = DetachedCommandHelper.invokeAsync(commandInvocation);
        return Response.status(Response.Status.ACCEPTED).header("Location", this.uriInfo.getBaseUriBuilder().path("jobs").path("id").path(jobId).build(new Object[0])).header("X-Location", childUri).build();
    }

    protected String getPathParam(String name) {
        return this.getUriInfo().getPathParameters().getFirst(name);
    }

    protected boolean detachedRequested() {
        return Boolean.parseBoolean(this.getUriInfo().getQueryParameters().getFirst("detached"));
    }

    protected synchronized ExecutorService getExecutorService() {
        return ExecutorServiceHolder.INSTANCE;
    }

    private static class ExecutorServiceHolder {
        private static ExecutorService INSTANCE = new ThreadPoolExecutor(5, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(10, true), new ThreadPoolExecutor.CallerRunsPolicy());

        private ExecutorServiceHolder() {
        }
    }
}

