/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientFactory;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;

public class RestClient {
    protected String host;
    protected int port;
    protected Client client;
    protected boolean useSsl = false;

    public RestClient() {
        this("localhost", 4848, false, null, null);
    }

    public RestClient(String host, int port, boolean useSsl) {
        this(host, port, useSsl, null, null);
    }

    public RestClient(String host, int port, boolean useSsl, String user, String password) {
        this.host = host;
        this.port = port;
        this.useSsl = useSsl;
        this.client = ClientFactory.newClient();
        this.client.register(new CsrfProtectionFilter());
        if (user != null) {
            this.client.register(new HttpBasicAuthFilter(user, password));
        }
    }

    public String getRestUrl() {
        return (this.useSsl ? "https" : "http") + "://" + this.host + ":" + this.port + "/management";
    }
}

