/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.JerseyClientFactory;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ClientWrapper
implements Client {
    protected Client realClient = JerseyClientFactory.newClient();

    public ClientWrapper() {
        this(new HashMap<String, String>());
    }

    public ClientWrapper(Map<String, String> headers) {
        this(headers, null, null);
    }

    public ClientWrapper(final Map<String, String> headers, String userName, String password) {
        this.realClient.register(new MultiPartFeature());
        this.realClient.register(new JettisonFeature());
        this.realClient.register(new CsrfProtectionFilter());
        if (userName != null && password != null) {
            this.realClient.register(new HttpBasicAuthFilter(userName, password));
        }
        this.realClient.register(new ClientRequestFilter(){

            @Override
            public void filter(ClientRequestContext rc) throws IOException {
                for (Map.Entry entry : headers.entrySet()) {
                    rc.getHeaders().add((String)entry.getKey(), entry.getValue());
                }
            }
        });
    }

    @Override
    public void close() {
        this.realClient.close();
    }

    @Override
    public WebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        return this.realClient.target(uri);
    }

    @Override
    public WebTarget target(URI uri) throws NullPointerException {
        return this.realClient.target(uri);
    }

    @Override
    public WebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        return this.realClient.target(uriBuilder);
    }

    @Override
    public WebTarget target(Link link) throws NullPointerException {
        return this.realClient.target(link);
    }

    @Override
    public Invocation.Builder invocation(Link link) throws NullPointerException {
        return this.realClient.invocation(link);
    }

    @Override
    public Configuration getConfiguration() {
        return this.realClient.getConfiguration();
    }

    @Override
    public Client setProperty(String name, Object value) {
        this.realClient.setProperty(name, value);
        return this;
    }

    @Override
    public Client register(Class<?> componentClass) {
        this.realClient.register(componentClass);
        return this;
    }

    @Override
    public Client register(Class<?> componentClass, int bindingPriority) {
        this.realClient.register(componentClass, bindingPriority);
        return this;
    }

    @Override
    public Client register(Class<?> componentClass, Class<?> ... contracts) {
        this.realClient.register(componentClass, contracts);
        return this;
    }

    @Override
    public Client register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.realClient.register(componentClass, contracts);
        return this;
    }

    @Override
    public Client register(Object component) {
        this.realClient.register(component);
        return this;
    }

    @Override
    public Client register(Object component, int bindingPriority) {
        this.realClient.register(component, bindingPriority);
        return this;
    }

    @Override
    public Client register(Object component, Class<?> ... contracts) {
        this.realClient.register(component, contracts);
        return this;
    }

    @Override
    public Client register(Object component, Map<Class<?>, Integer> contracts) {
        this.realClient.register(component, contracts);
        return this;
    }

    @Override
    public Client replaceWith(Configuration config) {
        this.realClient.replaceWith(config);
        return this;
    }
}

