/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.admin.restconnector.RestConfig;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-rest-admin-config")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class)})
public class GetRestConfig
implements AdminCommand {
    @AccessRequired.To(value={"read"})
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    private ServiceLocator habitat;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        RestConfig restConfig = this.config.getExtensionByType(RestConfig.class);
        if (restConfig == null) {
            report.setMessage("debug=false, indentLevel=-1, showHiddenCommands=false, wadlGeneration=false, logOutput=false, logInput=false, showDeprecatedItems=false, sessionTokenTimeout=30");
            report.getTopMessagePart().addProperty("debug", "false");
            report.getTopMessagePart().addProperty("indentLevel", "-1");
            report.getTopMessagePart().addProperty("showHiddenCommands", "false");
            report.getTopMessagePart().addProperty("showDeprecatedItems", "false");
            report.getTopMessagePart().addProperty("wadlGeneration", "false");
            report.getTopMessagePart().addProperty("logOutput", "false");
            report.getTopMessagePart().addProperty("logInput", "false");
            report.getTopMessagePart().addProperty("sessionTokenTimeout", "30");
        } else {
            report.setMessage("debug=" + restConfig.getDebug() + ", indentLevel=" + restConfig.getIndentLevel() + ", showHiddenCommands=" + restConfig.getShowHiddenCommands() + ", wadlGeneration=" + restConfig.getWadlGeneration() + ", logOutput=" + restConfig.getLogOutput() + ", logInput=" + restConfig.getLogInput() + ", sessionTokenTimeout=" + restConfig.getSessionTokenTimeout());
            report.getTopMessagePart().addProperty("debug", restConfig.getDebug());
            report.getTopMessagePart().addProperty("indentLevel", restConfig.getIndentLevel());
            report.getTopMessagePart().addProperty("showHiddenCommands", restConfig.getShowHiddenCommands());
            report.getTopMessagePart().addProperty("showDeprecatedItems", restConfig.getShowDeprecatedItems());
            report.getTopMessagePart().addProperty("wadlGeneration", restConfig.getWadlGeneration());
            report.getTopMessagePart().addProperty("logOutput", restConfig.getLogOutput());
            report.getTopMessagePart().addProperty("logInput", restConfig.getLogInput());
            report.getTopMessagePart().addProperty("sessionTokenTimeout", "" + restConfig.getSessionTokenTimeout());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

