/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.cli;

import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.InvalidOperationException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchUserException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.common.ActionReporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service(name="__list-group-names")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=AuthRealm.class, opType=RestEndpoint.OpType.GET, path="list-group-names", description="List Group Names", params={@RestParam(name="realmName", value="$parent")})})
public class GetGroupNamesCommand
implements AdminCommand {
    @Inject
    Domain domain;
    @Param
    String realmName;
    @Param
    String userName;
    @Param(name="target", primary=true, optional=true, defaultValue="server")
    private String target;
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    @Inject
    private Configs configs;
    @Inject
    RealmsManager realmsManager;
    private static final LocalStringManagerImpl _localStrings = new LocalStringManagerImpl(GetGroupNamesCommand.class);

    @Override
    public void execute(AdminCommandContext context) {
        Config tmp = null;
        try {
            tmp = this.configs.getConfigByName(this.target);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (tmp != null) {
            this.config = tmp;
        }
        if (tmp == null) {
            Cluster cluster;
            Server targetServer = this.domain.getServerNamed(this.target);
            if (targetServer != null) {
                this.config = this.domain.getConfigNamed(targetServer.getConfigRef());
            }
            if ((cluster = this.domain.getClusterNamed(this.target)) != null) {
                this.config = this.domain.getConfigNamed(cluster.getConfigRef());
            }
        }
        ActionReporter report = (ActionReporter)context.getActionReport();
        try {
            String[] list = this.getGroupNames(this.realmName, this.userName);
            List<String> ret = Arrays.asList(list);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            Properties props = new Properties();
            props.put("groups", ret);
            report.setExtraProperties(props);
            report.setMessage("" + ret);
        }
        catch (NoSuchRealmException ex) {
            report.setFailureCause(ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (BadRealmException ex) {
            report.setFailureCause(ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (InvalidOperationException ex) {
            report.setFailureCause(ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        catch (NoSuchUserException ex) {
            report.setFailureCause(ex);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private String[] getGroupNames(String realmName, String userName) throws NoSuchRealmException, BadRealmException, InvalidOperationException, NoSuchUserException {
        this.realmsManager.refreshRealm(this.config.getName(), realmName);
        Realm r = this.realmsManager.getFromLoadedRealms(this.config.getName(), realmName);
        if (r != null) {
            return this.getGroupNames(r, userName);
        }
        List<AuthRealm> authRealmConfigs = this.config.getSecurityService().getAuthRealm();
        for (AuthRealm authRealm : authRealmConfigs) {
            if (!realmName.equals(authRealm.getName())) continue;
            List<Property> propConfigs = authRealm.getProperty();
            Properties props = new Properties();
            for (Property p : propConfigs) {
                String value = p.getValue();
                props.setProperty(p.getName(), value);
            }
            r = Realm.instantiate(authRealm.getName(), authRealm.getClassname(), props, this.config.getName());
            return this.getGroupNames(r, userName);
        }
        throw new NoSuchRealmException(_localStrings.getLocalString("NO_SUCH_REALM", "No Such Realm: {0}", realmName));
    }

    private String[] getGroupNames(Realm r, String userName) throws InvalidOperationException, NoSuchUserException {
        ArrayList l = new ArrayList();
        Enumeration groupNames = r.getGroupNames(userName);
        while (groupNames.hasMoreElements()) {
            l.add(groupNames.nextElement());
        }
        return l.toArray(new String[l.size()]);
    }
}

