/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.glassfish.admin.rest.composite.CompositeResource;
import org.glassfish.admin.rest.model.ResponseBody;
import org.glassfish.admin.rest.utils.Util;

@Provider
public class ExceptionFilter
implements ContainerResponseFilter {
    @Override
    public void filter(ContainerRequestContext reqCtx, ContainerResponseContext resCtx) throws IOException {
        if (!"application/vnd.oracle.glassfish+json".equals(reqCtx.getHeaderString("Accept"))) {
            return;
        }
        int status = resCtx.getStatus();
        if (status >= 200 && status <= 299) {
            return;
        }
        Object entity = resCtx.getEntity();
        if (!(entity instanceof String)) {
            return;
        }
        String errorMsg = (String)entity;
        ResponseBody wrappedEntity = Util.responseBody().addFailure(errorMsg);
        resCtx.setEntity(wrappedEntity, resCtx.getEntityAnnotations(), CompositeResource.MEDIA_TYPE_JSON_TYPE);
    }
}

