/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.monitor;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import com.sun.enterprise.module.ModuleLifecycleListener;
import com.sun.enterprise.module.ModuleState;
import com.sun.enterprise.module.ModulesRegistry;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.admin.monitor.FutureStatsProviders;
import org.glassfish.admin.monitor.MLogger;
import org.glassfish.admin.monitor.StatsProviderManagerDelegateImpl;
import org.glassfish.admin.monitor.StatsProviderRegistry;
import org.glassfish.admin.monitor.StatsProviderUtil;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.monitoring.ContainerMonitoring;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.probe.provider.StatsProviderInfo;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.flashlight.MonitoringRuntimeDataRegistry;
import org.glassfish.flashlight.client.ProbeClientMediator;
import org.glassfish.flashlight.impl.client.AgentAttacher;
import org.glassfish.flashlight.provider.ProbeProviderEventListener;
import org.glassfish.flashlight.provider.ProbeProviderFactory;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=1)
public class MonitoringBootstrap
implements PostConstruct,
PreDestroy,
EventListener,
ModuleLifecycleListener,
ConfigListener {
    @Inject
    private MonitoringRuntimeDataRegistry mrdr;
    @Inject
    private ModulesRegistry registry;
    @Inject
    protected ProbeProviderFactory probeProviderFactory;
    @Inject
    protected ProbeClientMediator pcm;
    @Inject
    Events events;
    @Inject
    ServerEnvironment serverEnv;
    @Inject
    @Named(value="default-instance-name")
    @Optional
    MonitoringService monitoringService = null;
    @Inject
    private ProbeRegistry probeRegistry;
    @Inject
    ServiceLocator habitat;
    @Inject
    Transactions transactions;
    private Domain domain;
    Map<String, Module> map = Collections.synchronizedMap(new WeakHashMap());
    List<String> appList = Collections.synchronizedList(new ArrayList());
    private static final String INSTALL_ROOT_URI_PROPERTY_NAME = "com.sun.aas.installRootURI";
    private static final Logger logger = MLogger.getLogger();
    private static final String PROBE_PROVIDER_CLASS_NAMES = "probe-provider-class-names";
    private static final String PROBE_PROVIDER_XML_FILE_NAMES = "probe-provider-xml-file-names";
    private static final String DELIMITER = ",";
    private StatsProviderManagerDelegateImpl spmd;
    private boolean monitoringEnabled;
    private boolean hasDiscoveredXMLProviders = false;

    @Override
    public void postConstruct() {
        this.domain = this.habitat.getService(Domain.class, new Annotation[0]);
        this.transactions.addListenerForType(ContainerMonitoring.class, this);
        this.transactions.addListenerForType(MonitoringService.class, this);
        this.transactions.addListenerForType(ModuleMonitoringLevels.class, this);
        this.monitoringEnabled = this.monitoringService != null ? Boolean.parseBoolean(this.monitoringService.getMonitoringEnabled()) : false;
        if (!this.monitoringEnabled) {
            return;
        }
        this.events.register(this);
        boolean isDiscoverXMLProbeProviders = false;
        this.enableMonitoringForProbeProviders(isDiscoverXMLProbeProviders);
    }

    private void discoverProbeProviders() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Discovering the ProbeProviders");
        }
        for (Module m : this.registry.getModules()) {
            if (m.getState() != ModuleState.READY && m.getState() != ModuleState.RESOLVED) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" In (discoverProbeProviders) ModuleState - " + (Object)((Object)m.getState()) + " : " + m.getName());
            }
            this.verifyModule(m);
        }
    }

    @Override
    public void preDestroy() {
        ProbeRegistry.cleanup();
        if (this.spmd != null) {
            this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.serverEnv.getInstanceName(), this.monitoringService);
            StatsProviderManager.setStatsProviderManagerDelegate(this.spmd);
        }
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Discovering the XML ProbeProviders from lib/monitor");
            }
            this.discoverXMLProviders();
        }
    }

    public void setStatsProviderManagerDelegate() {
        if (this.spmd != null) {
            return;
        }
        this.spmd = new StatsProviderManagerDelegateImpl(this.pcm, this.probeRegistry, this.mrdr, this.domain, this.serverEnv.getInstanceName(), this.monitoringService);
        StatsProviderManager.setStatsProviderManagerDelegate(this.spmd);
        StatsProviderUtil.setStatsProviderManagerDelegate(this.spmd);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" StatsProviderManagerDelegate is assigned");
        }
        AMXGlassfish amxg = AMXGlassfish.DEFAULT;
        amxg.listenForDomainRoot(ManagementFactory.getPlatformMBeanServer(), this.spmd);
    }

    @Override
    public void moduleResolved(Module module) {
        if (module == null) {
            return;
        }
        this.verifyModule(module);
    }

    @Override
    public synchronized void moduleStarted(Module module) {
        if (module == null) {
            return;
        }
        this.verifyModule(module);
    }

    private synchronized void verifyModule(Module module) {
        if (module == null) {
            return;
        }
        String str = module.getName();
        if (!this.map.containsKey(str)) {
            this.map.put(str, module);
            this.addProvider(module);
        }
    }

    public synchronized void registerProbes(String appName, File appDir, ClassLoader cl) {
        if (appName == null) {
            return;
        }
        if (cl == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Null classloader passed for application : {0}", appName);
            }
            return;
        }
        if (!this.appList.contains(appName)) {
            this.appList.add(appName);
            this.addProvider(appDir, cl);
        }
    }

    @Override
    public synchronized void moduleStopped(Module module) {
    }

    @Override
    public void moduleInstalled(Module module) {
    }

    @Override
    public void moduleUpdated(Module module) {
    }

    private void addProvider(Module module) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" Adding the Provider - verified the module");
        }
        ClassLoader mcl = module.getClassLoader();
        ModuleDefinition md = module.getModuleDefinition();
        Manifest mf = null;
        if (md != null) {
            mf = md.getManifest();
        }
        if (mf != null) {
            this.processManifest(mf, mcl);
        }
        this.handleFutureStatsProviders();
    }

    private void addProvider(File appDir, ClassLoader classLoader) {
        File manifestFile = new File(appDir, "META-INF" + File.separator + "MANIFEST.MF");
        String appDirPath = "";
        if (manifestFile != null) {
            Manifest mf;
            try {
                appDirPath = appDir.getCanonicalPath();
                FileInputStream fis = new FileInputStream(manifestFile);
                mf = new Manifest(fis);
            }
            catch (IOException ex) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Can''t access META-INF{0}MANIFEST.MF for {1}", new Object[]{File.separator, appDirPath});
                    logger.fine(ex.getLocalizedMessage());
                }
                return;
            }
            if (mf != null) {
                this.processManifest(mf, classLoader);
            }
        }
        this.handleFutureStatsProviders();
    }

    private void processManifest(Manifest mf, ClassLoader mcl) {
        if (mf != null) {
            Attributes attrs = mf.getMainAttributes();
            String cnames = null;
            String xnames = null;
            if (attrs != null) {
                StringTokenizer st;
                cnames = attrs.getValue(PROBE_PROVIDER_CLASS_NAMES);
                if (cnames != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("probe providers = " + cnames);
                    }
                    st = new StringTokenizer(cnames, DELIMITER);
                    while (st.hasMoreTokens()) {
                        try {
                            String clStr = st.nextToken();
                            if (clStr != null) {
                                clStr = clStr.trim();
                            }
                            if (mcl == null) continue;
                            this.processProbeProviderClass(mcl.loadClass(clStr));
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "MNTG0104", e);
                        }
                    }
                }
                if ((xnames = attrs.getValue(PROBE_PROVIDER_XML_FILE_NAMES)) != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("xnames = " + xnames);
                    }
                    st = new StringTokenizer(xnames, DELIMITER);
                    while (st.hasMoreTokens()) {
                        this.processProbeProviderXML(mcl, st.nextToken(), true);
                    }
                }
            }
        }
    }

    public void handleFutureStatsProviders() {
        if (FutureStatsProviders.isEmpty()) {
            return;
        }
        ArrayList<StatsProviderInfo> removeList = new ArrayList<StatsProviderInfo>();
        Iterator<StatsProviderInfo> it = FutureStatsProviders.iterator();
        while (it.hasNext()) {
            StatsProviderInfo spInfo = it.next();
            try {
                this.spmd.tryToRegister(spInfo);
                removeList.add(spInfo);
            }
            catch (RuntimeException re) {}
        }
        for (StatsProviderInfo spInfo : removeList) {
            FutureStatsProviders.remove(spInfo);
        }
    }

    private void discoverXMLProviders() {
        if (this.hasDiscoveredXMLProviders) {
            return;
        }
        try {
            URI xmlProviderDirStr = new URI(System.getProperty(INSTALL_ROOT_URI_PROPERTY_NAME) + "/" + "lib" + "/" + "monitor");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ProviderXML's Dir = " + xmlProviderDirStr.getPath());
            }
            File xmlProviderDir = new File(xmlProviderDirStr.getPath());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ProviderXML's Dir exists = " + xmlProviderDir.exists());
                logger.fine("ProviderXML's Dir path - " + xmlProviderDir.getAbsolutePath());
            }
            this.loadXMLProviders(xmlProviderDir);
            this.hasDiscoveredXMLProviders = true;
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "MNTG0105", ex);
        }
    }

    private void loadXMLProviders(File xmlProvidersDir) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                return name.endsWith(".xml");
            }
        };
        File[] files = xmlProvidersDir.listFiles(filter);
        if (files == null) {
            return;
        }
        HashMap<String, File> providerMap = new HashMap<String, File>();
        for (File file : files) {
            Module module;
            int index;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Found the provider xml - " + file.getAbsolutePath());
            }
            if ((index = file.getName().indexOf("-:")) == -1) continue;
            String moduleName = file.getName().substring(0, index);
            providerMap.put(moduleName, file);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" The provider xml belongs to - \"" + moduleName + "\"");
            }
            if (!this.map.containsKey(moduleName)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Module found (containsKey)");
            }
            if ((module = this.map.get(moduleName)) == null) {
                logger.log(Level.SEVERE, "MNTG0005", new Object[]{moduleName});
                continue;
            }
            ClassLoader mcl = module.getClassLoader();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("ModuleClassLoader = " + mcl);
                logger.fine("XML File path = " + file.getAbsolutePath());
            }
            this.processProbeProviderXML(mcl, file.getAbsolutePath(), false);
        }
    }

    private void processProbeProviderClass(Class cls) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("processProbeProviderClass for " + cls);
        }
        try {
            this.probeProviderFactory.getProbeProvider(cls);
        }
        catch (InstantiationException ex) {
            logger.log(Level.SEVERE, "MNTG0104", ex);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, "MNTG0104", ex);
        }
    }

    private void processProbeProviderXML(ClassLoader mcl, String xname, boolean inBundle) {
        this.probeProviderFactory.processXMLProbeProviders(mcl, xname, inBundle);
    }

    @Override
    public UnprocessedChangeEvents changed(PropertyChangeEvent[] propertyChangeEvents) {
        StatsProviderRegistry spr;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(" spmd = " + this.spmd);
        }
        StatsProviderRegistry statsProviderRegistry = spr = this.spmd == null ? null : this.spmd.getStatsProviderRegistry();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("spr = " + spr);
        }
        for (PropertyChangeEvent event : propertyChangeEvents) {
            boolean oldEnabled;
            if (event == null) continue;
            String propName = event.getPropertyName();
            Object oldVal = event.getOldValue();
            Object newVal = event.getNewValue();
            if (newVal == null || newVal.equals(oldVal) || !this.ok(propName)) continue;
            String level_change_mesg = "Level change event received, {0} New Level = {1}, Old Level = {2}";
            if (event.getSource() instanceof ModuleMonitoringLevels) {
                String oldEnabled2;
                String newEnabled = newVal.toString().toUpperCase(Locale.ENGLISH);
                String string = oldEnabled2 = oldVal == null ? "OFF" : oldVal.toString().toUpperCase(Locale.ENGLISH);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, level_change_mesg, new Object[]{propName, newEnabled, oldEnabled2});
                }
                if (newEnabled.equals(oldEnabled2) || spr == null) continue;
                this.handleLevelChange(propName, newEnabled);
                continue;
            }
            if (event.getSource() instanceof ContainerMonitoring) {
                String oldEnabled3;
                ContainerMonitoring cm = (ContainerMonitoring)event.getSource();
                String newEnabled = newVal.toString().toUpperCase(Locale.ENGLISH);
                String string = oldEnabled3 = oldVal == null ? "OFF" : oldVal.toString().toUpperCase(Locale.ENGLISH);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, level_change_mesg, new Object[]{propName, newEnabled, oldEnabled3});
                }
                if (newEnabled.equals(oldEnabled3) || spr == null) continue;
                this.handleLevelChange(cm.getName(), newEnabled);
                continue;
            }
            if (!(event.getSource() instanceof MonitoringService)) continue;
            boolean newEnabled = Boolean.parseBoolean(newVal.toString());
            boolean bl = oldVal == null ? !newEnabled : (oldEnabled = Boolean.parseBoolean(oldVal.toString()));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, level_change_mesg, new Object[]{propName, newEnabled, oldEnabled});
            }
            if (newEnabled == oldEnabled) continue;
            this.handleServiceChange(spr, propName, newEnabled);
        }
        return null;
    }

    private void handleLevelChange(String propName, String enabledStr) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("In handleLevelChange(), spmd = " + this.spmd + "  Enabled=" + enabledStr);
        }
        if (!this.ok(propName)) {
            return;
        }
        if (this.spmd == null) {
            return;
        }
        if (this.parseLevelsBoolean(enabledStr)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Enabling {0} monitoring to {1}", new Object[]{propName, enabledStr});
            }
            try {
                this.spmd.enableStatsProviders(propName);
            }
            catch (RuntimeException rte) {
                logger.log(Level.INFO, "MNTG0001", rte);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Disabling {0} monitoring", propName);
            }
            this.spmd.disableStatsProviders(propName);
        }
    }

    private void handleServiceChange(StatsProviderRegistry spr, String propName, boolean enabled) {
        if (!this.ok(propName)) {
            return;
        }
        if (propName.equals("mbean-enabled")) {
            if (spr == null) {
                return;
            }
            if (enabled) {
                logger.log(Level.INFO, "MNTG0109");
                this.spmd.registerAllGmbal();
            } else {
                logger.log(Level.INFO, "MNTG0110");
                this.spmd.unregisterAllGmbal();
            }
        } else if (propName.equals("dtrace-enabled")) {
            logger.log(Level.INFO, "MNTG0111");
            this.probeProviderFactory.dtraceEnabledChanged(enabled);
        } else if (propName.equals("monitoring-enabled")) {
            this.probeProviderFactory.monitoringEnabledChanged(enabled);
            if (enabled) {
                logger.log(Level.INFO, "MNTG0112");
                AgentAttacher.attachAgent();
                this.enableMonitoringForProbeProviders(true);
                this.spmd.updateAllStatsProviders();
            } else {
                logger.log(Level.INFO, "MNTG0113");
                this.disableMonitoringForProbeProviders();
                this.spmd.disableAllStatsProviders();
            }
        }
    }

    private void enableMonitoringForProbeProviders(boolean isDiscoverXMLProviders) {
        this.discoverProbeProviders();
        this.registry.register(this);
        if (isDiscoverXMLProviders) {
            this.discoverXMLProviders();
        }
        this.setStatsProviderManagerDelegate();
        this.probeProviderFactory.addProbeProviderEventListener(new ProcessProbes());
    }

    private void disableMonitoringForProbeProviders() {
        this.registry.unregister(this);
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private boolean parseLevelsBoolean(String s) {
        return !this.ok(s) || !s.equals("OFF");
    }

    private class ProcessProbes
    implements ProbeProviderEventListener {
        private ProcessProbes() {
        }

        @Override
        public <T> void probeProviderAdded(String moduleProviderName, String moduleName, String probeProviderName, String invokerId, Class<T> providerClazz, T provider) {
            MonitoringBootstrap.this.handleFutureStatsProviders();
        }
    }
}

