/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.glassfish.admin.mbeanserver.ssl.SSLParams;

public class SSLClientConfigurator {
    private SSLParams sslParams;
    private static volatile SSLClientConfigurator sslCC;
    private SSLContext sslContext;
    private SSLSocketFactory sslSocketFactory;
    private static final Logger _logger;
    private String[] enabledProtocols;
    private String[] enabledCipherSuites;

    private SSLClientConfigurator() {
    }

    public static SSLClientConfigurator getInstance() {
        if (sslCC == null) {
            sslCC = new SSLClientConfigurator();
            return sslCC;
        }
        return sslCC;
    }

    public void setSSLParams(SSLParams sslParams) {
        this.sslParams = sslParams;
    }

    public SSLContext configure(SSLParams sslParams) {
        String keyAlias;
        String algorithm;
        this.sslParams = sslParams;
        String protocol = sslParams.getProtocol();
        try {
            this.sslContext = SSLContext.getInstance(protocol);
        }
        catch (NoSuchAlgorithmException ex) {
            _logger.log(Level.SEVERE, null, ex);
        }
        this.configureCiphersAndProtocols();
        String trustAlgorithm = sslParams.getTrustAlgorithm();
        if (trustAlgorithm == null) {
            trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        }
        if ((algorithm = sslParams.getKeyAlgorithm()) == null) {
            algorithm = "SunX509";
        }
        if ((keyAlias = sslParams.getCertNickname()) == null) {
            keyAlias = "s1as";
        }
        try {
            this.sslContext.init(this.getKeyManagers(algorithm, keyAlias), this.getTrustManagers(trustAlgorithm), new SecureRandom());
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, null, ex);
        }
        return this.sslContext;
    }

    public String[] getEnabledProtocols() {
        if (this.enabledProtocols == null) {
            this.configureCiphersAndProtocols();
        }
        return this.enabledProtocols;
    }

    public String getEnabledProtocolsAsString() {
        if (this.getEnabledProtocols() != null && this.getEnabledProtocols().length > 0) {
            return this.toCommaSeparatedString(this.getEnabledProtocols());
        }
        return null;
    }

    public String[] getEnabledCipherSuites() {
        if (this.enabledCipherSuites == null) {
            this.configureCiphersAndProtocols();
        }
        return this.enabledCipherSuites;
    }

    public String getEnabledCipherSuitesAsString() {
        if (this.getEnabledCipherSuites() != null && this.getEnabledCipherSuites().length > 0) {
            return this.toCommaSeparatedString(this.getEnabledCipherSuites());
        }
        return null;
    }

    protected KeyManager[] getKeyManagers(String algorithm, String keyAlias) throws Exception {
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            _logger.log(Level.WARNING, " No keystores defined");
            return null;
        }
        _logger.log(Level.FINE, "Algorithm ::{0}", algorithm);
        _logger.log(Level.FINE, "Key Alias ::{0}", keyAlias);
        _logger.log(Level.FINE, "KeyStore Type ::{0}", this.sslParams.getKeyStoreType());
        String keystorePass = this.sslParams.getKeyStorePassword();
        KeyStore ks = this.getStore(this.sslParams.getKeyStoreType(), this.sslParams.getKeyStore().getPath(), keystorePass);
        if (keyAlias != null && !ks.isKeyEntry(keyAlias)) {
            _logger.log(Level.WARNING, "No Key store found for {0}", keyAlias);
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        kmf.init(ks, keystorePass.toCharArray());
        return kmf.getKeyManagers();
    }

    protected TrustManager[] getTrustManagers(String algorithm) throws Exception {
        String crlf = this.sslParams.getCrlFile();
        TrustManager[] tms = null;
        _logger.log(Level.FINE, "in getTrustManagers TrustManager type = {0} path = {1} password = {2}", new Object[]{this.sslParams.getTrustStoreType(), this.sslParams.getTrustStore().getPath(), this.sslParams.getTrustStorePassword()});
        KeyStore trustStore = this.getStore(this.sslParams.getTrustStoreType(), this.sslParams.getTrustStore().getPath(), this.sslParams.getTrustStorePassword());
        if (trustStore != null) {
            if (crlf == null) {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(trustStore);
                tms = tmf.getTrustManagers();
            } else {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                CertPathParameters params = this.getParameters(algorithm, crlf, trustStore);
                CertPathTrustManagerParameters mfp = new CertPathTrustManagerParameters(params);
                tmf.init(mfp);
                tms = tmf.getTrustManagers();
            }
        }
        return tms;
    }

    protected CertPathParameters getParameters(String algorithm, String crlf, KeyStore trustStore) throws Exception {
        PKIXBuilderParameters xparams;
        PKIXBuilderParameters params = null;
        if ("PKIX".equalsIgnoreCase(algorithm)) {
            xparams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            Collection<? extends CRL> crls = this.getCRLs(crlf);
            CollectionCertStoreParameters csp = new CollectionCertStoreParameters(crls);
            CertStore store = CertStore.getInstance("Collection", csp);
            xparams.addCertStore(store);
            xparams.setRevocationEnabled(true);
            String trustLength = this.sslParams.getTrustMaxCertLength();
            if (trustLength != null) {
                try {
                    xparams.setMaxPathLength(Integer.parseInt(trustLength));
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "Bad maxCertLength: {0}", trustLength);
                }
            }
        } else {
            throw new CRLException("CRLs not supported for type: " + algorithm);
        }
        params = xparams;
        return params;
    }

    protected Collection<? extends CRL> getCRLs(String crlf) throws IOException, CRLException, CertificateException {
        File crlFile = new File(crlf);
        if (!crlFile.isAbsolute()) {
            crlFile = new File(System.getProperty("catalina.base"), crlf);
        }
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlFile);
            crls = cf.generateCRLs(is);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (CRLException crle) {
            throw crle;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return crls;
    }

    private KeyStore getStore(String type2, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = KeyStore.getInstance(type2);
            if (!"PKCS11".equalsIgnoreCase(type2) && !"".equalsIgnoreCase(path)) {
                File keyStoreFile = new File(path);
                if (!keyStoreFile.isAbsolute()) {
                    keyStoreFile = new File(System.getProperty("catalina.base"), path);
                }
                istream = new FileInputStream(keyStoreFile);
            }
            ks.load(istream, pass.toCharArray());
        }
        catch (FileNotFoundException fnfe) {
            _logger.log(Level.SEVERE, "jsse.keystore_load_failed for:type = " + type2 + "path = " + path + fnfe.getMessage(), fnfe);
            throw fnfe;
        }
        catch (IOException ioe) {
            _logger.log(Level.SEVERE, "jsse.keystore_load_failed for:type = " + type2 + "path = " + path + ioe.getMessage(), ioe);
            throw ioe;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "jsse.keystore_load_failed for:type = " + type2 + "path = " + path + ex.getMessage(), ex);
            throw new IOException(ex.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ks;
    }

    private void configureCiphersAndProtocols() {
        String[] ciphers;
        String ssl2Ciphers;
        LinkedList<String> tmpSSLArtifactsList = new LinkedList<String>();
        System.out.println("SSLParams =" + this.sslParams);
        if (this.sslParams.getSsl2Enabled().booleanValue()) {
            tmpSSLArtifactsList.add("SSLv2");
        }
        if (this.sslParams.getSsl3Enabled().booleanValue()) {
            tmpSSLArtifactsList.add("SSLv3");
        }
        if (this.sslParams.getTlsEnabled().booleanValue()) {
            tmpSSLArtifactsList.add("TLSv1");
        }
        if (this.sslParams.getSsl3Enabled().booleanValue() || this.sslParams.getTlsEnabled().booleanValue()) {
            tmpSSLArtifactsList.add("SSLv2Hello");
        }
        if (tmpSSLArtifactsList.isEmpty()) {
            _logger.log(Level.WARNING, "All SSL protocol variants disabled for network-listener {0}, using SSL implementation specific defaults");
        } else {
            String[] protocols = new String[tmpSSLArtifactsList.size()];
            tmpSSLArtifactsList.toArray(protocols);
            this.enabledProtocols = protocols;
        }
        tmpSSLArtifactsList.clear();
        String ssl3Ciphers = this.sslParams.getSsl3TlsCiphers();
        if (ssl3Ciphers != null && ssl3Ciphers.length() > 0) {
            String[] ssl3CiphersArray;
            for (String cipher : ssl3CiphersArray = ssl3Ciphers.split(",")) {
                tmpSSLArtifactsList.add(cipher.trim());
            }
        }
        if ((ssl2Ciphers = this.sslParams.getSsl2Ciphers()) != null && ssl2Ciphers.length() > 0) {
            String[] ssl2CiphersArray;
            for (String cipher : ssl2CiphersArray = ssl2Ciphers.split(",")) {
                tmpSSLArtifactsList.add(cipher.trim());
            }
        }
        if ((ciphers = this.getJSSECiphers(tmpSSLArtifactsList)) == null || ciphers.length == 0) {
            _logger.log(Level.WARNING, "All SSL cipher suites disabled for network-listener(s) {0}.  Using SSL implementation specific defaults");
        } else {
            this.enabledCipherSuites = ciphers;
        }
    }

    private String[] getJSSECiphers(List<String> configuredCiphers) {
        HashSet<String> enabledCiphers = null;
        for (String cipher : configuredCiphers) {
            String jsseCipher;
            if (cipher.length() <= 0 || cipher.charAt(0) == '-') continue;
            if (cipher.charAt(0) == '+') {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = SSLClientConfigurator.getJSSECipher(cipher)) == null) {
                _logger.log(Level.WARNING, "Unknown cipher error");
                continue;
            }
            if (enabledCiphers == null) {
                enabledCiphers = new HashSet<String>(configuredCiphers.size());
            }
            enabledCiphers.add(jsseCipher);
        }
        return enabledCiphers == null ? null : enabledCiphers.toArray(new String[enabledCiphers.size()]);
    }

    private static String getJSSECipher(String cipher) {
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        return ci != null ? ci.getCipherName() : null;
    }

    private String toCommaSeparatedString(String[] strArray) {
        StringBuilder strBuf = new StringBuilder(strArray[0]);
        for (int i = 1; i < strArray.length; ++i) {
            strBuf.append(",");
            strBuf.append(strArray[i]);
        }
        return strBuf.toString();
    }

    static {
        _logger = Logger.getLogger(SSLClientConfigurator.class.getName());
    }

    private static final class CipherInfo {
        private static final short SSL2 = 1;
        private static final short SSL3 = 2;
        private static final short TLS = 4;
        private static final String[][] OLD_CIPHER_MAPPING = new String[][]{{"rsa_null_md5", "SSL_RSA_WITH_NULL_MD5"}, {"rsa_null_sha", "SSL_RSA_WITH_NULL_SHA"}, {"rsa_rc4_40_md5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"}, {"rsa_rc4_128_md5", "SSL_RSA_WITH_RC4_128_MD5"}, {"rsa_rc4_128_sha", "SSL_RSA_WITH_RC4_128_SHA"}, {"rsa_3des_sha", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"}, {"fips_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"rsa_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_MD5"}, {"SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_SHA"}};
        private static final Map<String, CipherInfo> ciphers = new HashMap<String, CipherInfo>();
        private final String cipherName;
        private final short protocolVersion;

        private CipherInfo(String cipherName, short protocolVersion) {
            this.cipherName = cipherName;
            this.protocolVersion = protocolVersion;
        }

        public static void updateCiphers(SSLContext sslContext) {
            SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
            for (String s : factory.getDefaultCipherSuites()) {
                ciphers.put(s, new CipherInfo(s, 6));
            }
        }

        public static CipherInfo getCipherInfo(String configName) {
            return ciphers.get(configName);
        }

        public String getCipherName() {
            return this.cipherName;
        }

        public boolean isSSL2() {
            return (this.protocolVersion & 1) == 1;
        }

        public boolean isSSL3() {
            return (this.protocolVersion & 2) == 2;
        }

        public boolean isTLS() {
            return (this.protocolVersion & 4) == 4;
        }

        static {
            int len = OLD_CIPHER_MAPPING.length;
            for (int i = 0; i < len; ++i) {
                String nonStdName = OLD_CIPHER_MAPPING[i][0];
                String stdName = OLD_CIPHER_MAPPING[i][1];
                ciphers.put(nonStdName, new CipherInfo(stdName, 6));
            }
        }
    }
}

