/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.cli.resources;

import com.sun.enterprise.config.serverbeans.ConfigBeansUtilities;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.RefContainer;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.admin.cli.resources.CLIUtil;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;

@TargetType(value={CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@ExecuteOn(value={RuntimeType.DAS})
@Service(name="list-resource-refs")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.resource.refs")
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="list-resource-refs", description="list-resource-refs")})
public class ListResourceRefs
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListResourceRefs.class);
    @Param(optional=true, primary=true)
    private String target = "server";
    @Inject
    private ConfigBeansUtilities configBeansUtilities;
    @Inject
    private Domain domain;
    @AccessRequired.To(value={"read"})
    private RefContainer refContainer;
    private List<ResourceRef> resourceRefs = null;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.refContainer = CLIUtil.chooseRefContainer(this.domain, this.target, this.configBeansUtilities);
        if (this.refContainer != null) {
            this.resourceRefs = this.refContainer.getResourceRef();
        }
        return true;
    }

    @Override
    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> accessChecks = new ArrayList<AccessRequired.AccessCheck>();
        for (ResourceRef rr : this.resourceRefs) {
            accessChecks.add(new AccessRequired.AccessCheck((ConfigBeanProxy)rr, "read", true));
        }
        return accessChecks;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            if (this.resourceRefs != null) {
                this.processResourceRefs(report, this.resourceRefs);
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.resource.refs.failed", "list-resource-refs failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }

    private void processResourceRefs(ActionReport report, List<ResourceRef> resourceRefs) {
        if (resourceRefs.isEmpty()) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(localStrings.getLocalString("NothingToList", "Nothing to List."));
        } else {
            for (ResourceRef ref : resourceRefs) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(ref.getRef());
            }
        }
    }
}

